/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recommendation pillar aggregates
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationPillarSpecificAggregates implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationPillarSpecificAggregates.Builder, RecommendationPillarSpecificAggregates> {
    private static final SdkField<RecommendationCostOptimizingAggregates> COST_OPTIMIZING_FIELD = SdkField
            .<RecommendationCostOptimizingAggregates> builder(MarshallingType.SDK_POJO).memberName("costOptimizing")
            .getter(getter(RecommendationPillarSpecificAggregates::costOptimizing)).setter(setter(Builder::costOptimizing))
            .constructor(RecommendationCostOptimizingAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costOptimizing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_OPTIMIZING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RecommendationCostOptimizingAggregates costOptimizing;

    private RecommendationPillarSpecificAggregates(BuilderImpl builder) {
        this.costOptimizing = builder.costOptimizing;
    }

    /**
     * <p>
     * Cost optimizing aggregates
     * </p>
     * 
     * @return Cost optimizing aggregates
     */
    public final RecommendationCostOptimizingAggregates costOptimizing() {
        return costOptimizing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costOptimizing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationPillarSpecificAggregates)) {
            return false;
        }
        RecommendationPillarSpecificAggregates other = (RecommendationPillarSpecificAggregates) obj;
        return Objects.equals(costOptimizing(), other.costOptimizing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationPillarSpecificAggregates").add("CostOptimizing", costOptimizing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "costOptimizing":
            return Optional.ofNullable(clazz.cast(costOptimizing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("costOptimizing", COST_OPTIMIZING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationPillarSpecificAggregates, T> g) {
        return obj -> g.apply((RecommendationPillarSpecificAggregates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationPillarSpecificAggregates> {
        /**
         * <p>
         * Cost optimizing aggregates
         * </p>
         * 
         * @param costOptimizing
         *        Cost optimizing aggregates
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costOptimizing(RecommendationCostOptimizingAggregates costOptimizing);

        /**
         * <p>
         * Cost optimizing aggregates
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationCostOptimizingAggregates.Builder} avoiding the need to create one manually via
         * {@link RecommendationCostOptimizingAggregates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationCostOptimizingAggregates.Builder#build()} is called
         * immediately and its result is passed to {@link #costOptimizing(RecommendationCostOptimizingAggregates)}.
         * 
         * @param costOptimizing
         *        a consumer that will call methods on {@link RecommendationCostOptimizingAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costOptimizing(RecommendationCostOptimizingAggregates)
         */
        default Builder costOptimizing(Consumer<RecommendationCostOptimizingAggregates.Builder> costOptimizing) {
            return costOptimizing(RecommendationCostOptimizingAggregates.builder().applyMutation(costOptimizing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RecommendationCostOptimizingAggregates costOptimizing;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationPillarSpecificAggregates model) {
            costOptimizing(model.costOptimizing);
        }

        public final RecommendationCostOptimizingAggregates.Builder getCostOptimizing() {
            return costOptimizing != null ? costOptimizing.toBuilder() : null;
        }

        public final void setCostOptimizing(RecommendationCostOptimizingAggregates.BuilderImpl costOptimizing) {
            this.costOptimizing = costOptimizing != null ? costOptimizing.build() : null;
        }

        @Override
        public final Builder costOptimizing(RecommendationCostOptimizingAggregates costOptimizing) {
            this.costOptimizing = costOptimizing;
            return this;
        }

        @Override
        public RecommendationPillarSpecificAggregates build() {
            return new RecommendationPillarSpecificAggregates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
