/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details regarding various fraud risk analyses performed against the current session state and streamed audio of the
 * speaker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FraudRiskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FraudRiskDetails.Builder, FraudRiskDetails> {
    private static final SdkField<KnownFraudsterRisk> KNOWN_FRAUDSTER_RISK_FIELD = SdkField
            .<KnownFraudsterRisk> builder(MarshallingType.SDK_POJO).memberName("KnownFraudsterRisk")
            .getter(getter(FraudRiskDetails::knownFraudsterRisk)).setter(setter(Builder::knownFraudsterRisk))
            .constructor(KnownFraudsterRisk::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownFraudsterRisk").build())
            .build();

    private static final SdkField<VoiceSpoofingRisk> VOICE_SPOOFING_RISK_FIELD = SdkField
            .<VoiceSpoofingRisk> builder(MarshallingType.SDK_POJO).memberName("VoiceSpoofingRisk")
            .getter(getter(FraudRiskDetails::voiceSpoofingRisk)).setter(setter(Builder::voiceSpoofingRisk))
            .constructor(VoiceSpoofingRisk::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceSpoofingRisk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWN_FRAUDSTER_RISK_FIELD,
            VOICE_SPOOFING_RISK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnownFraudsterRisk knownFraudsterRisk;

    private final VoiceSpoofingRisk voiceSpoofingRisk;

    private FraudRiskDetails(BuilderImpl builder) {
        this.knownFraudsterRisk = builder.knownFraudsterRisk;
        this.voiceSpoofingRisk = builder.voiceSpoofingRisk;
    }

    /**
     * <p>
     * The details resulting from 'Known Fraudster Risk' analysis of the speaker.
     * </p>
     * 
     * @return The details resulting from 'Known Fraudster Risk' analysis of the speaker.
     */
    public final KnownFraudsterRisk knownFraudsterRisk() {
        return knownFraudsterRisk;
    }

    /**
     * <p>
     * The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
     * </p>
     * 
     * @return The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
     */
    public final VoiceSpoofingRisk voiceSpoofingRisk() {
        return voiceSpoofingRisk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knownFraudsterRisk());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSpoofingRisk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudRiskDetails)) {
            return false;
        }
        FraudRiskDetails other = (FraudRiskDetails) obj;
        return Objects.equals(knownFraudsterRisk(), other.knownFraudsterRisk())
                && Objects.equals(voiceSpoofingRisk(), other.voiceSpoofingRisk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FraudRiskDetails").add("KnownFraudsterRisk", knownFraudsterRisk())
                .add("VoiceSpoofingRisk", voiceSpoofingRisk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KnownFraudsterRisk":
            return Optional.ofNullable(clazz.cast(knownFraudsterRisk()));
        case "VoiceSpoofingRisk":
            return Optional.ofNullable(clazz.cast(voiceSpoofingRisk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KnownFraudsterRisk", KNOWN_FRAUDSTER_RISK_FIELD);
        map.put("VoiceSpoofingRisk", VOICE_SPOOFING_RISK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FraudRiskDetails, T> g) {
        return obj -> g.apply((FraudRiskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FraudRiskDetails> {
        /**
         * <p>
         * The details resulting from 'Known Fraudster Risk' analysis of the speaker.
         * </p>
         * 
         * @param knownFraudsterRisk
         *        The details resulting from 'Known Fraudster Risk' analysis of the speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knownFraudsterRisk(KnownFraudsterRisk knownFraudsterRisk);

        /**
         * <p>
         * The details resulting from 'Known Fraudster Risk' analysis of the speaker.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnownFraudsterRisk.Builder} avoiding the
         * need to create one manually via {@link KnownFraudsterRisk#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnownFraudsterRisk.Builder#build()} is called immediately and its
         * result is passed to {@link #knownFraudsterRisk(KnownFraudsterRisk)}.
         * 
         * @param knownFraudsterRisk
         *        a consumer that will call methods on {@link KnownFraudsterRisk.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knownFraudsterRisk(KnownFraudsterRisk)
         */
        default Builder knownFraudsterRisk(Consumer<KnownFraudsterRisk.Builder> knownFraudsterRisk) {
            return knownFraudsterRisk(KnownFraudsterRisk.builder().applyMutation(knownFraudsterRisk).build());
        }

        /**
         * <p>
         * The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
         * </p>
         * 
         * @param voiceSpoofingRisk
         *        The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSpoofingRisk(VoiceSpoofingRisk voiceSpoofingRisk);

        /**
         * <p>
         * The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceSpoofingRisk.Builder} avoiding the
         * need to create one manually via {@link VoiceSpoofingRisk#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceSpoofingRisk.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSpoofingRisk(VoiceSpoofingRisk)}.
         * 
         * @param voiceSpoofingRisk
         *        a consumer that will call methods on {@link VoiceSpoofingRisk.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSpoofingRisk(VoiceSpoofingRisk)
         */
        default Builder voiceSpoofingRisk(Consumer<VoiceSpoofingRisk.Builder> voiceSpoofingRisk) {
            return voiceSpoofingRisk(VoiceSpoofingRisk.builder().applyMutation(voiceSpoofingRisk).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnownFraudsterRisk knownFraudsterRisk;

        private VoiceSpoofingRisk voiceSpoofingRisk;

        private BuilderImpl() {
        }

        private BuilderImpl(FraudRiskDetails model) {
            knownFraudsterRisk(model.knownFraudsterRisk);
            voiceSpoofingRisk(model.voiceSpoofingRisk);
        }

        public final KnownFraudsterRisk.Builder getKnownFraudsterRisk() {
            return knownFraudsterRisk != null ? knownFraudsterRisk.toBuilder() : null;
        }

        public final void setKnownFraudsterRisk(KnownFraudsterRisk.BuilderImpl knownFraudsterRisk) {
            this.knownFraudsterRisk = knownFraudsterRisk != null ? knownFraudsterRisk.build() : null;
        }

        @Override
        public final Builder knownFraudsterRisk(KnownFraudsterRisk knownFraudsterRisk) {
            this.knownFraudsterRisk = knownFraudsterRisk;
            return this;
        }

        public final VoiceSpoofingRisk.Builder getVoiceSpoofingRisk() {
            return voiceSpoofingRisk != null ? voiceSpoofingRisk.toBuilder() : null;
        }

        public final void setVoiceSpoofingRisk(VoiceSpoofingRisk.BuilderImpl voiceSpoofingRisk) {
            this.voiceSpoofingRisk = voiceSpoofingRisk != null ? voiceSpoofingRisk.build() : null;
        }

        @Override
        public final Builder voiceSpoofingRisk(VoiceSpoofingRisk voiceSpoofingRisk) {
            this.voiceSpoofingRisk = voiceSpoofingRisk;
            return this;
        }

        @Override
        public FraudRiskDetails build() {
            return new FraudRiskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
