/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.EnrollmentJobFraudDetectionConfig;
import software.amazon.awssdk.services.voiceid.model.ExistingEnrollmentAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnrollmentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnrollmentConfig> {
    private static final SdkField<String> EXISTING_ENROLLMENT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExistingEnrollmentAction").getter(EnrollmentConfig.getter(EnrollmentConfig::existingEnrollmentActionAsString)).setter(EnrollmentConfig.setter(Builder::existingEnrollmentAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingEnrollmentAction").build()}).build();
    private static final SdkField<EnrollmentJobFraudDetectionConfig> FRAUD_DETECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FraudDetectionConfig").getter(EnrollmentConfig.getter(EnrollmentConfig::fraudDetectionConfig)).setter(EnrollmentConfig.setter(Builder::fraudDetectionConfig)).constructor(EnrollmentJobFraudDetectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudDetectionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXISTING_ENROLLMENT_ACTION_FIELD, FRAUD_DETECTION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnrollmentConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String existingEnrollmentAction;
    private final EnrollmentJobFraudDetectionConfig fraudDetectionConfig;

    private EnrollmentConfig(BuilderImpl builder) {
        this.existingEnrollmentAction = builder.existingEnrollmentAction;
        this.fraudDetectionConfig = builder.fraudDetectionConfig;
    }

    public final ExistingEnrollmentAction existingEnrollmentAction() {
        return ExistingEnrollmentAction.fromValue(this.existingEnrollmentAction);
    }

    public final String existingEnrollmentActionAsString() {
        return this.existingEnrollmentAction;
    }

    public final EnrollmentJobFraudDetectionConfig fraudDetectionConfig() {
        return this.fraudDetectionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.existingEnrollmentActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fraudDetectionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnrollmentConfig)) {
            return false;
        }
        EnrollmentConfig other = (EnrollmentConfig)obj;
        return Objects.equals(this.existingEnrollmentActionAsString(), other.existingEnrollmentActionAsString()) && Objects.equals(this.fraudDetectionConfig(), other.fraudDetectionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"EnrollmentConfig").add("ExistingEnrollmentAction", (Object)this.existingEnrollmentActionAsString()).add("FraudDetectionConfig", (Object)this.fraudDetectionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExistingEnrollmentAction": {
                return Optional.ofNullable(clazz.cast(this.existingEnrollmentActionAsString()));
            }
            case "FraudDetectionConfig": {
                return Optional.ofNullable(clazz.cast(this.fraudDetectionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExistingEnrollmentAction", EXISTING_ENROLLMENT_ACTION_FIELD);
        map.put("FraudDetectionConfig", FRAUD_DETECTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnrollmentConfig, T> g) {
        return obj -> g.apply((EnrollmentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String existingEnrollmentAction;
        private EnrollmentJobFraudDetectionConfig fraudDetectionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EnrollmentConfig model) {
            this.existingEnrollmentAction(model.existingEnrollmentAction);
            this.fraudDetectionConfig(model.fraudDetectionConfig);
        }

        public final String getExistingEnrollmentAction() {
            return this.existingEnrollmentAction;
        }

        public final void setExistingEnrollmentAction(String existingEnrollmentAction) {
            this.existingEnrollmentAction = existingEnrollmentAction;
        }

        @Override
        public final Builder existingEnrollmentAction(String existingEnrollmentAction) {
            this.existingEnrollmentAction = existingEnrollmentAction;
            return this;
        }

        @Override
        public final Builder existingEnrollmentAction(ExistingEnrollmentAction existingEnrollmentAction) {
            this.existingEnrollmentAction(existingEnrollmentAction == null ? null : existingEnrollmentAction.toString());
            return this;
        }

        public final EnrollmentJobFraudDetectionConfig.Builder getFraudDetectionConfig() {
            return this.fraudDetectionConfig != null ? this.fraudDetectionConfig.toBuilder() : null;
        }

        public final void setFraudDetectionConfig(EnrollmentJobFraudDetectionConfig.BuilderImpl fraudDetectionConfig) {
            this.fraudDetectionConfig = fraudDetectionConfig != null ? fraudDetectionConfig.build() : null;
        }

        @Override
        public final Builder fraudDetectionConfig(EnrollmentJobFraudDetectionConfig fraudDetectionConfig) {
            this.fraudDetectionConfig = fraudDetectionConfig;
            return this;
        }

        public EnrollmentConfig build() {
            return new EnrollmentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnrollmentConfig> {
        public Builder existingEnrollmentAction(String var1);

        public Builder existingEnrollmentAction(ExistingEnrollmentAction var1);

        public Builder fraudDetectionConfig(EnrollmentJobFraudDetectionConfig var1);

        default public Builder fraudDetectionConfig(Consumer<EnrollmentJobFraudDetectionConfig.Builder> fraudDetectionConfig) {
            return this.fraudDetectionConfig((EnrollmentJobFraudDetectionConfig)((EnrollmentJobFraudDetectionConfig.Builder)EnrollmentJobFraudDetectionConfig.builder().applyMutation(fraudDetectionConfig)).build());
        }
    }
}

