/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.ResponseWatchlistIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FraudsterSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FraudsterSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(FraudsterSummary.getter(FraudsterSummary::createdAt)).setter(FraudsterSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(FraudsterSummary.getter(FraudsterSummary::domainId)).setter(FraudsterSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> GENERATED_FRAUDSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedFraudsterId").getter(FraudsterSummary.getter(FraudsterSummary::generatedFraudsterId)).setter(FraudsterSummary.setter(Builder::generatedFraudsterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedFraudsterId").build()}).build();
    private static final SdkField<List<String>> WATCHLIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WatchlistIds").getter(FraudsterSummary.getter(FraudsterSummary::watchlistIds)).setter(FraudsterSummary.setter(Builder::watchlistIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DOMAIN_ID_FIELD, GENERATED_FRAUDSTER_ID_FIELD, WATCHLIST_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FraudsterSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String domainId;
    private final String generatedFraudsterId;
    private final List<String> watchlistIds;

    private FraudsterSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.domainId = builder.domainId;
        this.generatedFraudsterId = builder.generatedFraudsterId;
        this.watchlistIds = builder.watchlistIds;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String generatedFraudsterId() {
        return this.generatedFraudsterId;
    }

    public final boolean hasWatchlistIds() {
        return this.watchlistIds != null && !(this.watchlistIds instanceof SdkAutoConstructList);
    }

    public final List<String> watchlistIds() {
        return this.watchlistIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFraudsterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatchlistIds() ? this.watchlistIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudsterSummary)) {
            return false;
        }
        FraudsterSummary other = (FraudsterSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.generatedFraudsterId(), other.generatedFraudsterId()) && this.hasWatchlistIds() == other.hasWatchlistIds() && Objects.equals(this.watchlistIds(), other.watchlistIds());
    }

    public final String toString() {
        return ToString.builder((String)"FraudsterSummary").add("CreatedAt", (Object)this.createdAt()).add("DomainId", (Object)this.domainId()).add("GeneratedFraudsterId", (Object)this.generatedFraudsterId()).add("WatchlistIds", this.hasWatchlistIds() ? this.watchlistIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "GeneratedFraudsterId": {
                return Optional.ofNullable(clazz.cast(this.generatedFraudsterId()));
            }
            case "WatchlistIds": {
                return Optional.ofNullable(clazz.cast(this.watchlistIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("GeneratedFraudsterId", GENERATED_FRAUDSTER_ID_FIELD);
        map.put("WatchlistIds", WATCHLIST_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FraudsterSummary, T> g) {
        return obj -> g.apply((FraudsterSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String domainId;
        private String generatedFraudsterId;
        private List<String> watchlistIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FraudsterSummary model) {
            this.createdAt(model.createdAt);
            this.domainId(model.domainId);
            this.generatedFraudsterId(model.generatedFraudsterId);
            this.watchlistIds(model.watchlistIds);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGeneratedFraudsterId() {
            return this.generatedFraudsterId;
        }

        public final void setGeneratedFraudsterId(String generatedFraudsterId) {
            this.generatedFraudsterId = generatedFraudsterId;
        }

        @Override
        public final Builder generatedFraudsterId(String generatedFraudsterId) {
            this.generatedFraudsterId = generatedFraudsterId;
            return this;
        }

        public final Collection<String> getWatchlistIds() {
            if (this.watchlistIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.watchlistIds;
        }

        public final void setWatchlistIds(Collection<String> watchlistIds) {
            this.watchlistIds = ResponseWatchlistIdsCopier.copy(watchlistIds);
        }

        @Override
        public final Builder watchlistIds(Collection<String> watchlistIds) {
            this.watchlistIds = ResponseWatchlistIdsCopier.copy(watchlistIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchlistIds(String ... watchlistIds) {
            this.watchlistIds(Arrays.asList(watchlistIds));
            return this;
        }

        public FraudsterSummary build() {
            return new FraudsterSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FraudsterSummary> {
        public Builder createdAt(Instant var1);

        public Builder domainId(String var1);

        public Builder generatedFraudsterId(String var1);

        public Builder watchlistIds(Collection<String> var1);

        public Builder watchlistIds(String ... var1);
    }
}

