/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpSetResponse extends WafResponse implements ToCopyableBuilder<GetIpSetResponse.Builder, GetIpSetResponse> {
    private static final SdkField<IPSet> IP_SET_FIELD = SdkField.<IPSet> builder(MarshallingType.SDK_POJO).memberName("IPSet")
            .getter(getter(GetIpSetResponse::ipSet)).setter(setter(Builder::ipSet)).constructor(IPSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IPSet ipSet;

    private GetIpSetResponse(BuilderImpl builder) {
        super(builder);
        this.ipSet = builder.ipSet;
    }

    /**
     * <p>
     * Information about the <a>IPSet</a> that you specified in the <code>GetIPSet</code> request. For more information,
     * see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>IPSet</a>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IPSetDescriptors</code>: Contains an array of <a>IPSetDescriptor</a> objects. Each
     * <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the <a>IPSet</a> that you specified in the <code>GetIPSet</code> request. For more
     *         information, see the following topics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>IPSet</a>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IPSetDescriptors</code>: Contains an array of <a>IPSetDescriptor</a> objects. Each
     *         <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code>
     *         </p>
     *         </li>
     */
    public final IPSet ipSet() {
        return ipSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpSetResponse)) {
            return false;
        }
        GetIpSetResponse other = (GetIpSetResponse) obj;
        return Objects.equals(ipSet(), other.ipSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIpSetResponse").add("IPSet", ipSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPSet":
            return Optional.ofNullable(clazz.cast(ipSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IPSet", IP_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpSetResponse, T> g) {
        return obj -> g.apply((GetIpSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIpSetResponse> {
        /**
         * <p>
         * Information about the <a>IPSet</a> that you specified in the <code>GetIPSet</code> request. For more
         * information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSet</a>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPSetDescriptors</code>: Contains an array of <a>IPSetDescriptor</a> objects. Each
         * <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param ipSet
         *        Information about the <a>IPSet</a> that you specified in the <code>GetIPSet</code> request. For more
         *        information, see the following topics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>IPSet</a>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IPSetDescriptors</code>: Contains an array of <a>IPSetDescriptor</a> objects. Each
         *        <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSet(IPSet ipSet);

        /**
         * <p>
         * Information about the <a>IPSet</a> that you specified in the <code>GetIPSet</code> request. For more
         * information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>IPSet</a>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPSetDescriptors</code>: Contains an array of <a>IPSetDescriptor</a> objects. Each
         * <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link IPSet.Builder} avoiding the need to
         * create one manually via {@link IPSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IPSet.Builder#build()} is called immediately and its result is
         * passed to {@link #ipSet(IPSet)}.
         * 
         * @param ipSet
         *        a consumer that will call methods on {@link IPSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipSet(IPSet)
         */
        default Builder ipSet(Consumer<IPSet.Builder> ipSet) {
            return ipSet(IPSet.builder().applyMutation(ipSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private IPSet ipSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpSetResponse model) {
            super(model);
            ipSet(model.ipSet);
        }

        public final IPSet.Builder getIpSet() {
            return ipSet != null ? ipSet.toBuilder() : null;
        }

        public final void setIpSet(IPSet.BuilderImpl ipSet) {
            this.ipSet = ipSet != null ? ipSet.build() : null;
        }

        @Override
        public final Builder ipSet(IPSet ipSet) {
            this.ipSet = ipSet;
            return this;
        }

        @Override
        public GetIpSetResponse build() {
            return new GetIpSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
