/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Returned by <a>ListRegexMatchSets</a>. Each <code>RegexMatchSetSummary</code> object includes the <code>Name</code>
 * and <code>RegexMatchSetId</code> for one <a>RegexMatchSet</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexMatchSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RegexMatchSetSummary.Builder, RegexMatchSetSummary> {
    private static final SdkField<String> REGEX_MATCH_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexMatchSetId").getter(getter(RegexMatchSetSummary::regexMatchSetId))
            .setter(setter(Builder::regexMatchSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexMatchSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RegexMatchSetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_MATCH_SET_ID_FIELD,
            NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regexMatchSetId;

    private final String name;

    private RegexMatchSetSummary(BuilderImpl builder) {
        this.regexMatchSetId = builder.regexMatchSetId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get
     * information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a
     * <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS WAF.
     * </p>
     * <p>
     * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     * </p>
     * 
     * @return The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code>
     *         to get information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a
     *         <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS
     *         WAF.</p>
     *         <p>
     *         <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
     */
    public final String regexMatchSetId() {
        return regexMatchSetId;
    }

    /**
     * <p>
     * A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you create a
     * <code>RegexMatchSet</code>.
     * </p>
     * 
     * @return A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you
     *         create a <code>RegexMatchSet</code>.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSetSummary)) {
            return false;
        }
        RegexMatchSetSummary other = (RegexMatchSetSummary) obj;
        return Objects.equals(regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegexMatchSetSummary").add("RegexMatchSetId", regexMatchSetId()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegexMatchSetId":
            return Optional.ofNullable(clazz.cast(regexMatchSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegexMatchSetId", REGEX_MATCH_SET_ID_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegexMatchSetSummary, T> g) {
        return obj -> g.apply((RegexMatchSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexMatchSetSummary> {
        /**
         * <p>
         * The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to
         * get information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a
         * <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS WAF.
         * </p>
         * <p>
         * <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.
         * </p>
         * 
         * @param regexMatchSetId
         *        The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use
         *        <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code>, update a
         *        <code>RegexMatchSet</code>, remove a <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a
         *        <code>RegexMatchSet</code> from AWS WAF.</p>
         *        <p>
         *        <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
         *        <a>ListRegexMatchSets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexMatchSetId(String regexMatchSetId);

        /**
         * <p>
         * A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you
         * create a <code>RegexMatchSet</code>.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after
         *        you create a <code>RegexMatchSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String regexMatchSetId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSetSummary model) {
            regexMatchSetId(model.regexMatchSetId);
            name(model.name);
        }

        public final String getRegexMatchSetId() {
            return regexMatchSetId;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RegexMatchSetSummary build() {
            return new RegexMatchSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
