/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.FailureReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChallengeResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChallengeResponse> {
    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResponseCode").getter(ChallengeResponse.getter(ChallengeResponse::responseCode)).setter(ChallengeResponse.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()}).build();
    private static final SdkField<Long> SOLVE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SolveTimestamp").getter(ChallengeResponse.getter(ChallengeResponse::solveTimestamp)).setter(ChallengeResponse.setter(Builder::solveTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolveTimestamp").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(ChallengeResponse.getter(ChallengeResponse::failureReasonAsString)).setter(ChallengeResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_CODE_FIELD, SOLVE_TIMESTAMP_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResponseCode", RESPONSE_CODE_FIELD);
            this.put("SolveTimestamp", SOLVE_TIMESTAMP_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer responseCode;
    private final Long solveTimestamp;
    private final String failureReason;

    private ChallengeResponse(BuilderImpl builder) {
        this.responseCode = builder.responseCode;
        this.solveTimestamp = builder.solveTimestamp;
        this.failureReason = builder.failureReason;
    }

    public final Integer responseCode() {
        return this.responseCode;
    }

    public final Long solveTimestamp() {
        return this.solveTimestamp;
    }

    public final FailureReason failureReason() {
        return FailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.solveTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChallengeResponse)) {
            return false;
        }
        ChallengeResponse other = (ChallengeResponse)obj;
        return Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.solveTimestamp(), other.solveTimestamp()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChallengeResponse").add("ResponseCode", (Object)this.responseCode()).add("SolveTimestamp", (Object)this.solveTimestamp()).add("FailureReason", (Object)this.failureReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "SolveTimestamp": {
                return Optional.ofNullable(clazz.cast(this.solveTimestamp()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChallengeResponse, T> g) {
        return obj -> g.apply((ChallengeResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer responseCode;
        private Long solveTimestamp;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ChallengeResponse model) {
            this.responseCode(model.responseCode);
            this.solveTimestamp(model.solveTimestamp);
            this.failureReason(model.failureReason);
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final Long getSolveTimestamp() {
            return this.solveTimestamp;
        }

        public final void setSolveTimestamp(Long solveTimestamp) {
            this.solveTimestamp = solveTimestamp;
        }

        @Override
        public final Builder solveTimestamp(Long solveTimestamp) {
            this.solveTimestamp = solveTimestamp;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public ChallengeResponse build() {
            return new ChallengeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChallengeResponse> {
        public Builder responseCode(Integer var1);

        public Builder solveTimestamp(Long var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);
    }
}

