/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.RuleGroupSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.RuleGroupSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleGroupsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListRuleGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListRuleGroupsResponse.getter(ListRuleGroupsResponse::nextMarker)).setter(ListRuleGroupsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<RuleGroupSummary>> RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroups").getter(ListRuleGroupsResponse.getter(ListRuleGroupsResponse::ruleGroups)).setter(ListRuleGroupsResponse.setter(Builder::ruleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, RULE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextMarker", NEXT_MARKER_FIELD);
            this.put("RuleGroups", RULE_GROUPS_FIELD);
        }
    });
    private final String nextMarker;
    private final List<RuleGroupSummary> ruleGroups;

    private ListRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.ruleGroups = builder.ruleGroups;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasRuleGroups() {
        return this.ruleGroups != null && !(this.ruleGroups instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupSummary> ruleGroups() {
        return this.ruleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroups() ? this.ruleGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleGroupsResponse)) {
            return false;
        }
        ListRuleGroupsResponse other = (ListRuleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasRuleGroups() == other.hasRuleGroups() && Objects.equals(this.ruleGroups(), other.ruleGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListRuleGroupsResponse").add("NextMarker", (Object)this.nextMarker()).add("RuleGroups", this.hasRuleGroups() ? this.ruleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "RuleGroups": {
                return Optional.ofNullable(clazz.cast(this.ruleGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListRuleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<RuleGroupSummary> ruleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleGroupsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.ruleGroups(model.ruleGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<RuleGroupSummary.Builder> getRuleGroups() {
            List<RuleGroupSummary.Builder> result = RuleGroupSummariesCopier.copyToBuilder(this.ruleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroups(Collection<RuleGroupSummary.BuilderImpl> ruleGroups) {
            this.ruleGroups = RuleGroupSummariesCopier.copyFromBuilder(ruleGroups);
        }

        @Override
        public final Builder ruleGroups(Collection<RuleGroupSummary> ruleGroups) {
            this.ruleGroups = RuleGroupSummariesCopier.copy(ruleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(RuleGroupSummary ... ruleGroups) {
            this.ruleGroups(Arrays.asList(ruleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroups(Consumer<RuleGroupSummary.Builder> ... ruleGroups) {
            this.ruleGroups(Stream.of(ruleGroups).map(c -> (RuleGroupSummary)((RuleGroupSummary.Builder)RuleGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRuleGroupsResponse build() {
            return new ListRuleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRuleGroupsResponse> {
        public Builder nextMarker(String var1);

        public Builder ruleGroups(Collection<RuleGroupSummary> var1);

        public Builder ruleGroups(RuleGroupSummary ... var1);

        public Builder ruleGroups(Consumer<RuleGroupSummary.Builder> ... var1);
    }
}

