/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCodeFailureCodesCopier;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCodeSuccessCodesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseInspectionStatusCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseInspectionStatusCode> {
    private static final SdkField<List<Integer>> SUCCESS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessCodes").getter(ResponseInspectionStatusCode.getter(ResponseInspectionStatusCode::successCodes)).setter(ResponseInspectionStatusCode.setter(Builder::successCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> FAILURE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailureCodes").getter(ResponseInspectionStatusCode.getter(ResponseInspectionStatusCode::failureCodes)).setter(ResponseInspectionStatusCode.setter(Builder::failureCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_CODES_FIELD, FAILURE_CODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SuccessCodes", SUCCESS_CODES_FIELD);
            this.put("FailureCodes", FAILURE_CODES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<Integer> successCodes;
    private final List<Integer> failureCodes;

    private ResponseInspectionStatusCode(BuilderImpl builder) {
        this.successCodes = builder.successCodes;
        this.failureCodes = builder.failureCodes;
    }

    public final boolean hasSuccessCodes() {
        return this.successCodes != null && !(this.successCodes instanceof SdkAutoConstructList);
    }

    public final List<Integer> successCodes() {
        return this.successCodes;
    }

    public final boolean hasFailureCodes() {
        return this.failureCodes != null && !(this.failureCodes instanceof SdkAutoConstructList);
    }

    public final List<Integer> failureCodes() {
        return this.failureCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessCodes() ? this.successCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureCodes() ? this.failureCodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspectionStatusCode)) {
            return false;
        }
        ResponseInspectionStatusCode other = (ResponseInspectionStatusCode)obj;
        return this.hasSuccessCodes() == other.hasSuccessCodes() && Objects.equals(this.successCodes(), other.successCodes()) && this.hasFailureCodes() == other.hasFailureCodes() && Objects.equals(this.failureCodes(), other.failureCodes());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseInspectionStatusCode").add("SuccessCodes", this.hasSuccessCodes() ? this.successCodes() : null).add("FailureCodes", this.hasFailureCodes() ? this.failureCodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessCodes": {
                return Optional.ofNullable(clazz.cast(this.successCodes()));
            }
            case "FailureCodes": {
                return Optional.ofNullable(clazz.cast(this.failureCodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResponseInspectionStatusCode, T> g) {
        return obj -> g.apply((ResponseInspectionStatusCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> successCodes = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> failureCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseInspectionStatusCode model) {
            this.successCodes(model.successCodes);
            this.failureCodes(model.failureCodes);
        }

        public final Collection<Integer> getSuccessCodes() {
            if (this.successCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successCodes;
        }

        public final void setSuccessCodes(Collection<Integer> successCodes) {
            this.successCodes = ResponseInspectionStatusCodeSuccessCodesCopier.copy(successCodes);
        }

        @Override
        public final Builder successCodes(Collection<Integer> successCodes) {
            this.successCodes = ResponseInspectionStatusCodeSuccessCodesCopier.copy(successCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successCodes(Integer ... successCodes) {
            this.successCodes(Arrays.asList(successCodes));
            return this;
        }

        public final Collection<Integer> getFailureCodes() {
            if (this.failureCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureCodes;
        }

        public final void setFailureCodes(Collection<Integer> failureCodes) {
            this.failureCodes = ResponseInspectionStatusCodeFailureCodesCopier.copy(failureCodes);
        }

        @Override
        public final Builder failureCodes(Collection<Integer> failureCodes) {
            this.failureCodes = ResponseInspectionStatusCodeFailureCodesCopier.copy(failureCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureCodes(Integer ... failureCodes) {
            this.failureCodes(Arrays.asList(failureCodes));
            return this;
        }

        public ResponseInspectionStatusCode build() {
            return new ResponseInspectionStatusCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseInspectionStatusCode> {
        public Builder successCodes(Collection<Integer> var1);

        public Builder successCodes(Integer ... var1);

        public Builder failureCodes(Collection<Integer> var1);

        public Builder failureCodes(Integer ... var1);
    }
}

