/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result from the inspection of the web request for a valid <code>CAPTCHA</code> token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptchaResponse implements SdkPojo, Serializable, ToCopyableBuilder<CaptchaResponse.Builder, CaptchaResponse> {
    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResponseCode").getter(getter(CaptchaResponse::responseCode)).setter(setter(Builder::responseCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()).build();

    private static final SdkField<Long> SOLVE_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SolveTimestamp").getter(getter(CaptchaResponse::solveTimestamp)).setter(setter(Builder::solveTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolveTimestamp").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(CaptchaResponse::failureReasonAsString))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_CODE_FIELD,
            SOLVE_TIMESTAMP_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer responseCode;

    private final Long solveTimestamp;

    private final String failureReason;

    private CaptchaResponse(BuilderImpl builder) {
        this.responseCode = builder.responseCode;
        this.solveTimestamp = builder.solveTimestamp;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The HTTP response code indicating the status of the <code>CAPTCHA</code> token in the web request. If the token
     * is missing, invalid, or expired, this code is <code>405 Method Not Allowed</code>.
     * </p>
     * 
     * @return The HTTP response code indicating the status of the <code>CAPTCHA</code> token in the web request. If the
     *         token is missing, invalid, or expired, this code is <code>405 Method Not Allowed</code>.
     */
    public final Integer responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * The time that the <code>CAPTCHA</code> was last solved for the supplied token.
     * </p>
     * 
     * @return The time that the <code>CAPTCHA</code> was last solved for the supplied token.
     */
    public final Long solveTimestamp() {
        return solveTimestamp;
    }

    /**
     * <p>
     * The reason for failure, populated when the evaluation of the token fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReason}
     * will return {@link FailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureReasonAsString}.
     * </p>
     * 
     * @return The reason for failure, populated when the evaluation of the token fails.
     * @see FailureReason
     */
    public final FailureReason failureReason() {
        return FailureReason.fromValue(failureReason);
    }

    /**
     * <p>
     * The reason for failure, populated when the evaluation of the token fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReason}
     * will return {@link FailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureReasonAsString}.
     * </p>
     * 
     * @return The reason for failure, populated when the evaluation of the token fails.
     * @see FailureReason
     */
    public final String failureReasonAsString() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(solveTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(failureReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptchaResponse)) {
            return false;
        }
        CaptchaResponse other = (CaptchaResponse) obj;
        return Objects.equals(responseCode(), other.responseCode()) && Objects.equals(solveTimestamp(), other.solveTimestamp())
                && Objects.equals(failureReasonAsString(), other.failureReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptchaResponse").add("ResponseCode", responseCode()).add("SolveTimestamp", solveTimestamp())
                .add("FailureReason", failureReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResponseCode":
            return Optional.ofNullable(clazz.cast(responseCode()));
        case "SolveTimestamp":
            return Optional.ofNullable(clazz.cast(solveTimestamp()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResponseCode", RESPONSE_CODE_FIELD);
        map.put("SolveTimestamp", SOLVE_TIMESTAMP_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaptchaResponse, T> g) {
        return obj -> g.apply((CaptchaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptchaResponse> {
        /**
         * <p>
         * The HTTP response code indicating the status of the <code>CAPTCHA</code> token in the web request. If the
         * token is missing, invalid, or expired, this code is <code>405 Method Not Allowed</code>.
         * </p>
         * 
         * @param responseCode
         *        The HTTP response code indicating the status of the <code>CAPTCHA</code> token in the web request. If
         *        the token is missing, invalid, or expired, this code is <code>405 Method Not Allowed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(Integer responseCode);

        /**
         * <p>
         * The time that the <code>CAPTCHA</code> was last solved for the supplied token.
         * </p>
         * 
         * @param solveTimestamp
         *        The time that the <code>CAPTCHA</code> was last solved for the supplied token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solveTimestamp(Long solveTimestamp);

        /**
         * <p>
         * The reason for failure, populated when the evaluation of the token fails.
         * </p>
         * 
         * @param failureReason
         *        The reason for failure, populated when the evaluation of the token fails.
         * @see FailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureReason
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The reason for failure, populated when the evaluation of the token fails.
         * </p>
         * 
         * @param failureReason
         *        The reason for failure, populated when the evaluation of the token fails.
         * @see FailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureReason
         */
        Builder failureReason(FailureReason failureReason);
    }

    static final class BuilderImpl implements Builder {
        private Integer responseCode;

        private Long solveTimestamp;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptchaResponse model) {
            responseCode(model.responseCode);
            solveTimestamp(model.solveTimestamp);
            failureReason(model.failureReason);
        }

        public final Integer getResponseCode() {
            return responseCode;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final Long getSolveTimestamp() {
            return solveTimestamp;
        }

        public final void setSolveTimestamp(Long solveTimestamp) {
            this.solveTimestamp = solveTimestamp;
        }

        @Override
        public final Builder solveTimestamp(Long solveTimestamp) {
            this.solveTimestamp = solveTimestamp;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        @Override
        public CaptchaResponse build() {
            return new CaptchaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
