/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter to use to identify the subset of cookies to inspect in a web request.
 * </p>
 * <p>
 * You must specify exactly one setting: either <code>All</code>, <code>IncludedCookies</code>, or
 * <code>ExcludedCookies</code>.
 * </p>
 * <p>
 * Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CookieMatchPattern implements SdkPojo, Serializable,
        ToCopyableBuilder<CookieMatchPattern.Builder, CookieMatchPattern> {
    private static final SdkField<All> ALL_FIELD = SdkField.<All> builder(MarshallingType.SDK_POJO).memberName("All")
            .getter(getter(CookieMatchPattern::all)).setter(setter(Builder::all)).constructor(All::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("All").build()).build();

    private static final SdkField<List<String>> INCLUDED_COOKIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludedCookies")
            .getter(getter(CookieMatchPattern::includedCookies))
            .setter(setter(Builder::includedCookies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedCookies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_COOKIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedCookies")
            .getter(getter(CookieMatchPattern::excludedCookies))
            .setter(setter(Builder::excludedCookies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedCookies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD,
            INCLUDED_COOKIES_FIELD, EXCLUDED_COOKIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final All all;

    private final List<String> includedCookies;

    private final List<String> excludedCookies;

    private CookieMatchPattern(BuilderImpl builder) {
        this.all = builder.all;
        this.includedCookies = builder.includedCookies;
        this.excludedCookies = builder.excludedCookies;
    }

    /**
     * <p>
     * Inspect all cookies.
     * </p>
     * 
     * @return Inspect all cookies.
     */
    public final All all() {
        return all;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedCookies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludedCookies() {
        return includedCookies != null && !(includedCookies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Inspect only the cookies that have a key that matches one of the strings specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedCookies} method.
     * </p>
     * 
     * @return Inspect only the cookies that have a key that matches one of the strings specified here.
     */
    public final List<String> includedCookies() {
        return includedCookies;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedCookies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedCookies() {
        return excludedCookies != null && !(excludedCookies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Inspect only the cookies whose keys don't match any of the strings specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedCookies} method.
     * </p>
     * 
     * @return Inspect only the cookies whose keys don't match any of the strings specified here.
     */
    public final List<String> excludedCookies() {
        return excludedCookies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(all());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedCookies() ? includedCookies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedCookies() ? excludedCookies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieMatchPattern)) {
            return false;
        }
        CookieMatchPattern other = (CookieMatchPattern) obj;
        return Objects.equals(all(), other.all()) && hasIncludedCookies() == other.hasIncludedCookies()
                && Objects.equals(includedCookies(), other.includedCookies())
                && hasExcludedCookies() == other.hasExcludedCookies()
                && Objects.equals(excludedCookies(), other.excludedCookies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CookieMatchPattern").add("All", all())
                .add("IncludedCookies", hasIncludedCookies() ? includedCookies() : null)
                .add("ExcludedCookies", hasExcludedCookies() ? excludedCookies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "All":
            return Optional.ofNullable(clazz.cast(all()));
        case "IncludedCookies":
            return Optional.ofNullable(clazz.cast(includedCookies()));
        case "ExcludedCookies":
            return Optional.ofNullable(clazz.cast(excludedCookies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("All", ALL_FIELD);
        map.put("IncludedCookies", INCLUDED_COOKIES_FIELD);
        map.put("ExcludedCookies", EXCLUDED_COOKIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CookieMatchPattern, T> g) {
        return obj -> g.apply((CookieMatchPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CookieMatchPattern> {
        /**
         * <p>
         * Inspect all cookies.
         * </p>
         * 
         * @param all
         *        Inspect all cookies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder all(All all);

        /**
         * <p>
         * Inspect all cookies.
         * </p>
         * This is a convenience method that creates an instance of the {@link All.Builder} avoiding the need to create
         * one manually via {@link All#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link All.Builder#build()} is called immediately and its result is
         * passed to {@link #all(All)}.
         * 
         * @param all
         *        a consumer that will call methods on {@link All.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #all(All)
         */
        default Builder all(Consumer<All.Builder> all) {
            return all(All.builder().applyMutation(all).build());
        }

        /**
         * <p>
         * Inspect only the cookies that have a key that matches one of the strings specified here.
         * </p>
         * 
         * @param includedCookies
         *        Inspect only the cookies that have a key that matches one of the strings specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedCookies(Collection<String> includedCookies);

        /**
         * <p>
         * Inspect only the cookies that have a key that matches one of the strings specified here.
         * </p>
         * 
         * @param includedCookies
         *        Inspect only the cookies that have a key that matches one of the strings specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedCookies(String... includedCookies);

        /**
         * <p>
         * Inspect only the cookies whose keys don't match any of the strings specified here.
         * </p>
         * 
         * @param excludedCookies
         *        Inspect only the cookies whose keys don't match any of the strings specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedCookies(Collection<String> excludedCookies);

        /**
         * <p>
         * Inspect only the cookies whose keys don't match any of the strings specified here.
         * </p>
         * 
         * @param excludedCookies
         *        Inspect only the cookies whose keys don't match any of the strings specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedCookies(String... excludedCookies);
    }

    static final class BuilderImpl implements Builder {
        private All all;

        private List<String> includedCookies = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedCookies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CookieMatchPattern model) {
            all(model.all);
            includedCookies(model.includedCookies);
            excludedCookies(model.excludedCookies);
        }

        public final All.Builder getAll() {
            return all != null ? all.toBuilder() : null;
        }

        public final void setAll(All.BuilderImpl all) {
            this.all = all != null ? all.build() : null;
        }

        @Override
        public final Builder all(All all) {
            this.all = all;
            return this;
        }

        public final Collection<String> getIncludedCookies() {
            if (includedCookies instanceof SdkAutoConstructList) {
                return null;
            }
            return includedCookies;
        }

        public final void setIncludedCookies(Collection<String> includedCookies) {
            this.includedCookies = CookieNamesCopier.copy(includedCookies);
        }

        @Override
        public final Builder includedCookies(Collection<String> includedCookies) {
            this.includedCookies = CookieNamesCopier.copy(includedCookies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedCookies(String... includedCookies) {
            includedCookies(Arrays.asList(includedCookies));
            return this;
        }

        public final Collection<String> getExcludedCookies() {
            if (excludedCookies instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedCookies;
        }

        public final void setExcludedCookies(Collection<String> excludedCookies) {
            this.excludedCookies = CookieNamesCopier.copy(excludedCookies);
        }

        @Override
        public final Builder excludedCookies(Collection<String> excludedCookies) {
            this.excludedCookies = CookieNamesCopier.copy(excludedCookies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedCookies(String... excludedCookies) {
            excludedCookies(Arrays.asList(excludedCookies));
            return this;
        }

        @Override
        public CookieMatchPattern build() {
            return new CookieMatchPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
