/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a field type and keys to protect in stored web request data. This is part of the data protection
 * configuration for a web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldToProtect implements SdkPojo, Serializable, ToCopyableBuilder<FieldToProtect.Builder, FieldToProtect> {
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldType").getter(getter(FieldToProtect::fieldTypeAsString)).setter(setter(Builder::fieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldType").build()).build();

    private static final SdkField<List<String>> FIELD_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FieldKeys")
            .getter(getter(FieldToProtect::fieldKeys))
            .setter(setter(Builder::fieldKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TYPE_FIELD,
            FIELD_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldType;

    private final List<String> fieldKeys;

    private FieldToProtect(BuilderImpl builder) {
        this.fieldType = builder.fieldType;
        this.fieldKeys = builder.fieldKeys;
    }

    /**
     * <p>
     * Specifies the web request component type to protect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldType} will
     * return {@link FieldToProtectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldTypeAsString}.
     * </p>
     * 
     * @return Specifies the web request component type to protect.
     * @see FieldToProtectType
     */
    public final FieldToProtectType fieldType() {
        return FieldToProtectType.fromValue(fieldType);
    }

    /**
     * <p>
     * Specifies the web request component type to protect.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldType} will
     * return {@link FieldToProtectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldTypeAsString}.
     * </p>
     * 
     * @return Specifies the web request component type to protect.
     * @see FieldToProtectType
     */
    public final String fieldTypeAsString() {
        return fieldType;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldKeys() {
        return fieldKeys != null && !(fieldKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the keys to protect for the specified field type. If you don't specify any key, then all keys for the
     * field type are protected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldKeys} method.
     * </p>
     * 
     * @return Specifies the keys to protect for the specified field type. If you don't specify any key, then all keys
     *         for the field type are protected.
     */
    public final List<String> fieldKeys() {
        return fieldKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldKeys() ? fieldKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToProtect)) {
            return false;
        }
        FieldToProtect other = (FieldToProtect) obj;
        return Objects.equals(fieldTypeAsString(), other.fieldTypeAsString()) && hasFieldKeys() == other.hasFieldKeys()
                && Objects.equals(fieldKeys(), other.fieldKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldToProtect").add("FieldType", fieldTypeAsString())
                .add("FieldKeys", hasFieldKeys() ? fieldKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldType":
            return Optional.ofNullable(clazz.cast(fieldTypeAsString()));
        case "FieldKeys":
            return Optional.ofNullable(clazz.cast(fieldKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldType", FIELD_TYPE_FIELD);
        map.put("FieldKeys", FIELD_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldToProtect, T> g) {
        return obj -> g.apply((FieldToProtect) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldToProtect> {
        /**
         * <p>
         * Specifies the web request component type to protect.
         * </p>
         * 
         * @param fieldType
         *        Specifies the web request component type to protect.
         * @see FieldToProtectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldToProtectType
         */
        Builder fieldType(String fieldType);

        /**
         * <p>
         * Specifies the web request component type to protect.
         * </p>
         * 
         * @param fieldType
         *        Specifies the web request component type to protect.
         * @see FieldToProtectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldToProtectType
         */
        Builder fieldType(FieldToProtectType fieldType);

        /**
         * <p>
         * Specifies the keys to protect for the specified field type. If you don't specify any key, then all keys for
         * the field type are protected.
         * </p>
         * 
         * @param fieldKeys
         *        Specifies the keys to protect for the specified field type. If you don't specify any key, then all
         *        keys for the field type are protected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldKeys(Collection<String> fieldKeys);

        /**
         * <p>
         * Specifies the keys to protect for the specified field type. If you don't specify any key, then all keys for
         * the field type are protected.
         * </p>
         * 
         * @param fieldKeys
         *        Specifies the keys to protect for the specified field type. If you don't specify any key, then all
         *        keys for the field type are protected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldKeys(String... fieldKeys);
    }

    static final class BuilderImpl implements Builder {
        private String fieldType;

        private List<String> fieldKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToProtect model) {
            fieldType(model.fieldType);
            fieldKeys(model.fieldKeys);
        }

        public final String getFieldType() {
            return fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public final Builder fieldType(FieldToProtectType fieldType) {
            this.fieldType(fieldType == null ? null : fieldType.toString());
            return this;
        }

        public final Collection<String> getFieldKeys() {
            if (fieldKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldKeys;
        }

        public final void setFieldKeys(Collection<String> fieldKeys) {
            this.fieldKeys = FieldToProtectKeysCopier.copy(fieldKeys);
        }

        @Override
        public final Builder fieldKeys(Collection<String> fieldKeys) {
            this.fieldKeys = FieldToProtectKeysCopier.copy(fieldKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldKeys(String... fieldKeys) {
            fieldKeys(Arrays.asList(fieldKeys));
            return this;
        }

        @Override
        public FieldToProtect build() {
            return new FieldToProtect(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
