/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRateBasedStatementManagedKeysRequest extends Wafv2Request implements
        ToCopyableBuilder<GetRateBasedStatementManagedKeysRequest.Builder, GetRateBasedStatementManagedKeysRequest> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(GetRateBasedStatementManagedKeysRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> WEB_ACL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLName").getter(getter(GetRateBasedStatementManagedKeysRequest::webACLName))
            .setter(setter(Builder::webACLName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLName").build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLId").getter(getter(GetRateBasedStatementManagedKeysRequest::webACLId))
            .setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").build()).build();

    private static final SdkField<String> RULE_GROUP_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupRuleName").getter(getter(GetRateBasedStatementManagedKeysRequest::ruleGroupRuleName))
            .setter(setter(Builder::ruleGroupRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupRuleName").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(GetRateBasedStatementManagedKeysRequest::ruleName))
            .setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            WEB_ACL_NAME_FIELD, WEB_ACL_ID_FIELD, RULE_GROUP_RULE_NAME_FIELD, RULE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scope;

    private final String webACLName;

    private final String webACLId;

    private final String ruleGroupRuleName;

    private final String ruleName;

    private GetRateBasedStatementManagedKeysRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.webACLName = builder.webACLName;
        this.webACLId = builder.webACLId;
        this.ruleGroupRuleName = builder.ruleGroupRuleName;
        this.ruleName = builder.ruleName;
    }

    /**
     * <p>
     * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The name of the web ACL. You cannot change the name of a web ACL after you create it.
     * </p>
     * 
     * @return The name of the web ACL. You cannot change the name of a web ACL after you create it.
     */
    public final String webACLName() {
        return webACLName;
    }

    /**
     * <p>
     * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You
     * provide it to operations like update and delete.
     * </p>
     * 
     * @return The unique identifier for the web ACL. This ID is returned in the responses to create and list commands.
     *         You provide it to operations like update and delete.
     */
    public final String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * The name of the rule group reference statement in your web ACL. This is required only when you have the
     * rate-based rule nested inside a rule group.
     * </p>
     * 
     * @return The name of the rule group reference statement in your web ACL. This is required only when you have the
     *         rate-based rule nested inside a rule group.
     */
    public final String ruleGroupRuleName() {
        return ruleGroupRuleName;
    }

    /**
     * <p>
     * The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're
     * using in your web ACL, also provide the name of the rule group reference statement in the request parameter
     * <code>RuleGroupRuleName</code>.
     * </p>
     * 
     * @return The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group
     *         that you're using in your web ACL, also provide the name of the rule group reference statement in the
     *         request parameter <code>RuleGroupRuleName</code>.
     */
    public final String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webACLName());
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedStatementManagedKeysRequest)) {
            return false;
        }
        GetRateBasedStatementManagedKeysRequest other = (GetRateBasedStatementManagedKeysRequest) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(webACLName(), other.webACLName())
                && Objects.equals(webACLId(), other.webACLId()) && Objects.equals(ruleGroupRuleName(), other.ruleGroupRuleName())
                && Objects.equals(ruleName(), other.ruleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRateBasedStatementManagedKeysRequest").add("Scope", scopeAsString())
                .add("WebACLName", webACLName()).add("WebACLId", webACLId()).add("RuleGroupRuleName", ruleGroupRuleName())
                .add("RuleName", ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "WebACLName":
            return Optional.ofNullable(clazz.cast(webACLName()));
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "RuleGroupRuleName":
            return Optional.ofNullable(clazz.cast(ruleGroupRuleName()));
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Scope", SCOPE_FIELD);
        map.put("WebACLName", WEB_ACL_NAME_FIELD);
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        map.put("RuleGroupRuleName", RULE_GROUP_RULE_NAME_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRateBasedStatementManagedKeysRequest, T> g) {
        return obj -> g.apply((GetRateBasedStatementManagedKeysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRateBasedStatementManagedKeysRequest> {
        /**
         * <p>
         * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * The name of the web ACL. You cannot change the name of a web ACL after you create it.
         * </p>
         * 
         * @param webACLName
         *        The name of the web ACL. You cannot change the name of a web ACL after you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLName(String webACLName);

        /**
         * <p>
         * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You
         * provide it to operations like update and delete.
         * </p>
         * 
         * @param webACLId
         *        The unique identifier for the web ACL. This ID is returned in the responses to create and list
         *        commands. You provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * The name of the rule group reference statement in your web ACL. This is required only when you have the
         * rate-based rule nested inside a rule group.
         * </p>
         * 
         * @param ruleGroupRuleName
         *        The name of the rule group reference statement in your web ACL. This is required only when you have
         *        the rate-based rule nested inside a rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupRuleName(String ruleGroupRuleName);

        /**
         * <p>
         * The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that
         * you're using in your web ACL, also provide the name of the rule group reference statement in the request
         * parameter <code>RuleGroupRuleName</code>.
         * </p>
         * 
         * @param ruleName
         *        The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group
         *        that you're using in your web ACL, also provide the name of the rule group reference statement in the
         *        request parameter <code>RuleGroupRuleName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String scope;

        private String webACLName;

        private String webACLId;

        private String ruleGroupRuleName;

        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedStatementManagedKeysRequest model) {
            super(model);
            scope(model.scope);
            webACLName(model.webACLName);
            webACLId(model.webACLId);
            ruleGroupRuleName(model.ruleGroupRuleName);
            ruleName(model.ruleName);
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getWebACLName() {
            return webACLName;
        }

        public final void setWebACLName(String webACLName) {
            this.webACLName = webACLName;
        }

        @Override
        public final Builder webACLName(String webACLName) {
            this.webACLName = webACLName;
            return this;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getRuleGroupRuleName() {
            return ruleGroupRuleName;
        }

        public final void setRuleGroupRuleName(String ruleGroupRuleName) {
            this.ruleGroupRuleName = ruleGroupRuleName;
        }

        @Override
        public final Builder ruleGroupRuleName(String ruleGroupRuleName) {
            this.ruleGroupRuleName = ruleGroupRuleName;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRateBasedStatementManagedKeysRequest build() {
            return new GetRateBasedStatementManagedKeysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
