/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRuleGroupResponse extends Wafv2Response implements
        ToCopyableBuilder<GetRuleGroupResponse.Builder, GetRuleGroupResponse> {
    private static final SdkField<RuleGroup> RULE_GROUP_FIELD = SdkField.<RuleGroup> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroup").getter(getter(GetRuleGroupResponse::ruleGroup)).setter(setter(Builder::ruleGroup))
            .constructor(RuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockToken").getter(getter(GetRuleGroupResponse::lockToken)).setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_FIELD,
            LOCK_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RuleGroup ruleGroup;

    private final String lockToken;

    private GetRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.ruleGroup = builder.ruleGroup;
        this.lockToken = builder.lockToken;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final RuleGroup ruleGroup() {
        return ruleGroup;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String lockToken() {
        return lockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleGroupResponse)) {
            return false;
        }
        GetRuleGroupResponse other = (GetRuleGroupResponse) obj;
        return Objects.equals(ruleGroup(), other.ruleGroup()) && Objects.equals(lockToken(), other.lockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRuleGroupResponse").add("RuleGroup", ruleGroup()).add("LockToken", lockToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroup":
            return Optional.ofNullable(clazz.cast(ruleGroup()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleGroup", RULE_GROUP_FIELD);
        map.put("LockToken", LOCK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRuleGroupResponse, T> g) {
        return obj -> g.apply((GetRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetRuleGroupResponse> {
        /**
         * <p/>
         * 
         * @param ruleGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroup(RuleGroup ruleGroup);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link RuleGroup.Builder} avoiding the need to
         * create one manually via {@link RuleGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleGroup(RuleGroup)}.
         * 
         * @param ruleGroup
         *        a consumer that will call methods on {@link RuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroup(RuleGroup)
         */
        default Builder ruleGroup(Consumer<RuleGroup.Builder> ruleGroup) {
            return ruleGroup(RuleGroup.builder().applyMutation(ruleGroup).build());
        }

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private RuleGroup ruleGroup;

        private String lockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleGroupResponse model) {
            super(model);
            ruleGroup(model.ruleGroup);
            lockToken(model.lockToken);
        }

        public final RuleGroup.Builder getRuleGroup() {
            return ruleGroup != null ? ruleGroup.toBuilder() : null;
        }

        public final void setRuleGroup(RuleGroup.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        @Override
        public final Builder ruleGroup(RuleGroup ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final String getLockToken() {
            return lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        @Override
        public GetRuleGroupResponse build() {
            return new GetRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
