/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMobileSdkReleasesResponse extends Wafv2Response implements
        ToCopyableBuilder<ListMobileSdkReleasesResponse.Builder, ListMobileSdkReleasesResponse> {
    private static final SdkField<List<ReleaseSummary>> RELEASE_SUMMARIES_FIELD = SdkField
            .<List<ReleaseSummary>> builder(MarshallingType.LIST)
            .memberName("ReleaseSummaries")
            .getter(getter(ListMobileSdkReleasesResponse::releaseSummaries))
            .setter(setter(Builder::releaseSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReleaseSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReleaseSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListMobileSdkReleasesResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_SUMMARIES_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReleaseSummary> releaseSummaries;

    private final String nextMarker;

    private ListMobileSdkReleasesResponse(BuilderImpl builder) {
        super(builder);
        this.releaseSummaries = builder.releaseSummaries;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReleaseSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReleaseSummaries() {
        return releaseSummaries != null && !(releaseSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The high level information for the available SDK releases. If you specified a <code>Limit</code> in your request,
     * this might not be the full list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReleaseSummaries} method.
     * </p>
     * 
     * @return The high level information for the available SDK releases. If you specified a <code>Limit</code> in your
     *         request, this might not be the full list.
     */
    public final List<ReleaseSummary> releaseSummaries() {
        return releaseSummaries;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
     * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
     * retrieve the next batch of objects, provide the marker from the prior call in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are
     *         still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the
     *         response. To retrieve the next batch of objects, provide the marker from the prior call in your next
     *         request.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReleaseSummaries() ? releaseSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMobileSdkReleasesResponse)) {
            return false;
        }
        ListMobileSdkReleasesResponse other = (ListMobileSdkReleasesResponse) obj;
        return hasReleaseSummaries() == other.hasReleaseSummaries()
                && Objects.equals(releaseSummaries(), other.releaseSummaries())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMobileSdkReleasesResponse")
                .add("ReleaseSummaries", hasReleaseSummaries() ? releaseSummaries() : null).add("NextMarker", nextMarker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReleaseSummaries":
            return Optional.ofNullable(clazz.cast(releaseSummaries()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReleaseSummaries", RELEASE_SUMMARIES_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMobileSdkReleasesResponse, T> g) {
        return obj -> g.apply((ListMobileSdkReleasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListMobileSdkReleasesResponse> {
        /**
         * <p>
         * The high level information for the available SDK releases. If you specified a <code>Limit</code> in your
         * request, this might not be the full list.
         * </p>
         * 
         * @param releaseSummaries
         *        The high level information for the available SDK releases. If you specified a <code>Limit</code> in
         *        your request, this might not be the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseSummaries(Collection<ReleaseSummary> releaseSummaries);

        /**
         * <p>
         * The high level information for the available SDK releases. If you specified a <code>Limit</code> in your
         * request, this might not be the full list.
         * </p>
         * 
         * @param releaseSummaries
         *        The high level information for the available SDK releases. If you specified a <code>Limit</code> in
         *        your request, this might not be the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseSummaries(ReleaseSummary... releaseSummaries);

        /**
         * <p>
         * The high level information for the available SDK releases. If you specified a <code>Limit</code> in your
         * request, this might not be the full list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.ReleaseSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.ReleaseSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.ReleaseSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #releaseSummaries(List<ReleaseSummary>)}.
         * 
         * @param releaseSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.ReleaseSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #releaseSummaries(java.util.Collection<ReleaseSummary>)
         */
        Builder releaseSummaries(Consumer<ReleaseSummary.Builder>... releaseSummaries);

        /**
         * <p>
         * When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still
         * available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To
         * retrieve the next batch of objects, provide the marker from the prior call in your next request.
         * </p>
         * 
         * @param nextMarker
         *        When you request a list of objects with a <code>Limit</code> setting, if the number of objects that
         *        are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in
         *        the response. To retrieve the next batch of objects, provide the marker from the prior call in your
         *        next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private List<ReleaseSummary> releaseSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMobileSdkReleasesResponse model) {
            super(model);
            releaseSummaries(model.releaseSummaries);
            nextMarker(model.nextMarker);
        }

        public final List<ReleaseSummary.Builder> getReleaseSummaries() {
            List<ReleaseSummary.Builder> result = ReleaseSummariesCopier.copyToBuilder(this.releaseSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReleaseSummaries(Collection<ReleaseSummary.BuilderImpl> releaseSummaries) {
            this.releaseSummaries = ReleaseSummariesCopier.copyFromBuilder(releaseSummaries);
        }

        @Override
        public final Builder releaseSummaries(Collection<ReleaseSummary> releaseSummaries) {
            this.releaseSummaries = ReleaseSummariesCopier.copy(releaseSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder releaseSummaries(ReleaseSummary... releaseSummaries) {
            releaseSummaries(Arrays.asList(releaseSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder releaseSummaries(Consumer<ReleaseSummary.Builder>... releaseSummaries) {
            releaseSummaries(Stream.of(releaseSummaries).map(c -> ReleaseSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListMobileSdkReleasesResponse build() {
            return new ListMobileSdkReleasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
