/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures inspection of the response status code. This is part of the <code>ResponseInspection</code> configuration
 * for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code>.
 * </p>
 * <note>
 * <p>
 * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseInspectionStatusCode implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseInspectionStatusCode.Builder, ResponseInspectionStatusCode> {
    private static final SdkField<List<Integer>> SUCCESS_CODES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("SuccessCodes")
            .getter(getter(ResponseInspectionStatusCode::successCodes))
            .setter(setter(Builder::successCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> FAILURE_CODES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("FailureCodes")
            .getter(getter(ResponseInspectionStatusCode::failureCodes))
            .setter(setter(Builder::failureCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_CODES_FIELD,
            FAILURE_CODES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Integer> successCodes;

    private final List<Integer> failureCodes;

    private ResponseInspectionStatusCode(BuilderImpl builder) {
        this.successCodes = builder.successCodes;
        this.failureCodes = builder.failureCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessCodes() {
        return successCodes != null && !(successCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Status codes in the response that indicate a successful login or account creation attempt. To be counted as a
     * success, the response status code must match one of these. Each code must be unique among the success and failure
     * status codes.
     * </p>
     * <p>
     * JSON example: <code>"SuccessCodes": [ 200, 201 ]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessCodes} method.
     * </p>
     * 
     * @return Status codes in the response that indicate a successful login or account creation attempt. To be counted
     *         as a success, the response status code must match one of these. Each code must be unique among the
     *         success and failure status codes. </p>
     *         <p>
     *         JSON example: <code>"SuccessCodes": [ 200, 201 ]</code>
     */
    public final List<Integer> successCodes() {
        return successCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureCodes() {
        return failureCodes != null && !(failureCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Status codes in the response that indicate a failed login or account creation attempt. To be counted as a
     * failure, the response status code must match one of these. Each code must be unique among the success and failure
     * status codes.
     * </p>
     * <p>
     * JSON example: <code>"FailureCodes": [ 400, 404 ]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureCodes} method.
     * </p>
     * 
     * @return Status codes in the response that indicate a failed login or account creation attempt. To be counted as a
     *         failure, the response status code must match one of these. Each code must be unique among the success and
     *         failure status codes. </p>
     *         <p>
     *         JSON example: <code>"FailureCodes": [ 400, 404 ]</code>
     */
    public final List<Integer> failureCodes() {
        return failureCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessCodes() ? successCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureCodes() ? failureCodes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspectionStatusCode)) {
            return false;
        }
        ResponseInspectionStatusCode other = (ResponseInspectionStatusCode) obj;
        return hasSuccessCodes() == other.hasSuccessCodes() && Objects.equals(successCodes(), other.successCodes())
                && hasFailureCodes() == other.hasFailureCodes() && Objects.equals(failureCodes(), other.failureCodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseInspectionStatusCode").add("SuccessCodes", hasSuccessCodes() ? successCodes() : null)
                .add("FailureCodes", hasFailureCodes() ? failureCodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessCodes":
            return Optional.ofNullable(clazz.cast(successCodes()));
        case "FailureCodes":
            return Optional.ofNullable(clazz.cast(failureCodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessCodes", SUCCESS_CODES_FIELD);
        map.put("FailureCodes", FAILURE_CODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseInspectionStatusCode, T> g) {
        return obj -> g.apply((ResponseInspectionStatusCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseInspectionStatusCode> {
        /**
         * <p>
         * Status codes in the response that indicate a successful login or account creation attempt. To be counted as a
         * success, the response status code must match one of these. Each code must be unique among the success and
         * failure status codes.
         * </p>
         * <p>
         * JSON example: <code>"SuccessCodes": [ 200, 201 ]</code>
         * </p>
         * 
         * @param successCodes
         *        Status codes in the response that indicate a successful login or account creation attempt. To be
         *        counted as a success, the response status code must match one of these. Each code must be unique among
         *        the success and failure status codes. </p>
         *        <p>
         *        JSON example: <code>"SuccessCodes": [ 200, 201 ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successCodes(Collection<Integer> successCodes);

        /**
         * <p>
         * Status codes in the response that indicate a successful login or account creation attempt. To be counted as a
         * success, the response status code must match one of these. Each code must be unique among the success and
         * failure status codes.
         * </p>
         * <p>
         * JSON example: <code>"SuccessCodes": [ 200, 201 ]</code>
         * </p>
         * 
         * @param successCodes
         *        Status codes in the response that indicate a successful login or account creation attempt. To be
         *        counted as a success, the response status code must match one of these. Each code must be unique among
         *        the success and failure status codes. </p>
         *        <p>
         *        JSON example: <code>"SuccessCodes": [ 200, 201 ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successCodes(Integer... successCodes);

        /**
         * <p>
         * Status codes in the response that indicate a failed login or account creation attempt. To be counted as a
         * failure, the response status code must match one of these. Each code must be unique among the success and
         * failure status codes.
         * </p>
         * <p>
         * JSON example: <code>"FailureCodes": [ 400, 404 ]</code>
         * </p>
         * 
         * @param failureCodes
         *        Status codes in the response that indicate a failed login or account creation attempt. To be counted
         *        as a failure, the response status code must match one of these. Each code must be unique among the
         *        success and failure status codes. </p>
         *        <p>
         *        JSON example: <code>"FailureCodes": [ 400, 404 ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCodes(Collection<Integer> failureCodes);

        /**
         * <p>
         * Status codes in the response that indicate a failed login or account creation attempt. To be counted as a
         * failure, the response status code must match one of these. Each code must be unique among the success and
         * failure status codes.
         * </p>
         * <p>
         * JSON example: <code>"FailureCodes": [ 400, 404 ]</code>
         * </p>
         * 
         * @param failureCodes
         *        Status codes in the response that indicate a failed login or account creation attempt. To be counted
         *        as a failure, the response status code must match one of these. Each code must be unique among the
         *        success and failure status codes. </p>
         *        <p>
         *        JSON example: <code>"FailureCodes": [ 400, 404 ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCodes(Integer... failureCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> successCodes = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> failureCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseInspectionStatusCode model) {
            successCodes(model.successCodes);
            failureCodes(model.failureCodes);
        }

        public final Collection<Integer> getSuccessCodes() {
            if (successCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return successCodes;
        }

        public final void setSuccessCodes(Collection<Integer> successCodes) {
            this.successCodes = ResponseInspectionStatusCodeSuccessCodesCopier.copy(successCodes);
        }

        @Override
        public final Builder successCodes(Collection<Integer> successCodes) {
            this.successCodes = ResponseInspectionStatusCodeSuccessCodesCopier.copy(successCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successCodes(Integer... successCodes) {
            successCodes(Arrays.asList(successCodes));
            return this;
        }

        public final Collection<Integer> getFailureCodes() {
            if (failureCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return failureCodes;
        }

        public final void setFailureCodes(Collection<Integer> failureCodes) {
            this.failureCodes = ResponseInspectionStatusCodeFailureCodesCopier.copy(failureCodes);
        }

        @Override
        public final Builder failureCodes(Collection<Integer> failureCodes) {
            this.failureCodes = ResponseInspectionStatusCodeFailureCodesCopier.copy(failureCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureCodes(Integer... failureCodes) {
            failureCodes(Arrays.asList(failureCodes));
            return this;
        }

        @Override
        public ResponseInspectionStatusCode build() {
            return new ResponseInspectionStatusCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
