/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single sampled web request. The response from <a>GetSampledRequests</a> includes a
 * <code>SampledHTTPRequests</code> complex type that appears as <code>SampledRequests</code> in the response syntax.
 * <code>SampledHTTPRequests</code> contains an array of <code>SampledHTTPRequest</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampledHTTPRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SampledHTTPRequest.Builder, SampledHTTPRequest> {
    private static final SdkField<HTTPRequest> REQUEST_FIELD = SdkField.<HTTPRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Request").getter(getter(SampledHTTPRequest::request)).setter(setter(Builder::request))
            .constructor(HTTPRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Request").build()).build();

    private static final SdkField<Long> WEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Weight")
            .getter(getter(SampledHTTPRequest::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(SampledHTTPRequest::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(SampledHTTPRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> RULE_NAME_WITHIN_RULE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleNameWithinRuleGroup").getter(getter(SampledHTTPRequest::ruleNameWithinRuleGroup))
            .setter(setter(Builder::ruleNameWithinRuleGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNameWithinRuleGroup").build())
            .build();

    private static final SdkField<List<HTTPHeader>> REQUEST_HEADERS_INSERTED_FIELD = SdkField
            .<List<HTTPHeader>> builder(MarshallingType.LIST)
            .memberName("RequestHeadersInserted")
            .getter(getter(SampledHTTPRequest::requestHeadersInserted))
            .setter(setter(Builder::requestHeadersInserted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestHeadersInserted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HTTPHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HTTPHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RESPONSE_CODE_SENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResponseCodeSent").getter(getter(SampledHTTPRequest::responseCodeSent))
            .setter(setter(Builder::responseCodeSent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCodeSent").build()).build();

    private static final SdkField<List<Label>> LABELS_FIELD = SdkField
            .<List<Label>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(SampledHTTPRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Label> builder(MarshallingType.SDK_POJO)
                                            .constructor(Label::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CaptchaResponse> CAPTCHA_RESPONSE_FIELD = SdkField
            .<CaptchaResponse> builder(MarshallingType.SDK_POJO).memberName("CaptchaResponse")
            .getter(getter(SampledHTTPRequest::captchaResponse)).setter(setter(Builder::captchaResponse))
            .constructor(CaptchaResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptchaResponse").build()).build();

    private static final SdkField<ChallengeResponse> CHALLENGE_RESPONSE_FIELD = SdkField
            .<ChallengeResponse> builder(MarshallingType.SDK_POJO).memberName("ChallengeResponse")
            .getter(getter(SampledHTTPRequest::challengeResponse)).setter(setter(Builder::challengeResponse))
            .constructor(ChallengeResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponse").build()).build();

    private static final SdkField<String> OVERRIDDEN_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverriddenAction").getter(getter(SampledHTTPRequest::overriddenAction))
            .setter(setter(Builder::overriddenAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverriddenAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, WEIGHT_FIELD,
            TIMESTAMP_FIELD, ACTION_FIELD, RULE_NAME_WITHIN_RULE_GROUP_FIELD, REQUEST_HEADERS_INSERTED_FIELD,
            RESPONSE_CODE_SENT_FIELD, LABELS_FIELD, CAPTCHA_RESPONSE_FIELD, CHALLENGE_RESPONSE_FIELD, OVERRIDDEN_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HTTPRequest request;

    private final Long weight;

    private final Instant timestamp;

    private final String action;

    private final String ruleNameWithinRuleGroup;

    private final List<HTTPHeader> requestHeadersInserted;

    private final Integer responseCodeSent;

    private final List<Label> labels;

    private final CaptchaResponse captchaResponse;

    private final ChallengeResponse challengeResponse;

    private final String overriddenAction;

    private SampledHTTPRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.weight = builder.weight;
        this.timestamp = builder.timestamp;
        this.action = builder.action;
        this.ruleNameWithinRuleGroup = builder.ruleNameWithinRuleGroup;
        this.requestHeadersInserted = builder.requestHeadersInserted;
        this.responseCodeSent = builder.responseCodeSent;
        this.labels = builder.labels;
        this.captchaResponse = builder.captchaResponse;
        this.challengeResponse = builder.challengeResponse;
        this.overriddenAction = builder.overriddenAction;
    }

    /**
     * <p>
     * A complex type that contains detailed information about the request.
     * </p>
     * 
     * @return A complex type that contains detailed information about the request.
     */
    public final HTTPRequest request() {
        return request;
    }

    /**
     * <p>
     * A value that indicates how one result in the response relates proportionally to other results in the response.
     * For example, a result that has a weight of <code>2</code> represents roughly twice as many web requests as a
     * result that has a weight of <code>1</code>.
     * </p>
     * 
     * @return A value that indicates how one result in the response relates proportionally to other results in the
     *         response. For example, a result that has a weight of <code>2</code> represents roughly twice as many web
     *         requests as a result that has a weight of <code>1</code>.
     */
    public final Long weight() {
        return weight;
    }

    /**
     * <p>
     * The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in
     * seconds).
     * </p>
     * 
     * @return The time at which WAF received the request from your Amazon Web Services resource, in Unix time format
     *         (in seconds).
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The action that WAF applied to the request.
     * </p>
     * 
     * @return The action that WAF applied to the request.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this name is
     * <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own rule groups, the
     * format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is not in a rule
     * group, this field is absent.
     * </p>
     * 
     * @return The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this
     *         name is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own
     *         rule groups, the format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the
     *         rule is not in a rule group, this field is absent.
     */
    public final String ruleNameWithinRuleGroup() {
        return ruleNameWithinRuleGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestHeadersInserted property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRequestHeadersInserted() {
        return requestHeadersInserted != null && !(requestHeadersInserted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom request headers inserted by WAF into the request, according to the custom request configuration for the
     * matching rule action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestHeadersInserted} method.
     * </p>
     * 
     * @return Custom request headers inserted by WAF into the request, according to the custom request configuration
     *         for the matching rule action.
     */
    public final List<HTTPHeader> requestHeadersInserted() {
        return requestHeadersInserted;
    }

    /**
     * <p>
     * The response code that was sent for the request.
     * </p>
     * 
     * @return The response code that was sent for the request.
     */
    public final Integer responseCodeSent() {
        return responseCodeSent;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests.
     * A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web
     * ACL defines the label namespace.
     * </p>
     * <p>
     * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
     * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web
     *         requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's
     *         rule group or web ACL defines the label namespace. </p>
     *         <p>
     *         For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
     *         <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
     */
    public final List<Label> labels() {
        return labels;
    }

    /**
     * <p>
     * The <code>CAPTCHA</code> response for the request.
     * </p>
     * 
     * @return The <code>CAPTCHA</code> response for the request.
     */
    public final CaptchaResponse captchaResponse() {
        return captchaResponse;
    }

    /**
     * <p>
     * The <code>Challenge</code> response for the request.
     * </p>
     * 
     * @return The <code>Challenge</code> response for the request.
     */
    public final ChallengeResponse challengeResponse() {
        return challengeResponse;
    }

    /**
     * <p>
     * Used only for rule group rules that have a rule action override in place in the web ACL. This is the action that
     * the rule group rule is configured for, and not the action that was applied to the request. The action that WAF
     * applied is the <code>Action</code> value.
     * </p>
     * 
     * @return Used only for rule group rules that have a rule action override in place in the web ACL. This is the
     *         action that the rule group rule is configured for, and not the action that was applied to the request.
     *         The action that WAF applied is the <code>Action</code> value.
     */
    public final String overriddenAction() {
        return overriddenAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNameWithinRuleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestHeadersInserted() ? requestHeadersInserted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseCodeSent());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(captchaResponse());
        hashCode = 31 * hashCode + Objects.hashCode(challengeResponse());
        hashCode = 31 * hashCode + Objects.hashCode(overriddenAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampledHTTPRequest)) {
            return false;
        }
        SampledHTTPRequest other = (SampledHTTPRequest) obj;
        return Objects.equals(request(), other.request()) && Objects.equals(weight(), other.weight())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(action(), other.action())
                && Objects.equals(ruleNameWithinRuleGroup(), other.ruleNameWithinRuleGroup())
                && hasRequestHeadersInserted() == other.hasRequestHeadersInserted()
                && Objects.equals(requestHeadersInserted(), other.requestHeadersInserted())
                && Objects.equals(responseCodeSent(), other.responseCodeSent()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels()) && Objects.equals(captchaResponse(), other.captchaResponse())
                && Objects.equals(challengeResponse(), other.challengeResponse())
                && Objects.equals(overriddenAction(), other.overriddenAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampledHTTPRequest").add("Request", request()).add("Weight", weight())
                .add("Timestamp", timestamp()).add("Action", action()).add("RuleNameWithinRuleGroup", ruleNameWithinRuleGroup())
                .add("RequestHeadersInserted", hasRequestHeadersInserted() ? requestHeadersInserted() : null)
                .add("ResponseCodeSent", responseCodeSent()).add("Labels", hasLabels() ? labels() : null)
                .add("CaptchaResponse", captchaResponse()).add("ChallengeResponse", challengeResponse())
                .add("OverriddenAction", overriddenAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Request":
            return Optional.ofNullable(clazz.cast(request()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "RuleNameWithinRuleGroup":
            return Optional.ofNullable(clazz.cast(ruleNameWithinRuleGroup()));
        case "RequestHeadersInserted":
            return Optional.ofNullable(clazz.cast(requestHeadersInserted()));
        case "ResponseCodeSent":
            return Optional.ofNullable(clazz.cast(responseCodeSent()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "CaptchaResponse":
            return Optional.ofNullable(clazz.cast(captchaResponse()));
        case "ChallengeResponse":
            return Optional.ofNullable(clazz.cast(challengeResponse()));
        case "OverriddenAction":
            return Optional.ofNullable(clazz.cast(overriddenAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Request", REQUEST_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("RuleNameWithinRuleGroup", RULE_NAME_WITHIN_RULE_GROUP_FIELD);
        map.put("RequestHeadersInserted", REQUEST_HEADERS_INSERTED_FIELD);
        map.put("ResponseCodeSent", RESPONSE_CODE_SENT_FIELD);
        map.put("Labels", LABELS_FIELD);
        map.put("CaptchaResponse", CAPTCHA_RESPONSE_FIELD);
        map.put("ChallengeResponse", CHALLENGE_RESPONSE_FIELD);
        map.put("OverriddenAction", OVERRIDDEN_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SampledHTTPRequest, T> g) {
        return obj -> g.apply((SampledHTTPRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SampledHTTPRequest> {
        /**
         * <p>
         * A complex type that contains detailed information about the request.
         * </p>
         * 
         * @param request
         *        A complex type that contains detailed information about the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(HTTPRequest request);

        /**
         * <p>
         * A complex type that contains detailed information about the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link HTTPRequest.Builder} avoiding the need to
         * create one manually via {@link HTTPRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HTTPRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #request(HTTPRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link HTTPRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(HTTPRequest)
         */
        default Builder request(Consumer<HTTPRequest.Builder> request) {
            return request(HTTPRequest.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * A value that indicates how one result in the response relates proportionally to other results in the
         * response. For example, a result that has a weight of <code>2</code> represents roughly twice as many web
         * requests as a result that has a weight of <code>1</code>.
         * </p>
         * 
         * @param weight
         *        A value that indicates how one result in the response relates proportionally to other results in the
         *        response. For example, a result that has a weight of <code>2</code> represents roughly twice as many
         *        web requests as a result that has a weight of <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Long weight);

        /**
         * <p>
         * The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in
         * seconds).
         * </p>
         * 
         * @param timestamp
         *        The time at which WAF received the request from your Amazon Web Services resource, in Unix time format
         *        (in seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The action that WAF applied to the request.
         * </p>
         * 
         * @param action
         *        The action that WAF applied to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for this name
         * is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For your own rule
         * groups, the format for this name is <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is
         * not in a rule group, this field is absent.
         * </p>
         * 
         * @param ruleNameWithinRuleGroup
         *        The name of the <code>Rule</code> that the request matched. For managed rule groups, the format for
         *        this name is <code>&lt;vendor name&gt;#&lt;managed rule group name&gt;#&lt;rule name&gt;</code>. For
         *        your own rule groups, the format for this name is
         *        <code>&lt;rule group name&gt;#&lt;rule name&gt;</code>. If the rule is not in a rule group, this field
         *        is absent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNameWithinRuleGroup(String ruleNameWithinRuleGroup);

        /**
         * <p>
         * Custom request headers inserted by WAF into the request, according to the custom request configuration for
         * the matching rule action.
         * </p>
         * 
         * @param requestHeadersInserted
         *        Custom request headers inserted by WAF into the request, according to the custom request configuration
         *        for the matching rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestHeadersInserted(Collection<HTTPHeader> requestHeadersInserted);

        /**
         * <p>
         * Custom request headers inserted by WAF into the request, according to the custom request configuration for
         * the matching rule action.
         * </p>
         * 
         * @param requestHeadersInserted
         *        Custom request headers inserted by WAF into the request, according to the custom request configuration
         *        for the matching rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestHeadersInserted(HTTPHeader... requestHeadersInserted);

        /**
         * <p>
         * Custom request headers inserted by WAF into the request, according to the custom request configuration for
         * the matching rule action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #requestHeadersInserted(List<HTTPHeader>)}.
         * 
         * @param requestHeadersInserted
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.HTTPHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestHeadersInserted(java.util.Collection<HTTPHeader>)
         */
        Builder requestHeadersInserted(Consumer<HTTPHeader.Builder>... requestHeadersInserted);

        /**
         * <p>
         * The response code that was sent for the request.
         * </p>
         * 
         * @param responseCodeSent
         *        The response code that was sent for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCodeSent(Integer responseCodeSent);

        /**
         * <p>
         * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web
         * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
         * group or web ACL defines the label namespace.
         * </p>
         * <p>
         * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * </p>
         * 
         * @param labels
         *        Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching
         *        web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The
         *        rule's rule group or web ACL defines the label namespace. </p>
         *        <p>
         *        For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         *        <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<Label> labels);

        /**
         * <p>
         * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web
         * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
         * group or web ACL defines the label namespace.
         * </p>
         * <p>
         * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * </p>
         * 
         * @param labels
         *        Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching
         *        web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The
         *        rule's rule group or web ACL defines the label namespace. </p>
         *        <p>
         *        For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         *        <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Label... labels);

        /**
         * <p>
         * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web
         * requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule
         * group or web ACL defines the label namespace.
         * </p>
         * <p>
         * For example, <code>awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA</code> or
         * <code>awswaf:managed:aws:managed-rule-set:header:encoding:utf8</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.Label.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.wafv2.model.Label#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.Label.Builder#build()} is called immediately and its
         * result is passed to {@link #labels(List<Label>)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.wafv2.model.Label.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(java.util.Collection<Label>)
         */
        Builder labels(Consumer<Label.Builder>... labels);

        /**
         * <p>
         * The <code>CAPTCHA</code> response for the request.
         * </p>
         * 
         * @param captchaResponse
         *        The <code>CAPTCHA</code> response for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captchaResponse(CaptchaResponse captchaResponse);

        /**
         * <p>
         * The <code>CAPTCHA</code> response for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaptchaResponse.Builder} avoiding the
         * need to create one manually via {@link CaptchaResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptchaResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #captchaResponse(CaptchaResponse)}.
         * 
         * @param captchaResponse
         *        a consumer that will call methods on {@link CaptchaResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captchaResponse(CaptchaResponse)
         */
        default Builder captchaResponse(Consumer<CaptchaResponse.Builder> captchaResponse) {
            return captchaResponse(CaptchaResponse.builder().applyMutation(captchaResponse).build());
        }

        /**
         * <p>
         * The <code>Challenge</code> response for the request.
         * </p>
         * 
         * @param challengeResponse
         *        The <code>Challenge</code> response for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeResponse(ChallengeResponse challengeResponse);

        /**
         * <p>
         * The <code>Challenge</code> response for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChallengeResponse.Builder} avoiding the
         * need to create one manually via {@link ChallengeResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChallengeResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #challengeResponse(ChallengeResponse)}.
         * 
         * @param challengeResponse
         *        a consumer that will call methods on {@link ChallengeResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challengeResponse(ChallengeResponse)
         */
        default Builder challengeResponse(Consumer<ChallengeResponse.Builder> challengeResponse) {
            return challengeResponse(ChallengeResponse.builder().applyMutation(challengeResponse).build());
        }

        /**
         * <p>
         * Used only for rule group rules that have a rule action override in place in the web ACL. This is the action
         * that the rule group rule is configured for, and not the action that was applied to the request. The action
         * that WAF applied is the <code>Action</code> value.
         * </p>
         * 
         * @param overriddenAction
         *        Used only for rule group rules that have a rule action override in place in the web ACL. This is the
         *        action that the rule group rule is configured for, and not the action that was applied to the request.
         *        The action that WAF applied is the <code>Action</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overriddenAction(String overriddenAction);
    }

    static final class BuilderImpl implements Builder {
        private HTTPRequest request;

        private Long weight;

        private Instant timestamp;

        private String action;

        private String ruleNameWithinRuleGroup;

        private List<HTTPHeader> requestHeadersInserted = DefaultSdkAutoConstructList.getInstance();

        private Integer responseCodeSent;

        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();

        private CaptchaResponse captchaResponse;

        private ChallengeResponse challengeResponse;

        private String overriddenAction;

        private BuilderImpl() {
        }

        private BuilderImpl(SampledHTTPRequest model) {
            request(model.request);
            weight(model.weight);
            timestamp(model.timestamp);
            action(model.action);
            ruleNameWithinRuleGroup(model.ruleNameWithinRuleGroup);
            requestHeadersInserted(model.requestHeadersInserted);
            responseCodeSent(model.responseCodeSent);
            labels(model.labels);
            captchaResponse(model.captchaResponse);
            challengeResponse(model.challengeResponse);
            overriddenAction(model.overriddenAction);
        }

        public final HTTPRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(HTTPRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(HTTPRequest request) {
            this.request = request;
            return this;
        }

        public final Long getWeight() {
            return weight;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getRuleNameWithinRuleGroup() {
            return ruleNameWithinRuleGroup;
        }

        public final void setRuleNameWithinRuleGroup(String ruleNameWithinRuleGroup) {
            this.ruleNameWithinRuleGroup = ruleNameWithinRuleGroup;
        }

        @Override
        public final Builder ruleNameWithinRuleGroup(String ruleNameWithinRuleGroup) {
            this.ruleNameWithinRuleGroup = ruleNameWithinRuleGroup;
            return this;
        }

        public final List<HTTPHeader.Builder> getRequestHeadersInserted() {
            List<HTTPHeader.Builder> result = HTTPHeadersCopier.copyToBuilder(this.requestHeadersInserted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestHeadersInserted(Collection<HTTPHeader.BuilderImpl> requestHeadersInserted) {
            this.requestHeadersInserted = HTTPHeadersCopier.copyFromBuilder(requestHeadersInserted);
        }

        @Override
        public final Builder requestHeadersInserted(Collection<HTTPHeader> requestHeadersInserted) {
            this.requestHeadersInserted = HTTPHeadersCopier.copy(requestHeadersInserted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestHeadersInserted(HTTPHeader... requestHeadersInserted) {
            requestHeadersInserted(Arrays.asList(requestHeadersInserted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestHeadersInserted(Consumer<HTTPHeader.Builder>... requestHeadersInserted) {
            requestHeadersInserted(Stream.of(requestHeadersInserted).map(c -> HTTPHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getResponseCodeSent() {
            return responseCodeSent;
        }

        public final void setResponseCodeSent(Integer responseCodeSent) {
            this.responseCodeSent = responseCodeSent;
        }

        @Override
        public final Builder responseCodeSent(Integer responseCodeSent) {
            this.responseCodeSent = responseCodeSent;
            return this;
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder>... labels) {
            labels(Stream.of(labels).map(c -> Label.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CaptchaResponse.Builder getCaptchaResponse() {
            return captchaResponse != null ? captchaResponse.toBuilder() : null;
        }

        public final void setCaptchaResponse(CaptchaResponse.BuilderImpl captchaResponse) {
            this.captchaResponse = captchaResponse != null ? captchaResponse.build() : null;
        }

        @Override
        public final Builder captchaResponse(CaptchaResponse captchaResponse) {
            this.captchaResponse = captchaResponse;
            return this;
        }

        public final ChallengeResponse.Builder getChallengeResponse() {
            return challengeResponse != null ? challengeResponse.toBuilder() : null;
        }

        public final void setChallengeResponse(ChallengeResponse.BuilderImpl challengeResponse) {
            this.challengeResponse = challengeResponse != null ? challengeResponse.build() : null;
        }

        @Override
        public final Builder challengeResponse(ChallengeResponse challengeResponse) {
            this.challengeResponse = challengeResponse;
            return this;
        }

        public final String getOverriddenAction() {
            return overriddenAction;
        }

        public final void setOverriddenAction(String overriddenAction) {
            this.overriddenAction = overriddenAction;
        }

        @Override
        public final Builder overriddenAction(String overriddenAction) {
            this.overriddenAction = overriddenAction;
            return this;
        }

        @Override
        public SampledHTTPRequest build() {
            return new SampledHTTPRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
