/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRegexPatternSetRequest extends Wafv2Request implements
        ToCopyableBuilder<UpdateRegexPatternSetRequest.Builder, UpdateRegexPatternSetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateRegexPatternSetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(UpdateRegexPatternSetRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateRegexPatternSetRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateRegexPatternSetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Regex>> REGULAR_EXPRESSION_LIST_FIELD = SdkField
            .<List<Regex>> builder(MarshallingType.LIST)
            .memberName("RegularExpressionList")
            .getter(getter(UpdateRegexPatternSetRequest::regularExpressionList))
            .setter(setter(Builder::regularExpressionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegularExpressionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Regex> builder(MarshallingType.SDK_POJO)
                                            .constructor(Regex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LockToken").getter(getter(UpdateRegexPatternSetRequest::lockToken)).setter(setter(Builder::lockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD,
            ID_FIELD, DESCRIPTION_FIELD, REGULAR_EXPRESSION_LIST_FIELD, LOCK_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String scope;

    private final String id;

    private final String description;

    private final List<Regex> regularExpressionList;

    private final String lockToken;

    private UpdateRegexPatternSetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.id = builder.id;
        this.description = builder.description;
        this.regularExpressionList = builder.regularExpressionList;
        this.lockToken = builder.lockToken;
    }

    /**
     * <p>
     * The name of the set. You cannot change the name after you create the set.
     * </p>
     * 
     * @return The name of the set. You cannot change the name after you create the set.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
     * </p>
     * <p>
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
     *         <p>
     *         To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CLI - Specify the Region when you use the CloudFront scope:
     *         <code>--scope=CLOUDFRONT --region=us-east-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         API and SDKs - For all calls, use the Region endpoint us-east-1.
     *         </p>
     *         </li>
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it
     * to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the set. This ID is returned in the responses to create and list commands. You
     *         provide it to operations like update and delete.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A description of the set that helps with identification.
     * </p>
     * 
     * @return A description of the set that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegularExpressionList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegularExpressionList() {
        return regularExpressionList != null && !(regularExpressionList instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegularExpressionList} method.
     * </p>
     * 
     * @return
     */
    public final List<Regex> regularExpressionList() {
        return regularExpressionList;
    }

    /**
     * <p>
     * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests,
     * to mark the state of the entity at the time of the request. To make changes to the entity associated with the
     * token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token
     * to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made,
     * the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another
     * <code>get</code>, and use the new token returned by that operation.
     * </p>
     * 
     * @return A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
     *         requests, to mark the state of the entity at the time of the request. To make changes to the entity
     *         associated with the token, you provide the token to operations like <code>update</code> and
     *         <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you
     *         last retrieved it. If a change has been made, the update fails with a
     *         <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the
     *         new token returned by that operation.
     */
    public final String lockToken() {
        return lockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegularExpressionList() ? regularExpressionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lockToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRegexPatternSetRequest)) {
            return false;
        }
        UpdateRegexPatternSetRequest other = (UpdateRegexPatternSetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && hasRegularExpressionList() == other.hasRegularExpressionList()
                && Objects.equals(regularExpressionList(), other.regularExpressionList())
                && Objects.equals(lockToken(), other.lockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRegexPatternSetRequest").add("Name", name()).add("Scope", scopeAsString()).add("Id", id())
                .add("Description", description())
                .add("RegularExpressionList", hasRegularExpressionList() ? regularExpressionList() : null)
                .add("LockToken", lockToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RegularExpressionList":
            return Optional.ofNullable(clazz.cast(regularExpressionList()));
        case "LockToken":
            return Optional.ofNullable(clazz.cast(lockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RegularExpressionList", REGULAR_EXPRESSION_LIST_FIELD);
        map.put("LockToken", LOCK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRegexPatternSetRequest, T> g) {
        return obj -> g.apply((UpdateRegexPatternSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRegexPatternSetRequest> {
        /**
         * <p>
         * The name of the set. You cannot change the name after you create the set.
         * </p>
         * 
         * @param name
         *        The name of the set. You cannot change the name after you create the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution.
         * </p>
         * <p>
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CLI - Specify the Region when you use the CloudFront scope:
         * <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scope
         *        Specifies whether this is for a global resource type, such as a Amazon CloudFront distribution. </p>
         *        <p>
         *        To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CLI - Specify the Region when you use the CloudFront scope:
         *        <code>--scope=CLOUDFRONT --region=us-east-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        API and SDKs - For all calls, use the Region endpoint us-east-1.
         *        </p>
         *        </li>
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You
         * provide it to operations like update and delete.
         * </p>
         * 
         * @param id
         *        A unique identifier for the set. This ID is returned in the responses to create and list commands. You
         *        provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description of the set that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the set that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p/>
         * 
         * @param regularExpressionList
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regularExpressionList(Collection<Regex> regularExpressionList);

        /**
         * <p/>
         * 
         * @param regularExpressionList
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regularExpressionList(Regex... regularExpressionList);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.wafv2.model.Regex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder#build()} is called immediately and its
         * result is passed to {@link #regularExpressionList(List<Regex>)}.
         * 
         * @param regularExpressionList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regularExpressionList(java.util.Collection<Regex>)
         */
        Builder regularExpressionList(Consumer<Regex.Builder>... regularExpressionList);

        /**
         * <p>
         * A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code>
         * requests, to mark the state of the entity at the time of the request. To make changes to the entity
         * associated with the token, you provide the token to operations like <code>update</code> and
         * <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last
         * retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If
         * this happens, perform another <code>get</code>, and use the new token returned by that operation.
         * </p>
         * 
         * @param lockToken
         *        A token used for optimistic locking. WAF returns a token to your <code>get</code> and
         *        <code>list</code> requests, to mark the state of the entity at the time of the request. To make
         *        changes to the entity associated with the token, you provide the token to operations like
         *        <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been
         *        made to the entity since you last retrieved it. If a change has been made, the update fails with a
         *        <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use
         *        the new token returned by that operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockToken(String lockToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Wafv2Request.BuilderImpl implements Builder {
        private String name;

        private String scope;

        private String id;

        private String description;

        private List<Regex> regularExpressionList = DefaultSdkAutoConstructList.getInstance();

        private String lockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRegexPatternSetRequest model) {
            super(model);
            name(model.name);
            scope(model.scope);
            id(model.id);
            description(model.description);
            regularExpressionList(model.regularExpressionList);
            lockToken(model.lockToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Regex.Builder> getRegularExpressionList() {
            List<Regex.Builder> result = RegularExpressionListCopier.copyToBuilder(this.regularExpressionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegularExpressionList(Collection<Regex.BuilderImpl> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copyFromBuilder(regularExpressionList);
        }

        @Override
        public final Builder regularExpressionList(Collection<Regex> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copy(regularExpressionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Regex... regularExpressionList) {
            regularExpressionList(Arrays.asList(regularExpressionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Consumer<Regex.Builder>... regularExpressionList) {
            regularExpressionList(Stream.of(regularExpressionList).map(c -> Regex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLockToken() {
            return lockToken;
        }

        public final void setLockToken(String lockToken) {
            this.lockToken = lockToken;
        }

        @Override
        public final Builder lockToken(String lockToken) {
            this.lockToken = lockToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRegexPatternSetRequest build() {
            return new UpdateRegexPatternSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
