/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataProtectionAction {
    SUBSTITUTION("SUBSTITUTION"),
    HASH("HASH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataProtectionAction> VALUE_MAP;
    private final String value;

    private DataProtectionAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataProtectionAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataProtectionAction> knownValues() {
        EnumSet<DataProtectionAction> knownValues = EnumSet.allOf(DataProtectionAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataProtectionAction.class, DataProtectionAction::toString);
    }
}

