/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterBehavior {
    KEEP("KEEP"),
    DROP("DROP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterBehavior> VALUE_MAP;
    private final String value;

    private FilterBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterBehavior> knownValues() {
        EnumSet<FilterBehavior> knownValues = EnumSet.allOf(FilterBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterBehavior.class, FilterBehavior::toString);
    }
}

