/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.services.wafv2.model.WebACLSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.WebACLSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebAcLsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListWebAcLsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListWebAcLsResponse.getter(ListWebAcLsResponse::nextMarker)).setter(ListWebAcLsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<WebACLSummary>> WEB_AC_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WebACLs").getter(ListWebAcLsResponse.getter(ListWebAcLsResponse::webACLs)).setter(ListWebAcLsResponse.setter(Builder::webACLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebACLSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, WEB_AC_LS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWebAcLsResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<WebACLSummary> webACLs;

    private ListWebAcLsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.webACLs = builder.webACLs;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasWebACLs() {
        return this.webACLs != null && !(this.webACLs instanceof SdkAutoConstructList);
    }

    public final List<WebACLSummary> webACLs() {
        return this.webACLs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebACLs() ? this.webACLs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebAcLsResponse)) {
            return false;
        }
        ListWebAcLsResponse other = (ListWebAcLsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasWebACLs() == other.hasWebACLs() && Objects.equals(this.webACLs(), other.webACLs());
    }

    public final String toString() {
        return ToString.builder((String)"ListWebAcLsResponse").add("NextMarker", (Object)this.nextMarker()).add("WebACLs", this.hasWebACLs() ? this.webACLs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "WebACLs": {
                return Optional.ofNullable(clazz.cast(this.webACLs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("WebACLs", WEB_AC_LS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWebAcLsResponse, T> g) {
        return obj -> g.apply((ListWebAcLsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<WebACLSummary> webACLs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebAcLsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.webACLs(model.webACLs);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<WebACLSummary.Builder> getWebACLs() {
            List<WebACLSummary.Builder> result = WebACLSummariesCopier.copyToBuilder(this.webACLs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebACLs(Collection<WebACLSummary.BuilderImpl> webACLs) {
            this.webACLs = WebACLSummariesCopier.copyFromBuilder(webACLs);
        }

        @Override
        public final Builder webACLs(Collection<WebACLSummary> webACLs) {
            this.webACLs = WebACLSummariesCopier.copy(webACLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webACLs(WebACLSummary ... webACLs) {
            this.webACLs(Arrays.asList(webACLs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webACLs(Consumer<WebACLSummary.Builder> ... webACLs) {
            this.webACLs(Stream.of(webACLs).map(c -> (WebACLSummary)((WebACLSummary.Builder)WebACLSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWebAcLsResponse build() {
            return new ListWebAcLsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebAcLsResponse> {
        public Builder nextMarker(String var1);

        public Builder webACLs(Collection<WebACLSummary> var1);

        public Builder webACLs(WebACLSummary ... var1);

        public Builder webACLs(Consumer<WebACLSummary.Builder> ... var1);
    }
}

