/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse;

public class ListCheckSummariesPublisher
implements SdkPublisher<ListCheckSummariesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListCheckSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCheckSummariesPublisher(WellArchitectedAsyncClient client, ListCheckSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCheckSummariesPublisher(WellArchitectedAsyncClient client, ListCheckSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCheckSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCheckSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCheckSummariesResponseFetcher
    implements AsyncPageFetcher<ListCheckSummariesResponse> {
        private ListCheckSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListCheckSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCheckSummariesResponse> nextPage(ListCheckSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListCheckSummariesPublisher.this.client.listCheckSummaries(ListCheckSummariesPublisher.this.firstRequest);
            }
            return ListCheckSummariesPublisher.this.client.listCheckSummaries((ListCheckSummariesRequest)((Object)ListCheckSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

