/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse;

public class ListCheckSummariesIterable
implements SdkIterable<ListCheckSummariesResponse> {
    private final WellArchitectedClient client;
    private final ListCheckSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCheckSummariesIterable(WellArchitectedClient client, ListCheckSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCheckSummariesResponseFetcher();
    }

    public Iterator<ListCheckSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCheckSummariesResponseFetcher
    implements SyncPageFetcher<ListCheckSummariesResponse> {
        private ListCheckSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListCheckSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCheckSummariesResponse nextPage(ListCheckSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListCheckSummariesIterable.this.client.listCheckSummaries(ListCheckSummariesIterable.this.firstRequest);
            }
            return ListCheckSummariesIterable.this.client.listCheckSummaries((ListCheckSummariesRequest)((Object)ListCheckSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

