/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.ContentCategoryType;
import software.amazon.awssdk.services.workdocs.model.DateRangeType;
import software.amazon.awssdk.services.workdocs.model.LanguageCodeType;
import software.amazon.awssdk.services.workdocs.model.LongRangeType;
import software.amazon.awssdk.services.workdocs.model.SearchAncestorIdListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchCollectionType;
import software.amazon.awssdk.services.workdocs.model.SearchCollectionTypeListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchContentCategoryTypeListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchLabelListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchPrincipalType;
import software.amazon.awssdk.services.workdocs.model.SearchPrincipalTypeListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchResourceType;
import software.amazon.awssdk.services.workdocs.model.SearchResourceTypeListCopier;
import software.amazon.awssdk.services.workdocs.model.TextLocaleTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filters> {
    private static final SdkField<List<String>> TEXT_LOCALES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextLocales").getter(Filters.getter(Filters::textLocalesAsStrings)).setter(Filters.setter(Builder::textLocalesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextLocales").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContentCategories").getter(Filters.getter(Filters::contentCategoriesAsStrings)).setter(Filters.setter(Builder::contentCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(Filters.getter(Filters::resourceTypesAsStrings)).setter(Filters.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(Filters.getter(Filters::labels)).setter(Filters.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SearchPrincipalType>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(Filters.getter(Filters::principals)).setter(Filters.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchPrincipalType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ANCESTOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AncestorIds").getter(Filters.getter(Filters::ancestorIds)).setter(Filters.setter(Builder::ancestorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AncestorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SEARCH_COLLECTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SearchCollectionTypes").getter(Filters.getter(Filters::searchCollectionTypesAsStrings)).setter(Filters.setter(Builder::searchCollectionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCollectionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LongRangeType> SIZE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SizeRange").getter(Filters.getter(Filters::sizeRange)).setter(Filters.setter(Builder::sizeRange)).constructor(LongRangeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeRange").build()}).build();
    private static final SdkField<DateRangeType> CREATED_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedRange").getter(Filters.getter(Filters::createdRange)).setter(Filters.setter(Builder::createdRange)).constructor(DateRangeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRange").build()}).build();
    private static final SdkField<DateRangeType> MODIFIED_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModifiedRange").getter(Filters.getter(Filters::modifiedRange)).setter(Filters.setter(Builder::modifiedRange)).constructor(DateRangeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LOCALES_FIELD, CONTENT_CATEGORIES_FIELD, RESOURCE_TYPES_FIELD, LABELS_FIELD, PRINCIPALS_FIELD, ANCESTOR_IDS_FIELD, SEARCH_COLLECTION_TYPES_FIELD, SIZE_RANGE_FIELD, CREATED_RANGE_FIELD, MODIFIED_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TextLocales", TEXT_LOCALES_FIELD);
            this.put("ContentCategories", CONTENT_CATEGORIES_FIELD);
            this.put("ResourceTypes", RESOURCE_TYPES_FIELD);
            this.put("Labels", LABELS_FIELD);
            this.put("Principals", PRINCIPALS_FIELD);
            this.put("AncestorIds", ANCESTOR_IDS_FIELD);
            this.put("SearchCollectionTypes", SEARCH_COLLECTION_TYPES_FIELD);
            this.put("SizeRange", SIZE_RANGE_FIELD);
            this.put("CreatedRange", CREATED_RANGE_FIELD);
            this.put("ModifiedRange", MODIFIED_RANGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> textLocales;
    private final List<String> contentCategories;
    private final List<String> resourceTypes;
    private final List<String> labels;
    private final List<SearchPrincipalType> principals;
    private final List<String> ancestorIds;
    private final List<String> searchCollectionTypes;
    private final LongRangeType sizeRange;
    private final DateRangeType createdRange;
    private final DateRangeType modifiedRange;

    private Filters(BuilderImpl builder) {
        this.textLocales = builder.textLocales;
        this.contentCategories = builder.contentCategories;
        this.resourceTypes = builder.resourceTypes;
        this.labels = builder.labels;
        this.principals = builder.principals;
        this.ancestorIds = builder.ancestorIds;
        this.searchCollectionTypes = builder.searchCollectionTypes;
        this.sizeRange = builder.sizeRange;
        this.createdRange = builder.createdRange;
        this.modifiedRange = builder.modifiedRange;
    }

    public final List<LanguageCodeType> textLocales() {
        return TextLocaleTypeListCopier.copyStringToEnum(this.textLocales);
    }

    public final boolean hasTextLocales() {
        return this.textLocales != null && !(this.textLocales instanceof SdkAutoConstructList);
    }

    public final List<String> textLocalesAsStrings() {
        return this.textLocales;
    }

    public final List<ContentCategoryType> contentCategories() {
        return SearchContentCategoryTypeListCopier.copyStringToEnum(this.contentCategories);
    }

    public final boolean hasContentCategories() {
        return this.contentCategories != null && !(this.contentCategories instanceof SdkAutoConstructList);
    }

    public final List<String> contentCategoriesAsStrings() {
        return this.contentCategories;
    }

    public final List<SearchResourceType> resourceTypes() {
        return SearchResourceTypeListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<SearchPrincipalType> principals() {
        return this.principals;
    }

    public final boolean hasAncestorIds() {
        return this.ancestorIds != null && !(this.ancestorIds instanceof SdkAutoConstructList);
    }

    public final List<String> ancestorIds() {
        return this.ancestorIds;
    }

    public final List<SearchCollectionType> searchCollectionTypes() {
        return SearchCollectionTypeListCopier.copyStringToEnum(this.searchCollectionTypes);
    }

    public final boolean hasSearchCollectionTypes() {
        return this.searchCollectionTypes != null && !(this.searchCollectionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> searchCollectionTypesAsStrings() {
        return this.searchCollectionTypes;
    }

    public final LongRangeType sizeRange() {
        return this.sizeRange;
    }

    public final DateRangeType createdRange() {
        return this.createdRange;
    }

    public final DateRangeType modifiedRange() {
        return this.modifiedRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextLocales() ? this.textLocalesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentCategories() ? this.contentCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAncestorIds() ? this.ancestorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchCollectionTypes() ? this.searchCollectionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return this.hasTextLocales() == other.hasTextLocales() && Objects.equals(this.textLocalesAsStrings(), other.textLocalesAsStrings()) && this.hasContentCategories() == other.hasContentCategories() && Objects.equals(this.contentCategoriesAsStrings(), other.contentCategoriesAsStrings()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && this.hasAncestorIds() == other.hasAncestorIds() && Objects.equals(this.ancestorIds(), other.ancestorIds()) && this.hasSearchCollectionTypes() == other.hasSearchCollectionTypes() && Objects.equals(this.searchCollectionTypesAsStrings(), other.searchCollectionTypesAsStrings()) && Objects.equals(this.sizeRange(), other.sizeRange()) && Objects.equals(this.createdRange(), other.createdRange()) && Objects.equals(this.modifiedRange(), other.modifiedRange());
    }

    public final String toString() {
        return ToString.builder((String)"Filters").add("TextLocales", this.hasTextLocales() ? this.textLocalesAsStrings() : null).add("ContentCategories", this.hasContentCategories() ? this.contentCategoriesAsStrings() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("Labels", this.hasLabels() ? this.labels() : null).add("Principals", this.hasPrincipals() ? this.principals() : null).add("AncestorIds", this.hasAncestorIds() ? this.ancestorIds() : null).add("SearchCollectionTypes", this.hasSearchCollectionTypes() ? this.searchCollectionTypesAsStrings() : null).add("SizeRange", (Object)this.sizeRange()).add("CreatedRange", (Object)this.createdRange()).add("ModifiedRange", (Object)this.modifiedRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextLocales": {
                return Optional.ofNullable(clazz.cast(this.textLocalesAsStrings()));
            }
            case "ContentCategories": {
                return Optional.ofNullable(clazz.cast(this.contentCategoriesAsStrings()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "AncestorIds": {
                return Optional.ofNullable(clazz.cast(this.ancestorIds()));
            }
            case "SearchCollectionTypes": {
                return Optional.ofNullable(clazz.cast(this.searchCollectionTypesAsStrings()));
            }
            case "SizeRange": {
                return Optional.ofNullable(clazz.cast(this.sizeRange()));
            }
            case "CreatedRange": {
                return Optional.ofNullable(clazz.cast(this.createdRange()));
            }
            case "ModifiedRange": {
                return Optional.ofNullable(clazz.cast(this.modifiedRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> textLocales = DefaultSdkAutoConstructList.getInstance();
        private List<String> contentCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private List<SearchPrincipalType> principals = DefaultSdkAutoConstructList.getInstance();
        private List<String> ancestorIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> searchCollectionTypes = DefaultSdkAutoConstructList.getInstance();
        private LongRangeType sizeRange;
        private DateRangeType createdRange;
        private DateRangeType modifiedRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            this.textLocalesWithStrings(model.textLocales);
            this.contentCategoriesWithStrings(model.contentCategories);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.labels(model.labels);
            this.principals(model.principals);
            this.ancestorIds(model.ancestorIds);
            this.searchCollectionTypesWithStrings(model.searchCollectionTypes);
            this.sizeRange(model.sizeRange);
            this.createdRange(model.createdRange);
            this.modifiedRange(model.modifiedRange);
        }

        public final Collection<String> getTextLocales() {
            if (this.textLocales instanceof SdkAutoConstructList) {
                return null;
            }
            return this.textLocales;
        }

        public final void setTextLocales(Collection<String> textLocales) {
            this.textLocales = TextLocaleTypeListCopier.copy(textLocales);
        }

        @Override
        public final Builder textLocalesWithStrings(Collection<String> textLocales) {
            this.textLocales = TextLocaleTypeListCopier.copy(textLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLocalesWithStrings(String ... textLocales) {
            this.textLocalesWithStrings(Arrays.asList(textLocales));
            return this;
        }

        @Override
        public final Builder textLocales(Collection<LanguageCodeType> textLocales) {
            this.textLocales = TextLocaleTypeListCopier.copyEnumToString(textLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textLocales(LanguageCodeType ... textLocales) {
            this.textLocales(Arrays.asList(textLocales));
            return this;
        }

        public final Collection<String> getContentCategories() {
            if (this.contentCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contentCategories;
        }

        public final void setContentCategories(Collection<String> contentCategories) {
            this.contentCategories = SearchContentCategoryTypeListCopier.copy(contentCategories);
        }

        @Override
        public final Builder contentCategoriesWithStrings(Collection<String> contentCategories) {
            this.contentCategories = SearchContentCategoryTypeListCopier.copy(contentCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentCategoriesWithStrings(String ... contentCategories) {
            this.contentCategoriesWithStrings(Arrays.asList(contentCategories));
            return this;
        }

        @Override
        public final Builder contentCategories(Collection<ContentCategoryType> contentCategories) {
            this.contentCategories = SearchContentCategoryTypeListCopier.copyEnumToString(contentCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentCategories(ContentCategoryType ... contentCategories) {
            this.contentCategories(Arrays.asList(contentCategories));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = SearchResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = SearchResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<SearchResourceType> resourceTypes) {
            this.resourceTypes = SearchResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(SearchResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SearchLabelListCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SearchLabelListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final List<SearchPrincipalType.Builder> getPrincipals() {
            List<SearchPrincipalType.Builder> result = SearchPrincipalTypeListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipals(Collection<SearchPrincipalType.BuilderImpl> principals) {
            this.principals = SearchPrincipalTypeListCopier.copyFromBuilder(principals);
        }

        @Override
        public final Builder principals(Collection<SearchPrincipalType> principals) {
            this.principals = SearchPrincipalTypeListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(SearchPrincipalType ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<SearchPrincipalType.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (SearchPrincipalType)((SearchPrincipalType.Builder)SearchPrincipalType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAncestorIds() {
            if (this.ancestorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ancestorIds;
        }

        public final void setAncestorIds(Collection<String> ancestorIds) {
            this.ancestorIds = SearchAncestorIdListCopier.copy(ancestorIds);
        }

        @Override
        public final Builder ancestorIds(Collection<String> ancestorIds) {
            this.ancestorIds = SearchAncestorIdListCopier.copy(ancestorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ancestorIds(String ... ancestorIds) {
            this.ancestorIds(Arrays.asList(ancestorIds));
            return this;
        }

        public final Collection<String> getSearchCollectionTypes() {
            if (this.searchCollectionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.searchCollectionTypes;
        }

        public final void setSearchCollectionTypes(Collection<String> searchCollectionTypes) {
            this.searchCollectionTypes = SearchCollectionTypeListCopier.copy(searchCollectionTypes);
        }

        @Override
        public final Builder searchCollectionTypesWithStrings(Collection<String> searchCollectionTypes) {
            this.searchCollectionTypes = SearchCollectionTypeListCopier.copy(searchCollectionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchCollectionTypesWithStrings(String ... searchCollectionTypes) {
            this.searchCollectionTypesWithStrings(Arrays.asList(searchCollectionTypes));
            return this;
        }

        @Override
        public final Builder searchCollectionTypes(Collection<SearchCollectionType> searchCollectionTypes) {
            this.searchCollectionTypes = SearchCollectionTypeListCopier.copyEnumToString(searchCollectionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchCollectionTypes(SearchCollectionType ... searchCollectionTypes) {
            this.searchCollectionTypes(Arrays.asList(searchCollectionTypes));
            return this;
        }

        public final LongRangeType.Builder getSizeRange() {
            return this.sizeRange != null ? this.sizeRange.toBuilder() : null;
        }

        public final void setSizeRange(LongRangeType.BuilderImpl sizeRange) {
            this.sizeRange = sizeRange != null ? sizeRange.build() : null;
        }

        @Override
        public final Builder sizeRange(LongRangeType sizeRange) {
            this.sizeRange = sizeRange;
            return this;
        }

        public final DateRangeType.Builder getCreatedRange() {
            return this.createdRange != null ? this.createdRange.toBuilder() : null;
        }

        public final void setCreatedRange(DateRangeType.BuilderImpl createdRange) {
            this.createdRange = createdRange != null ? createdRange.build() : null;
        }

        @Override
        public final Builder createdRange(DateRangeType createdRange) {
            this.createdRange = createdRange;
            return this;
        }

        public final DateRangeType.Builder getModifiedRange() {
            return this.modifiedRange != null ? this.modifiedRange.toBuilder() : null;
        }

        public final void setModifiedRange(DateRangeType.BuilderImpl modifiedRange) {
            this.modifiedRange = modifiedRange != null ? modifiedRange.build() : null;
        }

        @Override
        public final Builder modifiedRange(DateRangeType modifiedRange) {
            this.modifiedRange = modifiedRange;
            return this;
        }

        public Filters build() {
            return new Filters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filters> {
        public Builder textLocalesWithStrings(Collection<String> var1);

        public Builder textLocalesWithStrings(String ... var1);

        public Builder textLocales(Collection<LanguageCodeType> var1);

        public Builder textLocales(LanguageCodeType ... var1);

        public Builder contentCategoriesWithStrings(Collection<String> var1);

        public Builder contentCategoriesWithStrings(String ... var1);

        public Builder contentCategories(Collection<ContentCategoryType> var1);

        public Builder contentCategories(ContentCategoryType ... var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<SearchResourceType> var1);

        public Builder resourceTypes(SearchResourceType ... var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder principals(Collection<SearchPrincipalType> var1);

        public Builder principals(SearchPrincipalType ... var1);

        public Builder principals(Consumer<SearchPrincipalType.Builder> ... var1);

        public Builder ancestorIds(Collection<String> var1);

        public Builder ancestorIds(String ... var1);

        public Builder searchCollectionTypesWithStrings(Collection<String> var1);

        public Builder searchCollectionTypesWithStrings(String ... var1);

        public Builder searchCollectionTypes(Collection<SearchCollectionType> var1);

        public Builder searchCollectionTypes(SearchCollectionType ... var1);

        public Builder sizeRange(LongRangeType var1);

        default public Builder sizeRange(Consumer<LongRangeType.Builder> sizeRange) {
            return this.sizeRange((LongRangeType)((LongRangeType.Builder)LongRangeType.builder().applyMutation(sizeRange)).build());
        }

        public Builder createdRange(DateRangeType var1);

        default public Builder createdRange(Consumer<DateRangeType.Builder> createdRange) {
            return this.createdRange((DateRangeType)((DateRangeType.Builder)DateRangeType.builder().applyMutation(createdRange)).build());
        }

        public Builder modifiedRange(DateRangeType var1);

        default public Builder modifiedRange(Consumer<DateRangeType.Builder> modifiedRange) {
            return this.modifiedRange((DateRangeType)((DateRangeType.Builder)DateRangeType.builder().applyMutation(modifiedRange)).build());
        }
    }
}

