/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceSortType {
    DATE("DATE"),
    NAME("NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceSortType> VALUE_MAP;
    private final String value;

    private ResourceSortType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSortType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSortType> knownValues() {
        EnumSet<ResourceSortType> knownValues = EnumSet.allOf(ResourceSortType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceSortType.class, ResourceSortType::toString);
    }
}

