/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.CommentMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentMetadata;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.FolderMetadata;
import software.amazon.awssdk.services.workdocs.model.ResponseItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseItem> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResponseItem.getter(ResponseItem::resourceTypeAsString)).setter(ResponseItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> WEB_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebUrl").getter(ResponseItem.getter(ResponseItem::webUrl)).setter(ResponseItem.setter(Builder::webUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebUrl").build()}).build();
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(ResponseItem.getter(ResponseItem::documentMetadata)).setter(ResponseItem.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<FolderMetadata> FOLDER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FolderMetadata").getter(ResponseItem.getter(ResponseItem::folderMetadata)).setter(ResponseItem.setter(Builder::folderMetadata)).constructor(FolderMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderMetadata").build()}).build();
    private static final SdkField<CommentMetadata> COMMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommentMetadata").getter(ResponseItem.getter(ResponseItem::commentMetadata)).setter(ResponseItem.setter(Builder::commentMetadata)).constructor(CommentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentMetadata").build()}).build();
    private static final SdkField<DocumentVersionMetadata> DOCUMENT_VERSION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentVersionMetadata").getter(ResponseItem.getter(ResponseItem::documentVersionMetadata)).setter(ResponseItem.setter(Builder::documentVersionMetadata)).constructor(DocumentVersionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersionMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, WEB_URL_FIELD, DOCUMENT_METADATA_FIELD, FOLDER_METADATA_FIELD, COMMENT_METADATA_FIELD, DOCUMENT_VERSION_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponseItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String webUrl;
    private final DocumentMetadata documentMetadata;
    private final FolderMetadata folderMetadata;
    private final CommentMetadata commentMetadata;
    private final DocumentVersionMetadata documentVersionMetadata;

    private ResponseItem(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.webUrl = builder.webUrl;
        this.documentMetadata = builder.documentMetadata;
        this.folderMetadata = builder.folderMetadata;
        this.commentMetadata = builder.commentMetadata;
        this.documentVersionMetadata = builder.documentVersionMetadata;
    }

    public final ResponseItemType resourceType() {
        return ResponseItemType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String webUrl() {
        return this.webUrl;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final FolderMetadata folderMetadata() {
        return this.folderMetadata;
    }

    public final CommentMetadata commentMetadata() {
        return this.commentMetadata;
    }

    public final DocumentVersionMetadata documentVersionMetadata() {
        return this.documentVersionMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.commentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersionMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseItem)) {
            return false;
        }
        ResponseItem other = (ResponseItem)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.webUrl(), other.webUrl()) && Objects.equals(this.documentMetadata(), other.documentMetadata()) && Objects.equals(this.folderMetadata(), other.folderMetadata()) && Objects.equals(this.commentMetadata(), other.commentMetadata()) && Objects.equals(this.documentVersionMetadata(), other.documentVersionMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseItem").add("ResourceType", (Object)this.resourceTypeAsString()).add("WebUrl", (Object)(this.webUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("DocumentMetadata", (Object)this.documentMetadata()).add("FolderMetadata", (Object)this.folderMetadata()).add("CommentMetadata", (Object)this.commentMetadata()).add("DocumentVersionMetadata", (Object)this.documentVersionMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "WebUrl": {
                return Optional.ofNullable(clazz.cast(this.webUrl()));
            }
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "FolderMetadata": {
                return Optional.ofNullable(clazz.cast(this.folderMetadata()));
            }
            case "CommentMetadata": {
                return Optional.ofNullable(clazz.cast(this.commentMetadata()));
            }
            case "DocumentVersionMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentVersionMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("WebUrl", WEB_URL_FIELD);
        map.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
        map.put("FolderMetadata", FOLDER_METADATA_FIELD);
        map.put("CommentMetadata", COMMENT_METADATA_FIELD);
        map.put("DocumentVersionMetadata", DOCUMENT_VERSION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseItem, T> g) {
        return obj -> g.apply((ResponseItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String webUrl;
        private DocumentMetadata documentMetadata;
        private FolderMetadata folderMetadata;
        private CommentMetadata commentMetadata;
        private DocumentVersionMetadata documentVersionMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseItem model) {
            this.resourceType(model.resourceType);
            this.webUrl(model.webUrl);
            this.documentMetadata(model.documentMetadata);
            this.folderMetadata(model.folderMetadata);
            this.commentMetadata(model.commentMetadata);
            this.documentVersionMetadata(model.documentVersionMetadata);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResponseItemType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getWebUrl() {
            return this.webUrl;
        }

        public final void setWebUrl(String webUrl) {
            this.webUrl = webUrl;
        }

        @Override
        public final Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final FolderMetadata.Builder getFolderMetadata() {
            return this.folderMetadata != null ? this.folderMetadata.toBuilder() : null;
        }

        public final void setFolderMetadata(FolderMetadata.BuilderImpl folderMetadata) {
            this.folderMetadata = folderMetadata != null ? folderMetadata.build() : null;
        }

        @Override
        public final Builder folderMetadata(FolderMetadata folderMetadata) {
            this.folderMetadata = folderMetadata;
            return this;
        }

        public final CommentMetadata.Builder getCommentMetadata() {
            return this.commentMetadata != null ? this.commentMetadata.toBuilder() : null;
        }

        public final void setCommentMetadata(CommentMetadata.BuilderImpl commentMetadata) {
            this.commentMetadata = commentMetadata != null ? commentMetadata.build() : null;
        }

        @Override
        public final Builder commentMetadata(CommentMetadata commentMetadata) {
            this.commentMetadata = commentMetadata;
            return this;
        }

        public final DocumentVersionMetadata.Builder getDocumentVersionMetadata() {
            return this.documentVersionMetadata != null ? this.documentVersionMetadata.toBuilder() : null;
        }

        public final void setDocumentVersionMetadata(DocumentVersionMetadata.BuilderImpl documentVersionMetadata) {
            this.documentVersionMetadata = documentVersionMetadata != null ? documentVersionMetadata.build() : null;
        }

        @Override
        public final Builder documentVersionMetadata(DocumentVersionMetadata documentVersionMetadata) {
            this.documentVersionMetadata = documentVersionMetadata;
            return this;
        }

        public ResponseItem build() {
            return new ResponseItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseItem> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResponseItemType var1);

        public Builder webUrl(String var1);

        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder folderMetadata(FolderMetadata var1);

        default public Builder folderMetadata(Consumer<FolderMetadata.Builder> folderMetadata) {
            return this.folderMetadata((FolderMetadata)((FolderMetadata.Builder)FolderMetadata.builder().applyMutation(folderMetadata)).build());
        }

        public Builder commentMetadata(CommentMetadata var1);

        default public Builder commentMetadata(Consumer<CommentMetadata.Builder> commentMetadata) {
            return this.commentMetadata((CommentMetadata)((CommentMetadata.Builder)CommentMetadata.builder().applyMutation(commentMetadata)).build());
        }

        public Builder documentVersionMetadata(DocumentVersionMetadata var1);

        default public Builder documentVersionMetadata(Consumer<DocumentVersionMetadata.Builder> documentVersionMetadata) {
            return this.documentVersionMetadata((DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().applyMutation(documentVersionMetadata)).build());
        }
    }
}

