/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPersonalAccessTokensResponse extends WorkMailResponse implements
        ToCopyableBuilder<ListPersonalAccessTokensResponse.Builder, ListPersonalAccessTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPersonalAccessTokensResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PersonalAccessTokenSummary>> PERSONAL_ACCESS_TOKEN_SUMMARIES_FIELD = SdkField
            .<List<PersonalAccessTokenSummary>> builder(MarshallingType.LIST)
            .memberName("PersonalAccessTokenSummaries")
            .getter(getter(ListPersonalAccessTokensResponse::personalAccessTokenSummaries))
            .setter(setter(Builder::personalAccessTokenSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PersonalAccessTokenSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PersonalAccessTokenSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PERSONAL_ACCESS_TOKEN_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<PersonalAccessTokenSummary> personalAccessTokenSummaries;

    private ListPersonalAccessTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.personalAccessTokenSummaries = builder.personalAccessTokenSummaries;
    }

    /**
     * <p>
     * The token from the previous response to query the next page.
     * </p>
     * 
     * @return The token from the previous response to query the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PersonalAccessTokenSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPersonalAccessTokenSummaries() {
        return personalAccessTokenSummaries != null && !(personalAccessTokenSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all the personal tokens in an organization or user, if user ID is provided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersonalAccessTokenSummaries} method.
     * </p>
     * 
     * @return Lists all the personal tokens in an organization or user, if user ID is provided.
     */
    public final List<PersonalAccessTokenSummary> personalAccessTokenSummaries() {
        return personalAccessTokenSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPersonalAccessTokenSummaries() ? personalAccessTokenSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPersonalAccessTokensResponse)) {
            return false;
        }
        ListPersonalAccessTokensResponse other = (ListPersonalAccessTokensResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasPersonalAccessTokenSummaries() == other.hasPersonalAccessTokenSummaries()
                && Objects.equals(personalAccessTokenSummaries(), other.personalAccessTokenSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPersonalAccessTokensResponse").add("NextToken", nextToken())
                .add("PersonalAccessTokenSummaries", hasPersonalAccessTokenSummaries() ? personalAccessTokenSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PersonalAccessTokenSummaries":
            return Optional.ofNullable(clazz.cast(personalAccessTokenSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PersonalAccessTokenSummaries", PERSONAL_ACCESS_TOKEN_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPersonalAccessTokensResponse, T> g) {
        return obj -> g.apply((ListPersonalAccessTokensResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPersonalAccessTokensResponse> {
        /**
         * <p>
         * The token from the previous response to query the next page.
         * </p>
         * 
         * @param nextToken
         *        The token from the previous response to query the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Lists all the personal tokens in an organization or user, if user ID is provided.
         * </p>
         * 
         * @param personalAccessTokenSummaries
         *        Lists all the personal tokens in an organization or user, if user ID is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalAccessTokenSummaries(Collection<PersonalAccessTokenSummary> personalAccessTokenSummaries);

        /**
         * <p>
         * Lists all the personal tokens in an organization or user, if user ID is provided.
         * </p>
         * 
         * @param personalAccessTokenSummaries
         *        Lists all the personal tokens in an organization or user, if user ID is provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalAccessTokenSummaries(PersonalAccessTokenSummary... personalAccessTokenSummaries);

        /**
         * <p>
         * Lists all the personal tokens in an organization or user, if user ID is provided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #personalAccessTokenSummaries(List<PersonalAccessTokenSummary>)}.
         * 
         * @param personalAccessTokenSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalAccessTokenSummaries(java.util.Collection<PersonalAccessTokenSummary>)
         */
        Builder personalAccessTokenSummaries(Consumer<PersonalAccessTokenSummary.Builder>... personalAccessTokenSummaries);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PersonalAccessTokenSummary> personalAccessTokenSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPersonalAccessTokensResponse model) {
            super(model);
            nextToken(model.nextToken);
            personalAccessTokenSummaries(model.personalAccessTokenSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PersonalAccessTokenSummary.Builder> getPersonalAccessTokenSummaries() {
            List<PersonalAccessTokenSummary.Builder> result = PersonalAccessTokenSummaryListCopier
                    .copyToBuilder(this.personalAccessTokenSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersonalAccessTokenSummaries(
                Collection<PersonalAccessTokenSummary.BuilderImpl> personalAccessTokenSummaries) {
            this.personalAccessTokenSummaries = PersonalAccessTokenSummaryListCopier
                    .copyFromBuilder(personalAccessTokenSummaries);
        }

        @Override
        public final Builder personalAccessTokenSummaries(Collection<PersonalAccessTokenSummary> personalAccessTokenSummaries) {
            this.personalAccessTokenSummaries = PersonalAccessTokenSummaryListCopier.copy(personalAccessTokenSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalAccessTokenSummaries(PersonalAccessTokenSummary... personalAccessTokenSummaries) {
            personalAccessTokenSummaries(Arrays.asList(personalAccessTokenSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalAccessTokenSummaries(
                Consumer<PersonalAccessTokenSummary.Builder>... personalAccessTokenSummaries) {
            personalAccessTokenSummaries(Stream.of(personalAccessTokenSummaries)
                    .map(c -> PersonalAccessTokenSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPersonalAccessTokensResponse build() {
            return new ListPersonalAccessTokensResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
