/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a mailbox export job, including the user or resource ID associated with the mailbox and the S3 bucket
 * that the mailbox contents are exported to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MailboxExportJob implements SdkPojo, Serializable,
        ToCopyableBuilder<MailboxExportJob.Builder, MailboxExportJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(MailboxExportJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(MailboxExportJob::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(MailboxExportJob::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(MailboxExportJob::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Path")
            .getter(getter(MailboxExportJob::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<Integer> ESTIMATED_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EstimatedProgress").getter(getter(MailboxExportJob::estimatedProgress))
            .setter(setter(Builder::estimatedProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedProgress").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(MailboxExportJob::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(MailboxExportJob::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(MailboxExportJob::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, ENTITY_ID_FIELD,
            DESCRIPTION_FIELD, S3_BUCKET_NAME_FIELD, S3_PATH_FIELD, ESTIMATED_PROGRESS_FIELD, STATE_FIELD, START_TIME_FIELD,
            END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String entityId;

    private final String description;

    private final String s3BucketName;

    private final String s3Path;

    private final Integer estimatedProgress;

    private final String state;

    private final Instant startTime;

    private final Instant endTime;

    private MailboxExportJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.entityId = builder.entityId;
        this.description = builder.description;
        this.s3BucketName = builder.s3BucketName;
        this.s3Path = builder.s3Path;
        this.estimatedProgress = builder.estimatedProgress;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The identifier of the mailbox export job.
     * </p>
     * 
     * @return The identifier of the mailbox export job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The identifier of the user or resource associated with the mailbox.
     * </p>
     * 
     * @return The identifier of the user or resource associated with the mailbox.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The mailbox export job description.
     * </p>
     * 
     * @return The mailbox export job description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The path to the S3 bucket and file that the mailbox export job exports to.
     * </p>
     * 
     * @return The path to the S3 bucket and file that the mailbox export job exports to.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The estimated progress of the mailbox export job, in percentage points.
     * </p>
     * 
     * @return The estimated progress of the mailbox export job, in percentage points.
     */
    public final Integer estimatedProgress() {
        return estimatedProgress;
    }

    /**
     * <p>
     * The state of the mailbox export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MailboxExportJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the mailbox export job.
     * @see MailboxExportJobState
     */
    public final MailboxExportJobState state() {
        return MailboxExportJobState.fromValue(state);
    }

    /**
     * <p>
     * The state of the mailbox export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MailboxExportJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the mailbox export job.
     * @see MailboxExportJobState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The mailbox export job start timestamp.
     * </p>
     * 
     * @return The mailbox export job start timestamp.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The mailbox export job end timestamp.
     * </p>
     * 
     * @return The mailbox export job end timestamp.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedProgress());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailboxExportJob)) {
            return false;
        }
        MailboxExportJob other = (MailboxExportJob) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(description(), other.description()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3Path(), other.s3Path()) && Objects.equals(estimatedProgress(), other.estimatedProgress())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MailboxExportJob").add("JobId", jobId()).add("EntityId", entityId())
                .add("Description", description()).add("S3BucketName", s3BucketName()).add("S3Path", s3Path())
                .add("EstimatedProgress", estimatedProgress()).add("State", stateAsString()).add("StartTime", startTime())
                .add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "EstimatedProgress":
            return Optional.ofNullable(clazz.cast(estimatedProgress()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("EstimatedProgress", ESTIMATED_PROGRESS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MailboxExportJob, T> g) {
        return obj -> g.apply((MailboxExportJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MailboxExportJob> {
        /**
         * <p>
         * The identifier of the mailbox export job.
         * </p>
         * 
         * @param jobId
         *        The identifier of the mailbox export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The identifier of the user or resource associated with the mailbox.
         * </p>
         * 
         * @param entityId
         *        The identifier of the user or resource associated with the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The mailbox export job description.
         * </p>
         * 
         * @param description
         *        The mailbox export job description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The path to the S3 bucket and file that the mailbox export job exports to.
         * </p>
         * 
         * @param s3Path
         *        The path to the S3 bucket and file that the mailbox export job exports to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * The estimated progress of the mailbox export job, in percentage points.
         * </p>
         * 
         * @param estimatedProgress
         *        The estimated progress of the mailbox export job, in percentage points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedProgress(Integer estimatedProgress);

        /**
         * <p>
         * The state of the mailbox export job.
         * </p>
         * 
         * @param state
         *        The state of the mailbox export job.
         * @see MailboxExportJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailboxExportJobState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the mailbox export job.
         * </p>
         * 
         * @param state
         *        The state of the mailbox export job.
         * @see MailboxExportJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailboxExportJobState
         */
        Builder state(MailboxExportJobState state);

        /**
         * <p>
         * The mailbox export job start timestamp.
         * </p>
         * 
         * @param startTime
         *        The mailbox export job start timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The mailbox export job end timestamp.
         * </p>
         * 
         * @param endTime
         *        The mailbox export job end timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String entityId;

        private String description;

        private String s3BucketName;

        private String s3Path;

        private Integer estimatedProgress;

        private String state;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MailboxExportJob model) {
            jobId(model.jobId);
            entityId(model.entityId);
            description(model.description);
            s3BucketName(model.s3BucketName);
            s3Path(model.s3Path);
            estimatedProgress(model.estimatedProgress);
            state(model.state);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final Integer getEstimatedProgress() {
            return estimatedProgress;
        }

        public final void setEstimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
        }

        @Override
        public final Builder estimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MailboxExportJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public MailboxExportJob build() {
            return new MailboxExportJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
