/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssociationState {
    PENDING_INSTALL("PENDING_INSTALL"),
    PENDING_INSTALL_DEPLOYMENT("PENDING_INSTALL_DEPLOYMENT"),
    PENDING_UNINSTALL("PENDING_UNINSTALL"),
    PENDING_UNINSTALL_DEPLOYMENT("PENDING_UNINSTALL_DEPLOYMENT"),
    INSTALLING("INSTALLING"),
    UNINSTALLING("UNINSTALLING"),
    ERROR("ERROR"),
    COMPLETED("COMPLETED"),
    REMOVED("REMOVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssociationState> VALUE_MAP;
    private final String value;

    private AssociationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationState> knownValues() {
        EnumSet<AssociationState> knownValues = EnumSet.allOf(AssociationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssociationState.class, AssociationState::toString);
    }
}

