/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse;

public class DescribeApplicationAssociationsIterable
implements SdkIterable<DescribeApplicationAssociationsResponse> {
    private final WorkSpacesClient client;
    private final DescribeApplicationAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeApplicationAssociationsIterable(WorkSpacesClient client, DescribeApplicationAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeApplicationAssociationsResponseFetcher();
    }

    public Iterator<DescribeApplicationAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeApplicationAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeApplicationAssociationsResponse> {
        private DescribeApplicationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeApplicationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeApplicationAssociationsResponse nextPage(DescribeApplicationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeApplicationAssociationsIterable.this.client.describeApplicationAssociations(DescribeApplicationAssociationsIterable.this.firstRequest);
            }
            return DescribeApplicationAssociationsIterable.this.client.describeApplicationAssociations((DescribeApplicationAssociationsRequest)((Object)DescribeApplicationAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

