/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.AccountLink;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksResponse;

public class ListAccountLinksIterable
implements SdkIterable<ListAccountLinksResponse> {
    private final WorkSpacesClient client;
    private final ListAccountLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountLinksIterable(WorkSpacesClient client, ListAccountLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountLinksResponseFetcher();
    }

    public Iterator<ListAccountLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountLink> accountLinks() {
        Function<ListAccountLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountLinks() != null) {
                return response.accountLinks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountLinksResponseFetcher
    implements SyncPageFetcher<ListAccountLinksResponse> {
        private ListAccountLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountLinksResponse nextPage(ListAccountLinksResponse previousPage) {
            if (previousPage == null) {
                return ListAccountLinksIterable.this.client.listAccountLinks(ListAccountLinksIterable.this.firstRequest);
            }
            return ListAccountLinksIterable.this.client.listAccountLinks((ListAccountLinksRequest)((Object)ListAccountLinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

