/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.SamplingStrategy;
import software.amazon.awssdk.services.xray.model.TimeRangeType;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTraceSummariesRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, GetTraceSummariesRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::startTime)).setter(GetTraceSummariesRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::endTime)).setter(GetTraceSummariesRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> TIME_RANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeRangeType").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::timeRangeTypeAsString)).setter(GetTraceSummariesRequest.setter(Builder::timeRangeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeType").build()}).build();
    private static final SdkField<Boolean> SAMPLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Sampling").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::sampling)).setter(GetTraceSummariesRequest.setter(Builder::sampling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sampling").build()}).build();
    private static final SdkField<SamplingStrategy> SAMPLING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SamplingStrategy").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::samplingStrategy)).setter(GetTraceSummariesRequest.setter(Builder::samplingStrategy)).constructor(SamplingStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingStrategy").build()}).build();
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterExpression").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::filterExpression)).setter(GetTraceSummariesRequest.setter(Builder::filterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTraceSummariesRequest.getter(GetTraceSummariesRequest::nextToken)).setter(GetTraceSummariesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, TIME_RANGE_TYPE_FIELD, SAMPLING_FIELD, SAMPLING_STRATEGY_FIELD, FILTER_EXPRESSION_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTraceSummariesRequest.memberNameToFieldInitializer();
    private final Instant startTime;
    private final Instant endTime;
    private final String timeRangeType;
    private final Boolean sampling;
    private final SamplingStrategy samplingStrategy;
    private final String filterExpression;
    private final String nextToken;

    private GetTraceSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timeRangeType = builder.timeRangeType;
        this.sampling = builder.sampling;
        this.samplingStrategy = builder.samplingStrategy;
        this.filterExpression = builder.filterExpression;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final TimeRangeType timeRangeType() {
        return TimeRangeType.fromValue(this.timeRangeType);
    }

    public final String timeRangeTypeAsString() {
        return this.timeRangeType;
    }

    public final Boolean sampling() {
        return this.sampling;
    }

    public final SamplingStrategy samplingStrategy() {
        return this.samplingStrategy;
    }

    public final String filterExpression() {
        return this.filterExpression;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampling());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesRequest)) {
            return false;
        }
        GetTraceSummariesRequest other = (GetTraceSummariesRequest)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.timeRangeTypeAsString(), other.timeRangeTypeAsString()) && Objects.equals(this.sampling(), other.sampling()) && Objects.equals(this.samplingStrategy(), other.samplingStrategy()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTraceSummariesRequest").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("TimeRangeType", (Object)this.timeRangeTypeAsString()).add("Sampling", (Object)this.sampling()).add("SamplingStrategy", (Object)this.samplingStrategy()).add("FilterExpression", (Object)this.filterExpression()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "TimeRangeType": {
                return Optional.ofNullable(clazz.cast(this.timeRangeTypeAsString()));
            }
            case "Sampling": {
                return Optional.ofNullable(clazz.cast(this.sampling()));
            }
            case "SamplingStrategy": {
                return Optional.ofNullable(clazz.cast(this.samplingStrategy()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("TimeRangeType", TIME_RANGE_TYPE_FIELD);
        map.put("Sampling", SAMPLING_FIELD);
        map.put("SamplingStrategy", SAMPLING_STRATEGY_FIELD);
        map.put("FilterExpression", FILTER_EXPRESSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTraceSummariesRequest, T> g) {
        return obj -> g.apply((GetTraceSummariesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private String timeRangeType;
        private Boolean sampling;
        private SamplingStrategy samplingStrategy;
        private String filterExpression;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceSummariesRequest model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.timeRangeType(model.timeRangeType);
            this.sampling(model.sampling);
            this.samplingStrategy(model.samplingStrategy);
            this.filterExpression(model.filterExpression);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getTimeRangeType() {
            return this.timeRangeType;
        }

        public final void setTimeRangeType(String timeRangeType) {
            this.timeRangeType = timeRangeType;
        }

        @Override
        public final Builder timeRangeType(String timeRangeType) {
            this.timeRangeType = timeRangeType;
            return this;
        }

        @Override
        public final Builder timeRangeType(TimeRangeType timeRangeType) {
            this.timeRangeType(timeRangeType == null ? null : timeRangeType.toString());
            return this;
        }

        public final Boolean getSampling() {
            return this.sampling;
        }

        public final void setSampling(Boolean sampling) {
            this.sampling = sampling;
        }

        @Override
        public final Builder sampling(Boolean sampling) {
            this.sampling = sampling;
            return this;
        }

        public final SamplingStrategy.Builder getSamplingStrategy() {
            return this.samplingStrategy != null ? this.samplingStrategy.toBuilder() : null;
        }

        public final void setSamplingStrategy(SamplingStrategy.BuilderImpl samplingStrategy) {
            this.samplingStrategy = samplingStrategy != null ? samplingStrategy.build() : null;
        }

        @Override
        public final Builder samplingStrategy(SamplingStrategy samplingStrategy) {
            this.samplingStrategy = samplingStrategy;
            return this;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTraceSummariesRequest build() {
            return new GetTraceSummariesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTraceSummariesRequest> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder timeRangeType(String var1);

        public Builder timeRangeType(TimeRangeType var1);

        public Builder sampling(Boolean var1);

        public Builder samplingStrategy(SamplingStrategy var1);

        default public Builder samplingStrategy(Consumer<SamplingStrategy.Builder> samplingStrategy) {
            return this.samplingStrategy((SamplingStrategy)((SamplingStrategy.Builder)SamplingStrategy.builder().applyMutation(samplingStrategy)).build());
        }

        public Builder filterExpression(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

