/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.GraphLink;
import software.amazon.awssdk.services.xray.model.LinksListCopier;
import software.amazon.awssdk.services.xray.model.Service;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrievedService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrievedService> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Service").getter(RetrievedService.getter(RetrievedService::service)).setter(RetrievedService.setter(Builder::service)).constructor(Service::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<List<GraphLink>> LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Links").getter(RetrievedService.getter(RetrievedService::links)).setter(RetrievedService.setter(Builder::links)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GraphLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, LINKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrievedService.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Service service;
    private final List<GraphLink> links;

    private RetrievedService(BuilderImpl builder) {
        this.service = builder.service;
        this.links = builder.links;
    }

    public final Service service() {
        return this.service;
    }

    public final boolean hasLinks() {
        return this.links != null && !(this.links instanceof SdkAutoConstructList);
    }

    public final List<GraphLink> links() {
        return this.links;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinks() ? this.links() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievedService)) {
            return false;
        }
        RetrievedService other = (RetrievedService)obj;
        return Objects.equals(this.service(), other.service()) && this.hasLinks() == other.hasLinks() && Objects.equals(this.links(), other.links());
    }

    public final String toString() {
        return ToString.builder((String)"RetrievedService").add("Service", (Object)this.service()).add("Links", this.hasLinks() ? this.links() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Links": {
                return Optional.ofNullable(clazz.cast(this.links()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Service", SERVICE_FIELD);
        map.put("Links", LINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievedService, T> g) {
        return obj -> g.apply((RetrievedService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Service service;
        private List<GraphLink> links = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievedService model) {
            this.service(model.service);
            this.links(model.links);
        }

        public final Service.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final List<GraphLink.Builder> getLinks() {
            List<GraphLink.Builder> result = LinksListCopier.copyToBuilder(this.links);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinks(Collection<GraphLink.BuilderImpl> links) {
            this.links = LinksListCopier.copyFromBuilder(links);
        }

        @Override
        public final Builder links(Collection<GraphLink> links) {
            this.links = LinksListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(GraphLink ... links) {
            this.links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<GraphLink.Builder> ... links) {
            this.links(Stream.of(links).map(c -> (GraphLink)((GraphLink.Builder)GraphLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RetrievedService build() {
            return new RetrievedService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrievedService> {
        public Builder service(Service var1);

        default public Builder service(Consumer<Service.Builder> service) {
            return this.service((Service)((Service.Builder)Service.builder().applyMutation(service)).build());
        }

        public Builder links(Collection<GraphLink> var1);

        public Builder links(GraphLink ... var1);

        public Builder links(Consumer<GraphLink.Builder> ... var1);
    }
}

