/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rst.pdfbox.layout.text.ControlCharacter;

public class ControlCharacters {
    public static ControlCharacterFactory BOLD_FACTORY = new StaticControlCharacterFactory(new BoldControlCharacter(), BoldControlCharacter.PATTERN);
    public static ControlCharacterFactory ITALIC_FACTORY = new StaticControlCharacterFactory(new ItalicControlCharacter(), ItalicControlCharacter.access$000());
    public static ControlCharacterFactory NEWLINE_FACTORY = new StaticControlCharacterFactory(new NewLineControlCharacter(), NewLineControlCharacter.access$100());
    public static ControlCharacterFactory COLOR_FACTORY = new ColorControlCharacterFactory();
    public static MetricsControlCharacterFactory METRICS_FACTORY = new MetricsControlCharacterFactory();

    public static String unescapeBackslash(String text) {
        return text.replaceAll(Pattern.quote("\\\\"), "\\\\");
    }

    private static class MetricsControlCharacterFactory
    implements ControlCharacterFactory {
        private static final Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*\\{(_|\\^)(:(-?\\d+(\\.\\d*)?)\\|(-?\\d+(\\.\\d*)?))?}");
        private static final String TO_ESCAPE = "{";

        private MetricsControlCharacterFactory() {
        }

        @Override
        public ControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            String baselineOffsetScale;
            boolean isSuperscript = "^".equals(matcher.group(2));
            String name = isSuperscript ? "SUPERSCRIPT" : "SUBSCRIPT";
            String string = baselineOffsetScale = isSuperscript ? "-0.4" : "0.15";
            if (matcher.groupCount() > 6 && matcher.group(6) != null) {
                baselineOffsetScale = matcher.group(6);
            }
            String fontScale = "0.61";
            if (matcher.groupCount() > 4 && matcher.group(4) != null) {
                fontScale = matcher.group(4);
            }
            return new MetricsControlCharacter(name, fontScale, baselineOffsetScale);
        }

        @Override
        public Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public String unescape(String text) {
            return text.replaceAll("\\\\" + Pattern.quote(TO_ESCAPE), TO_ESCAPE);
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return false;
        }
    }

    public static class MetricsControlCharacter
    extends ControlCharacter {
        private float fontScale;
        private float baselineOffsetScale;

        protected MetricsControlCharacter(String name, String fontScale, String baselineOffset) {
            super(name, "{");
            this.fontScale = MetricsControlCharacter.parse(fontScale, 1.0f);
            this.baselineOffsetScale = MetricsControlCharacter.parse(baselineOffset, 0.0f);
        }

        private static float parse(String text, float defaultValue) {
            if (text == null || text.trim().isEmpty()) {
                return defaultValue;
            }
            return Float.parseFloat(text);
        }

        public float getFontScale() {
            return this.fontScale;
        }

        public float getBaselineOffsetScale() {
            return this.baselineOffsetScale;
        }
    }

    private static class ColorControlCharacterFactory
    implements ControlCharacterFactory {
        private static final Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*\\{color:#(\\p{XDigit}{6})\\}");
        private static final String TO_ESCAPE = "{";

        private ColorControlCharacterFactory() {
        }

        @Override
        public ControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            return new ColorControlCharacter(matcher.group(2));
        }

        @Override
        public Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public String unescape(String text) {
            return text.replaceAll("\\\\" + Pattern.quote(TO_ESCAPE), TO_ESCAPE);
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return false;
        }
    }

    private static class StaticControlCharacterFactory
    implements ControlCharacterFactory {
        private ControlCharacter controlCharacter;
        private Pattern pattern;

        public StaticControlCharacterFactory(ControlCharacter controlCharacter, Pattern pattern) {
            this.controlCharacter = controlCharacter;
            this.pattern = pattern;
        }

        @Override
        public ControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            return this.controlCharacter;
        }

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public String unescape(String text) {
            return this.controlCharacter.unescape(text);
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return false;
        }
    }

    public static class ColorControlCharacter
    extends ControlCharacter {
        private Color color;

        protected ColorControlCharacter(String hex) {
            super("COLOR", "{");
            int r = Integer.parseUnsignedInt(hex.substring(0, 2), 16);
            int g = Integer.parseUnsignedInt(hex.substring(2, 4), 16);
            int b = Integer.parseUnsignedInt(hex.substring(4, 6), 16);
            this.color = new Color(r, g, b);
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static class NewLineControlCharacter
    extends ControlCharacter {
        private static Pattern PATTERN = Pattern.compile("(\r\n|\n)");

        protected NewLineControlCharacter() {
            super("NEWLINE", null);
        }

        static /* synthetic */ Pattern access$100() {
            return PATTERN;
        }
    }

    public static class ItalicControlCharacter
    extends ControlCharacter {
        private static Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*(?<!_)_(?!_)");

        protected ItalicControlCharacter() {
            super("ITALIC", "_");
        }

        static /* synthetic */ Pattern access$000() {
            return PATTERN;
        }
    }

    public static class BoldControlCharacter
    extends ControlCharacter {
        public static Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*\\*");

        protected BoldControlCharacter() {
            super("BOLD", "*");
        }
    }

    public static interface ControlCharacterFactory {
        public ControlCharacter createControlCharacter(String var1, Matcher var2, List<CharSequence> var3);

        public Pattern getPattern();

        public boolean patternMatchesBeginOfLine();

        public String unescape(String var1);
    }
}

