/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.serialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobException;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static String toJSONString(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String toJSONStringUnsafe(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new PowerJobException(e);
        }
    }

    public static byte[] toBytes(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parseObject(String json, Class<T> clz) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(json, clz);
    }

    public static <T> T parseObject(byte[] b, Class<T> clz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(b, clz);
    }

    public static <T> T parseObject(byte[] b, TypeReference<T> typeReference) throws IOException {
        return (T)OBJECT_MAPPER.readValue(b, typeReference);
    }

    public static <T> T parseObject(String json, TypeReference<T> typeReference) throws IOException {
        return (T)OBJECT_MAPPER.readValue(json, typeReference);
    }

    public static <T> T parseObjectIgnoreException(String json, Class<T> clz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clz);
        }
        catch (Exception e) {
            log.error("unable to parse json string to object,current string:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T parseObjectUnsafe(String json, Class<T> clz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clz);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
            throw new PowerJobException("impossible");
        }
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
    }
}

