/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.enums;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public enum TimeExpressionType {
    API(1),
    CRON(2),
    FIXED_RATE(3),
    FIXED_DELAY(4),
    WORKFLOW(5);

    private final int v;
    public static final List<Integer> FREQUENT_TYPES;
    public static final List<Integer> INSPECT_TYPES;

    public static TimeExpressionType of(int v) {
        for (TimeExpressionType type : TimeExpressionType.values()) {
            if (type.v != v) continue;
            return type;
        }
        throw new IllegalArgumentException("unknown TimeExpressionType of " + v);
    }

    public int getV() {
        return this.v;
    }

    private TimeExpressionType(int v) {
        this.v = v;
    }

    public String toString() {
        return "TimeExpressionType." + this.name() + "(v=" + this.getV() + ")";
    }

    static {
        FREQUENT_TYPES = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{TimeExpressionType.FIXED_RATE.v, TimeExpressionType.FIXED_DELAY.v}));
        INSPECT_TYPES = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{TimeExpressionType.CRON.v}));
    }
}

