/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.Set;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.parsing.FromNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.GroupByNode;
import oracle.toplink.essentials.internal.parsing.HavingNode;
import oracle.toplink.essentials.internal.parsing.ModifyNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.OrderByNode;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.QueryNode;
import oracle.toplink.essentials.internal.parsing.SelectGenerationContext;
import oracle.toplink.essentials.internal.parsing.SelectNode;
import oracle.toplink.essentials.internal.parsing.SetNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.internal.parsing.TypeHelperImpl;
import oracle.toplink.essentials.internal.parsing.VariableNode;
import oracle.toplink.essentials.internal.parsing.WhereNode;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteAllQuery;
import oracle.toplink.essentials.queryframework.ModifyAllQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.UpdateAllQuery;

public class ParseTree {
    private ParseTreeContext context;
    private QueryNode queryNode;
    private FromNode fromNode;
    private SetNode setNode;
    private WhereNode whereNode;
    private OrderByNode orderByNode = null;
    private GroupByNode groupByNode = null;
    private HavingNode havingNode = null;
    private ClassLoader classLoader = null;
    private short distinctState = 0;
    private boolean validated = false;
    private Set unusedVariables = null;

    public DatabaseQuery createDatabaseQuery() {
        return this.queryNode == null ? null : this.queryNode.createDatabaseQuery(this.context);
    }

    public void adjustReferenceClassForQuery(DatabaseQuery theQuery, GenerationContext generationContext) {
        Class referenceClass = this.getReferenceClass(theQuery, generationContext);
        if (referenceClass != null && referenceClass != theQuery.getReferenceClass()) {
            if (theQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)theQuery).setReferenceClass(referenceClass);
                generationContext.setBaseQueryClass(referenceClass);
                ((ObjectLevelReadQuery)theQuery).changeDescriptor(generationContext.getSession());
            } else if (theQuery.isUpdateAllQuery()) {
                ((UpdateAllQuery)theQuery).setReferenceClass(referenceClass);
            } else if (theQuery.isDeleteAllQuery()) {
                ((DeleteAllQuery)theQuery).setReferenceClass(referenceClass);
            }
        }
    }

    public void initBaseExpression(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        String variable = this.getFromNode().getFirstVariable();
        ParseTreeContext context = generationContext.getParseTreeContext();
        if (context.isRangeVariable(variable)) {
            Class referenceClass = theQuery.getReferenceClass();
            ExpressionBuilder builder = new ExpressionBuilder(referenceClass);
            theQuery.setExpressionBuilder(builder);
            generationContext.setBaseExpression(variable, builder);
        } else {
            Node path = context.pathForVariable(variable);
            Class baseClass = this.getBaseExpressionClass(path, generationContext);
            theQuery.setExpressionBuilder(new ExpressionBuilder(baseClass));
            theQuery.setReferenceClass(baseClass);
            theQuery.changeDescriptor(generationContext.getSession());
            generationContext.setBaseQueryClass(baseClass);
            generationContext.setBaseExpression(variable, path.generateExpression(generationContext));
        }
    }

    public void initBaseExpression(ModifyAllQuery theQuery, GenerationContext generationContext) {
        ModifyNode queryNode = (ModifyNode)this.getQueryNode();
        String variable = queryNode.getAbstractSchemaIdentifier();
        if (variable == null) {
            variable = queryNode.getAbstractSchemaName();
        }
        ParseTreeContext context = generationContext.getParseTreeContext();
        Class referenceClass = theQuery.getReferenceClass();
        ExpressionBuilder builder = new ExpressionBuilder(referenceClass);
        theQuery.setExpressionBuilder(builder);
        generationContext.setBaseExpression(variable, builder);
    }

    private Class getBaseExpressionClass(Node node, GenerationContext generationContext) {
        ParseTreeContext context = generationContext.getParseTreeContext();
        Class clazz = null;
        if (node == null) {
            clazz = null;
        } else if (node.isDotNode()) {
            clazz = this.getBaseExpressionClass(node.getLeft(), generationContext);
        } else if (node.isVariableNode()) {
            String variable = ((VariableNode)node).getVariableName();
            if (!context.isRangeVariable(variable)) {
                Node path = context.pathForVariable(variable);
                clazz = this.getBaseExpressionClass(path, generationContext);
            } else {
                String schema = context.schemaForVariable(variable);
                if (schema != null) {
                    clazz = context.classForSchemaName(schema, generationContext);
                }
            }
        }
        return clazz;
    }

    protected void validate(AbstractSession session, ClassLoader classLoader) {
        this.validate(new TypeHelperImpl(session, classLoader));
    }

    public void validate(TypeHelper typeHelper) {
        ParseTreeContext context = this.getContext();
        context.setTypeHelper(typeHelper);
        this.validate(context);
    }

    public void validate(ParseTreeContext context) {
        if (this.validated) {
            return;
        }
        this.validated = true;
        context.enterScope();
        if (this.fromNode != null) {
            this.fromNode.validate(context);
        }
        this.queryNode.validate(context);
        this.qualifyAttributeAccess(context);
        if (this.setNode != null) {
            this.setNode.validate(context);
        }
        if (this.whereNode != null) {
            this.whereNode.validate(context);
        }
        if (this.hasOrderBy()) {
            this.orderByNode.validate(context, (SelectNode)this.queryNode);
        }
        if (this.hasGroupBy()) {
            this.groupByNode.validate(context, (SelectNode)this.queryNode);
        }
        if (this.hasHaving()) {
            this.havingNode.validate(context, this.groupByNode);
        }
        this.unusedVariables = context.getUnusedVariables();
        context.leaveScope();
    }

    protected void qualifyAttributeAccess(ParseTreeContext context) {
        if ((this.queryNode.isUpdateNode() || this.queryNode.isDeleteNode()) && ((ModifyNode)this.queryNode).getAbstractSchemaIdentifier() == null) {
            if (this.setNode != null) {
                this.setNode.qualifyAttributeAccess(context);
            }
            if (this.whereNode != null) {
                this.whereNode.qualifyAttributeAccess(context);
            }
        }
    }

    public void addOrderingToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (this.hasOrderBy()) {
            this.getOrderByNode().addOrderingToQuery(theQuery, generationContext);
        }
    }

    public void addGroupingToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (this.hasGroupBy()) {
            this.getGroupByNode().addGroupingToQuery(theQuery, generationContext);
        }
    }

    public void addHavingToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (this.hasHaving()) {
            this.getHavingNode().addHavingToQuery(theQuery, generationContext);
        }
    }

    public void addNonFetchJoinAttributes(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        ParseTreeContext context = generationContext.getParseTreeContext();
        for (String variable : this.unusedVariables) {
            Expression expr = null;
            if (!context.isRangeVariable(variable)) {
                Node path = context.pathForVariable(variable);
                expr = path.generateExpression(generationContext);
                theQuery.addNonFetchJoinedAttribute(expr);
                continue;
            }
            throw EJBQLException.notYetImplemented(context.getQueryInfo(), "Variable [" + variable + "] is defined in a range variable declaration, but not used in the rest of the query.");
        }
    }

    public void addUpdatesToQuery(UpdateAllQuery theQuery, GenerationContext generationContext) {
        if (this.getSetNode() != null) {
            this.getSetNode().addUpdatesToQuery(theQuery, generationContext);
        }
    }

    public void addParametersToQuery(DatabaseQuery query) {
        if (this.context.hasParameters()) {
            for (String param : this.context.getParameterNames()) {
                Class<Object> type = (Class<Object>)this.context.getParameterType(param);
                if (type == null) {
                    type = Object.class;
                }
                query.addArgument(param, type);
            }
        }
    }

    public void applyQueryNodeToQuery(DatabaseQuery theQuery, GenerationContext generationContext) {
        this.getQueryNode().applyToQuery(theQuery, generationContext);
    }

    public GenerationContext buildContext(DatabaseQuery query, AbstractSession sessionForContext) {
        if (query.isObjectLevelReadQuery()) {
            return this.buildContextForReadQuery(sessionForContext);
        }
        if (query.isUpdateAllQuery() || query.isDeleteAllQuery()) {
            return new GenerationContext(this.getContext(), sessionForContext, this);
        }
        return null;
    }

    public GenerationContext buildContextForReadQuery(AbstractSession sessionForContext) {
        return new SelectGenerationContext(this.getContext(), sessionForContext, this);
    }

    public Expression generateExpression(DatabaseQuery readQuery, GenerationContext generationContext) {
        Expression selectExpression = this.getQueryNode().generateExpression(generationContext);
        if (this.getWhereNode() == null) {
            return selectExpression;
        }
        Expression whereExpression = this.getWhereNode().generateExpression(generationContext);
        selectExpression = this.getQueryNode().generateExpression(generationContext);
        if (selectExpression != null) {
            whereExpression = selectExpression.and(whereExpression);
        }
        return whereExpression;
    }

    public ParseTreeContext getContext() {
        return this.context;
    }

    public FromNode getFromNode() {
        return this.fromNode;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return ConversionManager.getDefaultManager().getLoader();
        }
        return this.classLoader;
    }

    public OrderByNode getOrderByNode() {
        return this.orderByNode;
    }

    public GroupByNode getGroupByNode() {
        return this.groupByNode;
    }

    public HavingNode getHavingNode() {
        return this.havingNode;
    }

    public Class getReferenceClass(DatabaseQuery query, GenerationContext generationContext) {
        if (this.getQueryNode() == null) {
            return null;
        }
        return this.getQueryNode().getReferenceClass(generationContext);
    }

    public QueryNode getQueryNode() {
        return this.queryNode;
    }

    public SetNode getSetNode() {
        return this.setNode;
    }

    public WhereNode getWhereNode() {
        return this.whereNode;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public boolean hasOrderBy() {
        return this.getOrderByNode() != null;
    }

    public boolean hasGroupBy() {
        return this.getGroupByNode() != null;
    }

    public boolean hasHaving() {
        return this.getHavingNode() != null;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public void setContext(ParseTreeContext newContext) {
        this.context = newContext;
    }

    public void setFromNode(FromNode fromNode) {
        this.fromNode = fromNode;
    }

    public void setOrderByNode(OrderByNode newOrderByNode) {
        this.orderByNode = newOrderByNode;
    }

    public void setGroupByNode(GroupByNode newGroupByNode) {
        this.groupByNode = newGroupByNode;
    }

    public void setHavingNode(HavingNode newHavingNode) {
        this.havingNode = newHavingNode;
    }

    public void setSelectionCriteriaForQuery(DatabaseQuery theQuery, GenerationContext generationContext) {
        theQuery.setSelectionCriteria(this.generateExpression(theQuery, generationContext));
    }

    public void setQueryNode(QueryNode newQueryNode) {
        this.queryNode = newQueryNode;
    }

    public void setSetNode(SetNode newSetNode) {
        this.setNode = newSetNode;
    }

    public void setWhereNode(WhereNode newWhereNode) {
        this.whereNode = newWhereNode;
    }

    public void setDistinctState(short newDistinctState) {
        this.distinctState = newDistinctState;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getContext().toString());
        return ToStringLocalization.buildMessage("context", null) + " " + buffer.toString();
    }

    public void verifySelect(DatabaseQuery theQuery, GenerationContext generationContext) {
        if (theQuery.isObjectLevelReadQuery()) {
            ((SelectNode)this.getQueryNode()).verifySelectedAlias(generationContext);
        }
    }

    public boolean usesDistinct() {
        return this.distinctState == 1;
    }
}

