/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries;

import java.util.List;
import java.util.ArrayList;

import javax.persistence.ColumnResult;
import javax.persistence.EntityResult;
import javax.persistence.SqlResultSetMapping;

/**
 * Object to hold onto an sql result mapping metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataSQLResultSetMapping {
    protected List<String> m_columnResults;
    protected List<MetadataEntityResult> m_entityResults;
    protected SqlResultSetMapping m_sqlResultSetMapping;
    
    /**
     * INTERNAL:
     */
    protected MetadataSQLResultSetMapping() {}

    /**
     * INTERNAL:
     */
    public MetadataSQLResultSetMapping(SqlResultSetMapping sqlResultSetMapping) {
        m_sqlResultSetMapping = sqlResultSetMapping;
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataEntityResult> getEntityResults() {
        if (m_entityResults == null) {
            m_entityResults = new ArrayList<MetadataEntityResult>();
            
            for (EntityResult entityResult : m_sqlResultSetMapping.entities()) {
                m_entityResults.add(new MetadataEntityResult(entityResult));
            } 
        }
        
        return m_entityResults;
    }
    
    /**
     * INTERNAL:
     */
    public List<String> getColumnResults() {
        if (m_columnResults == null) {
            m_columnResults = new ArrayList<String>();
            
            for (ColumnResult columnResult : m_sqlResultSetMapping.columns()) {
                m_columnResults.add(columnResult.name());
            } 
        }
        
        return m_columnResults;
    }
    
    /**
     * INTERNAL:
     */
    public String getName() {
        return m_sqlResultSetMapping.name();
    }
}
