/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries;

import java.util.ArrayList;
import java.util.List;

/**
 * Object to hold onto a named query metadata's hints.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public abstract class MetadataQuery  {
    private String m_name;
    private String m_query;
    private Object m_location; // Where it was found, i.e. java class or xml document.
    private List<MetadataQueryHint> m_hints;
    
    /**
     * INTERNAL:
     */
    protected MetadataQuery() {
        m_hints = new ArrayList<MetadataQueryHint>();
    }
    
    /**
     * INTERNAL:
     */
    protected void addHint(MetadataQueryHint hint) {
        m_hints.add(hint);
    }
    
    /**
     * INTERNAL:
     */
    public String getEJBQLString() {
        return m_query;
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataQueryHint> getHints() {
        return m_hints; 
    }
    
    /**
     * INTERNAL:
     */
    public abstract String getIgnoreLogMessageContext();
    
    /**
     * INTERNAL:
     */
    public Object getLocation() {
        return m_location;
    }
    
    /**
     * INTERNAL:
     */
    public String getName() {
        return m_name;
    }
    
    /**
     * INTERNAL: (Overriden in XMLNamedNativeQuery and XMLNamedQuery)
     */
    public boolean loadedFromAnnotations() {
        return true;
    }
    
    /**
     * INTERNAL: (Overriden in XMLNamedNativeQuery and XMLNamedQuery)
     */
    public boolean loadedFromXML() {
        return false;
    }  
    
    /**
     * INTERNAL:
     */
    protected void setEJBQLString(String query) {
        m_query = query;
    }
    
    /**
     * INTERNAL:
     */
    protected void setLocation(Object location) {
        m_location = location;
    }
    
    /**
     * INTERNAL:
     */
    protected void setName(String name) {
        m_name = name;
    }
}
