/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables;

import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;

/**
 * Object to hold onto table metadata in a TopLink database table.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataJoinTable extends MetadataTable {
    private JoinColumn[] m_joinColumns;
    private JoinColumn[] m_inverseJoinColumns;
    protected MetadataJoinColumns m_jColumns;
    protected MetadataJoinColumns m_inverseJColumns;
    
    /**
     * INTERNAL:
     */
    public MetadataJoinTable(MetadataLogger logger) {
        super(logger);
        
        m_joinColumns = new JoinColumn[] {};
        m_inverseJoinColumns = new JoinColumn[] {};
    }
    
    /**
     * INTERNAL:
     */
    public MetadataJoinTable(JoinTable joinTable, MetadataLogger logger) {
        this(logger);
        
        if (joinTable != null) {
            m_name = joinTable.name();
            m_schema = joinTable.schema();
            m_catalog = joinTable.catalog();
            m_joinColumns = joinTable.joinColumns();
            m_inverseJoinColumns = joinTable.inverseJoinColumns();
            
            processName();
            processUniqueConstraints(joinTable.uniqueConstraints());
        }
    }
    
    /**
     * INTERNAL:
     */
    public String getCatalogContext() {
        return m_logger.JOIN_TABLE_CATALOG;
    }
    
    /**
     * INTERNAL:
     */
    public MetadataJoinColumns getInverseJoinColumns() {
        if (m_inverseJColumns == null) {
            m_inverseJColumns = processInverseJoinColumns();
        }
        
        return m_inverseJColumns;
    }
    
    /**
     * INTERNAL:
     */
    public MetadataJoinColumns getJoinColumns() {
        if (m_jColumns == null) {
            m_jColumns = processJoinColumns();
        }
        
        return m_jColumns;
    }
    
    /**
     * INTERNAL:
     */
    public String getNameContext() {
        return m_logger.JOIN_TABLE_NAME;
    }
    
    /**
     * INTERNAL:
     */
    public String getSchemaContext() {
        return m_logger.JOIN_TABLE_SCHEMA;
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return false;
    }
    
    /**
     * INTERNAL: (Overridden in XMLJoinTable)
     */
    protected MetadataJoinColumns processInverseJoinColumns() {
        return new MetadataJoinColumns(m_inverseJoinColumns);
    }
    
    /**
     * INTERNAL: (Overridden in XMLJoinTable)
     */
    protected MetadataJoinColumns processJoinColumns() {
        return new MetadataJoinColumns(m_joinColumns);
    }
}
