/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.EJBQueryImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.base.QueryHintsHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataPersistenceUnit;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.RelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataNamedNativeQuery;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataNamedQuery;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataQueryHint;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataTableGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.EJBQLPlaceHolderQuery;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.sequencing.QuerySequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.Project;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProject {
    protected PersistenceUnitInfo m_PUInfo;
    protected Collection<String> m_entityNames = new HashSet<String>();
    protected Map<URL, Document> m_mappingFiles = new HashMap<URL, Document>();
    protected AbstractSession m_session;
    protected boolean m_enableLazyForOneToOne;
    protected MetadataPersistenceUnit m_persistenceUnit;
    protected HashMap<String, Node> m_mappedSuperclassNodes;
    protected HashMap<String, XMLHelper> m_mappedSuperclasses;
    protected HashMap<String, Node> m_embeddableNodes;
    protected HashMap<String, XMLHelper> m_embeddables;
    protected HashMap<String, MetadataDescriptor> m_allDescriptors;
    protected HashSet<MetadataDescriptor> m_descriptorsWithRelationships;
    protected HashMap<String, MetadataNamedQuery> m_namedQueries;
    protected HashMap<String, MetadataNamedNativeQuery> m_namedNativeQueries;
    protected HashMap<Class, MetadataGeneratedValue> m_generatedValues;
    protected HashMap<String, MetadataTableGenerator> m_tableGenerators;
    protected HashMap<String, MetadataSequenceGenerator> m_sequenceGenerators;
    protected HashMap<XMLHelper, NodeList> m_defaultListeners;

    public MetadataProject(PersistenceUnitInfo puInfo, AbstractSession session, boolean enableLazyForOneToOne) {
        this.m_PUInfo = puInfo;
        this.m_session = session;
        this.m_enableLazyForOneToOne = enableLazyForOneToOne;
        this.m_defaultListeners = new HashMap();
        this.m_namedQueries = new HashMap();
        this.m_namedNativeQueries = new HashMap();
        this.m_mappedSuperclassNodes = new HashMap();
        this.m_mappedSuperclasses = new HashMap();
        this.m_embeddableNodes = new HashMap();
        this.m_embeddables = new HashMap();
        this.m_allDescriptors = new HashMap();
        this.m_descriptorsWithRelationships = new HashSet();
        this.m_generatedValues = new HashMap();
        this.m_tableGenerators = new HashMap();
        this.m_sequenceGenerators = new HashMap();
    }

    public void addDefaultListeners(NodeList nodes, XMLHelper helper) {
        this.m_defaultListeners.put(helper, nodes);
    }

    public void addDescriptor(MetadataDescriptor descriptor) {
        Project project;
        ClassDescriptor descriptorOnProject;
        if (this.m_persistenceUnit != null) {
            descriptor.setAccess(this.m_persistenceUnit.getAccess());
            descriptor.setSchema(this.m_persistenceUnit.getSchema());
            descriptor.setCatalog(this.m_persistenceUnit.getCatalog());
            descriptor.setIsCascadePersist(this.m_persistenceUnit.isCascadePersist());
            descriptor.setIgnoreAnnotations(this.m_persistenceUnit.isMetadataComplete());
        }
        if ((descriptorOnProject = MetadataHelper.findDescriptor(project = this.getSession().getProject(), descriptor.getJavaClass())) == null) {
            project.addDescriptor(descriptor.getClassDescriptor());
        } else {
            descriptor.setDescriptor(descriptorOnProject);
        }
        this.m_allDescriptors.put(descriptor.getJavaClassName(), descriptor);
    }

    public void addGeneratedValue(MetadataGeneratedValue metadatageneratedvalue, Class entityClass) {
        this.m_generatedValues.put(entityClass, metadatageneratedvalue);
    }

    public void addMappedSuperclass(Class mappedSuperclass, Node node, XMLHelper helper) {
        this.m_mappedSuperclasses.put(mappedSuperclass.getName(), helper);
        this.m_mappedSuperclassNodes.put(mappedSuperclass.getName(), node);
    }

    public void addEmbeddable(Class embeddable, Node node, XMLHelper helper) {
        this.m_embeddables.put(embeddable.getName(), helper);
        this.m_embeddableNodes.put(embeddable.getName(), node);
    }

    public void addNamedNativeQuery(MetadataNamedNativeQuery namedNativeQuery) {
        this.m_namedNativeQueries.put(namedNativeQuery.getName(), namedNativeQuery);
    }

    public void addNamedQuery(MetadataNamedQuery namedQuery) {
        this.m_namedQueries.put(namedQuery.getName(), namedQuery);
    }

    public void addRelationshipDescriptor(MetadataDescriptor descriptor) {
        this.m_descriptorsWithRelationships.add(descriptor);
    }

    public void addSequenceGenerator(MetadataSequenceGenerator sequenceGenerator) {
        this.m_sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
    }

    public void addTableGenerator(MetadataTableGenerator tableGenerator) {
        this.m_tableGenerators.put(tableGenerator.getName(), tableGenerator);
    }

    public void cleanup() {
        this.m_mappingFiles.clear();
    }

    public boolean containsDescriptor(Class cls) {
        return this.m_allDescriptors.containsKey(cls.getName());
    }

    public boolean enableLazyForOneToOne() {
        return this.m_enableLazyForOneToOne;
    }

    public HashMap<XMLHelper, NodeList> getDefaultListeners() {
        return this.m_defaultListeners;
    }

    public MetadataDescriptor getDescriptor(Class cls) {
        if (cls == null) {
            return null;
        }
        MetadataDescriptor descriptor = this.m_allDescriptors.get(cls.getName());
        if (descriptor == null) {
            throw ValidationException.classNotListedInPersistenceUnit(cls.getName());
        }
        return descriptor;
    }

    public Collection<MetadataDescriptor> getDescriptors() {
        return this.m_allDescriptors.values();
    }

    public XMLHelper getMappedSuperclassHelper(Class cls) {
        return this.m_mappedSuperclasses.get(cls.getName());
    }

    public Node getMappedSuperclassNode(Class cls) {
        return this.m_mappedSuperclassNodes.get(cls.getName());
    }

    public Map<URL, Document> getMappingFiles() {
        return Collections.unmodifiableMap(this.m_mappingFiles);
    }

    public XMLHelper getEmbeddableHelper(Class cls) {
        return this.m_embeddables.get(cls.getName());
    }

    public Node getEmbeddableNode(Class cls) {
        return this.m_embeddableNodes.get(cls.getName());
    }

    public Collection<String> getEntityNames() {
        return Collections.unmodifiableCollection(this.m_entityNames);
    }

    public MetadataNamedNativeQuery getNamedNativeQuery(String name) {
        return this.m_namedNativeQueries.get(name);
    }

    public MetadataNamedQuery getNamedQuery(String name) {
        return this.m_namedQueries.get(name);
    }

    public MetadataPersistenceUnit getPersistenceUnit() {
        return this.m_persistenceUnit;
    }

    public PersistenceUnitInfo getPUInfo() {
        return this.m_PUInfo;
    }

    public HashSet<MetadataDescriptor> getRelationshipDescriptors() {
        return this.m_descriptorsWithRelationships;
    }

    public MetadataSequenceGenerator getSequenceGenerator(String name) {
        return this.m_sequenceGenerators.get(name);
    }

    public Collection<MetadataSequenceGenerator> getSequenceGenerators() {
        return this.m_sequenceGenerators.values();
    }

    public AbstractSession getSession() {
        return this.m_session;
    }

    public MetadataTableGenerator getTableGenerator(String name) {
        return this.m_tableGenerators.get(name);
    }

    public Collection<MetadataTableGenerator> getTableGenerators() {
        return this.m_tableGenerators.values();
    }

    public boolean hasConflictingSequenceGenerator(MetadataSequenceGenerator sequenceGenerator) {
        if (this.hasSequenceGenerator(sequenceGenerator.getName())) {
            return !this.getSequenceGenerator(sequenceGenerator.getName()).equals(sequenceGenerator);
        }
        return false;
    }

    public boolean hasConflictingTableGenerator(MetadataTableGenerator tableGenerator) {
        if (this.hasTableGenerator(tableGenerator.getName())) {
            return !this.getTableGenerator(tableGenerator.getName()).equals(tableGenerator);
        }
        return false;
    }

    public boolean hasDescriptors() {
        return !this.m_allDescriptors.isEmpty();
    }

    public boolean hasMappedSuperclass(Class cls) {
        return this.m_mappedSuperclasses.containsKey(cls.getName());
    }

    public boolean hasEmbeddable(Class cls) {
        return this.m_embeddables.containsKey(cls.getName());
    }

    public boolean hasNamedNativeQuery(String name) {
        return this.m_namedNativeQueries.containsKey(name);
    }

    public boolean hasNamedQuery(String name) {
        return this.m_namedQueries.containsKey(name);
    }

    public boolean hasPersistenceUnit() {
        return this.m_persistenceUnit != null;
    }

    public boolean hasSequenceGenerator(String name) {
        return this.getSequenceGenerator(name) != null;
    }

    public boolean hasTableGenerator(String name) {
        return this.getTableGenerator(name) != null;
    }

    public void process() {
        this.processSequencing();
        this.processRelationshipDescriptors();
    }

    public void processNamedNativeQueries(ClassLoader loader) {
        for (MetadataNamedNativeQuery query : this.m_namedNativeQueries.values()) {
            HashMap<String, String> hints = this.processQueryHints(query.getHints(), query.getName());
            Class resultClass = query.getResultClass();
            if (resultClass != Void.TYPE) {
                resultClass = MetadataHelper.getClassForName(resultClass.getName(), loader);
                this.m_session.addQuery(query.getName(), EJBQueryImpl.buildSQLDatabaseQuery(resultClass, query.getEJBQLString(), hints));
                continue;
            }
            String resultSetMapping = query.getResultSetMapping();
            if (!resultSetMapping.equals("")) {
                this.m_session.addQuery(query.getName(), EJBQueryImpl.buildSQLDatabaseQuery(resultSetMapping, query.getEJBQLString(), hints));
                continue;
            }
            this.m_session.addQuery(query.getName(), EJBQueryImpl.buildSQLDatabaseQuery(query.getEJBQLString(), hints));
        }
    }

    public void processNamedQueries(MetadataValidator validator) {
        for (MetadataNamedQuery query : this.m_namedQueries.values()) {
            try {
                HashMap<String, String> hints = this.processQueryHints(query.getHints(), query.getName());
                this.m_session.addEjbqlPlaceHolderQuery(new EJBQLPlaceHolderQuery(query.getName(), query.getEJBQLString(), hints));
            }
            catch (Exception exception) {
                validator.throwErrorProcessingNamedQueryAnnotation(query.getClass(), query.getName(), exception);
            }
        }
    }

    protected HashMap<String, String> processQueryHints(List<MetadataQueryHint> hints, String queryName) {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (MetadataQueryHint hint : hints) {
            QueryHintsHandler.verify(hint.getName(), hint.getValue(), queryName, this.m_session);
            hm.put(hint.getName(), hint.getValue());
        }
        return hm;
    }

    protected void processRelationshipDescriptors() {
        for (MetadataDescriptor descriptor : this.getRelationshipDescriptors()) {
            for (RelationshipAccessor accessor : descriptor.getRelationshipAccessors()) {
                accessor.processRelationship();
            }
        }
    }

    protected void processSequencing() {
        if (!this.m_generatedValues.isEmpty()) {
            QuerySequence sequence;
            String seqName;
            DatabaseLogin login = this.m_session.getProject().getLogin();
            for (MetadataGeneratedValue generatedValue : this.m_generatedValues.values()) {
                MetadataTableGenerator tableGenerator;
                String type = generatedValue.getStrategy();
                String generatorName = generatedValue.getGenerator();
                if (type.equals("TABLE")) {
                    MetadataSequenceGenerator sequenceGenerator = this.m_sequenceGenerators.get(generatorName);
                    if (sequenceGenerator == null) continue;
                }
                if ((type.equals("SEQUENCE") || type.equals("IDENTITY")) && (tableGenerator = this.m_tableGenerators.get(generatorName)) == null) continue;
            }
            QuerySequence defaultAutoSequence = null;
            QuerySequence defaultTableSequence = new TableSequence("SEQ_GEN_TABLE");
            NativeSequence defaultNativeSequence = new NativeSequence("SEQ_GEN_SEQUENCE");
            Hashtable<String, QuerySequence> sequences = new Hashtable<String, QuerySequence>();
            for (MetadataSequenceGenerator sequenceGenerator : this.m_sequenceGenerators.values()) {
                String sequenceGeneratorName = sequenceGenerator.getName();
                seqName = sequenceGenerator.getSequenceName().equals("") ? sequenceGeneratorName : sequenceGenerator.getSequenceName();
                sequence = new NativeSequence(seqName, sequenceGenerator.getAllocationSize());
                sequences.put(sequenceGeneratorName, sequence);
                if (sequenceGeneratorName.equals("SEQ_GEN")) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!sequenceGeneratorName.equals("SEQ_GEN_SEQUENCE")) continue;
                defaultNativeSequence = sequence;
            }
            for (MetadataTableGenerator tableGenerator : this.m_tableGenerators.values()) {
                String tableGeneratorName = tableGenerator.getName();
                seqName = tableGenerator.getPkColumnValue().equals("") ? tableGeneratorName : tableGenerator.getPkColumnValue();
                sequence = new TableSequence(seqName, tableGenerator.getAllocationSize(), tableGenerator.getInitialValue());
                sequences.put(tableGeneratorName, sequence);
                ((TableSequence)sequence).setTable(new DatabaseTable(MetadataHelper.getFullyQualifiedTableName(tableGenerator.getTable(), ((TableSequence)sequence).getTableName(), tableGenerator.getCatalog(), tableGenerator.getSchema())));
                for (String[] uniqueConstraint : tableGenerator.getUniqueConstraints()) {
                    ((TableSequence)sequence).getTable().addUniqueConstraints(uniqueConstraint);
                }
                if (!tableGenerator.getPkColumnName().equals("")) {
                    ((TableSequence)sequence).setNameFieldName(tableGenerator.getPkColumnName());
                }
                if (!tableGenerator.getValueColumnName().equals("")) {
                    ((TableSequence)sequence).setCounterFieldName(tableGenerator.getValueColumnName());
                }
                if (tableGeneratorName.equals("SEQ_GEN")) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!tableGeneratorName.equals("SEQ_GEN_TABLE")) continue;
                defaultTableSequence = sequence;
            }
            for (Class entityClass : this.m_generatedValues.keySet()) {
                MetadataDescriptor descriptor = this.m_allDescriptors.get(entityClass.getName());
                MetadataGeneratedValue generatedValue = this.m_generatedValues.get(entityClass);
                String generatorName = generatedValue.getGenerator();
                Sequence sequence2 = null;
                if (!generatorName.equals("")) {
                    sequence2 = (Sequence)sequences.get(generatorName);
                }
                if (sequence2 == null) {
                    if (generatedValue.getStrategy().equals("TABLE")) {
                        if (generatorName.equals("")) {
                            sequence2 = defaultTableSequence;
                        } else {
                            sequence2 = (Sequence)defaultTableSequence.clone();
                            sequence2.setName(generatorName);
                        }
                    } else if (generatedValue.getStrategy().equals("SEQUENCE") || generatedValue.getStrategy().equals("IDENTITY")) {
                        if (generatorName.equals("")) {
                            sequence2 = defaultNativeSequence;
                        } else {
                            sequence2 = (Sequence)defaultNativeSequence.clone();
                            sequence2.setName(generatorName);
                        }
                    }
                }
                if (sequence2 != null) {
                    descriptor.setSequenceNumberName(sequence2.getName());
                    login.addSequence(sequence2);
                    continue;
                }
                if (!generatedValue.getStrategy().equals("AUTO")) continue;
                if (defaultAutoSequence != null) {
                    descriptor.setSequenceNumberName(defaultAutoSequence.getName());
                    login.setDefaultSequence(defaultAutoSequence);
                    continue;
                }
                descriptor.setSequenceNumberName("SEQ_GEN");
            }
        }
    }

    public void setEntityNames(Collection<String> entityNames) {
        this.m_entityNames.clear();
        this.m_entityNames.addAll(entityNames);
    }

    public void setMappingFiles(Map<URL, Document> mappingFiles) {
        this.m_mappingFiles.clear();
        this.m_mappingFiles.putAll(mappingFiles);
    }

    public void setPersistenceUnit(MetadataPersistenceUnit persistenceUnit) {
        this.m_persistenceUnit = persistenceUnit;
    }
}

