/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;
import oracle.toplink.essentials.ejb.cmp3.persistence.ArchiveFactoryImpl;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.exceptions.PersistenceUnitLoadingException;
import oracle.toplink.essentials.exceptions.XMLParseException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.PersistenceContentHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLExceptionHandler;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitProcessor {
    public static List<SEPersistenceUnitInfo> getPersistenceUnits(Archive archive, ClassLoader loader) {
        return PersistenceUnitProcessor.processPersistenceArchive(archive, loader);
    }

    public static List<SEPersistenceUnitInfo> processPersistenceArchive(Archive archive, ClassLoader loader) {
        URL puRootURL = archive.getRootURL();
        try {
            InputStream pxmlStream = archive.getEntry("META-INF/persistence.xml");
            return PersistenceUnitProcessor.processPersistenceXML(puRootURL, pxmlStream, loader);
        }
        catch (IOException e) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(puRootURL.toString(), e);
        }
    }

    private static List<SEPersistenceUnitInfo> processPersistenceXML(URL baseURL, InputStream input, ClassLoader loader) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        XMLReader xmlReader = null;
        SAXParser sp = null;
        XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
        try {
            sp = spf.newSAXParser();
            sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (ParserConfigurationException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        try {
            xmlReader = sp.getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingXMLReader(baseURL, exc);
        }
        URL schemaURL = loader.getResource("persistence_1_0.xsd");
        if (schemaURL != null) {
            try {
                sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL.toString());
            }
            catch (SAXException exc) {
                throw XMLParseException.exceptionSettingSchemaSource(baseURL, schemaURL, exc);
            }
        }
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        xmlReader.setContentHandler(myContentHandler);
        InputSource inputSource = new InputSource(input);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, exc);
        }
        catch (SAXException exc) {
            // empty catch block
        }
        XMLException xmlError = xmlErrorHandler.getXMLException();
        if (xmlError != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, xmlError);
        }
        for (SEPersistenceUnitInfo info : myContentHandler.getPersistenceUnits()) {
            info.setPersistenceUnitRootUrl(baseURL);
        }
        return myContentHandler.getPersistenceUnits();
    }

    public static String buildClassNameFromEntryString(String classEntryString) {
        String classNameForLoader = classEntryString;
        if (classEntryString.endsWith(".class")) {
            classNameForLoader = classNameForLoader.substring(0, classNameForLoader.length() - 6);
            classNameForLoader = classNameForLoader.replace("/", ".");
        }
        return classNameForLoader;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo, ClassLoader loader) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(persistenceUnitInfo.getManagedClassNames());
        Iterator<URL> i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(i.next()));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl()));
        }
        set.addAll(PersistenceUnitProcessor.buildPersistentClassSetFromXMLDocuments(persistenceUnitInfo, loader));
        return set;
    }

    private static Set<String> buildPersistentClassSetFromXMLDocuments(PersistenceUnitInfo info, ClassLoader loader) {
        Set<String> classes = null;
        MetadataProcessor processor = new MetadataProcessor(info, null, loader, false);
        processor.readMappingFiles(false);
        classes = processor.buildEntityClassSetFromXMLDocuments();
        return classes;
    }

    public static Set<Archive> findPersistenceArchives() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(threadLoader);
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader loader) {
        HashSet<Archive> pars = new HashSet<Archive>();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL pxmlURL = resources.nextElement();
                URL puRootURL = PersistenceUnitProcessor.computePURootURL(pxmlURL);
                Archive archive = new ArchiveFactoryImpl().createArchive(puRootURL);
                pars.add(archive);
            }
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, exc);
        }
        catch (URISyntaxException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, exc);
        }
        return pars;
    }

    private static URL computePURootURL(URL pxmlURL) throws IOException {
        String protocol = pxmlURL.getProtocol();
        if ("file".equals(protocol)) {
            assert (new File(pxmlURL.getFile()).isFile());
            return new URL(pxmlURL, "..");
        }
        if ("jar".equals(protocol)) {
            JarURLConnection conn = (JarURLConnection)JarURLConnection.class.cast(pxmlURL.openConnection());
            assert (conn.getJarEntry().getName().equals("META-INF/persistence.xml"));
            return conn.getJarFileURL();
        }
        return new URL(pxmlURL, "../");
    }

    public static Set<String> getClassNamesFromURL(URL url) {
        HashSet<String> classNames = new HashSet<String>();
        Archive archive = null;
        try {
            archive = new ArchiveFactoryImpl().createArchive(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("url = [" + url + "]", e);
        }
        catch (IOException e) {
            throw new RuntimeException("url = [" + url + "]", e);
        }
        Iterator<String> entries = archive.getEntries();
        while (entries.hasNext()) {
            String entry = entries.next();
            if (!entry.endsWith(".class")) continue;
            classNames.add(PersistenceUnitProcessor.buildClassNameFromEntryString(entry));
        }
        return classNames;
    }

    public static Set<String> getEntityClassNamesFromURL(URL url, ClassLoader loader) {
        HashSet<String> entityClassNames = new HashSet<String>();
        for (String className : PersistenceUnitProcessor.getClassNamesFromURL(url)) {
            if (!PersistenceUnitProcessor.isEntity(className, loader, false)) continue;
            entityClassNames.add(className);
        }
        return entityClassNames;
    }

    public static boolean isEntity(String className, ClassLoader loader, boolean throwExceptionIfNotFound) {
        Class<?> candidateClass = null;
        try {
            candidateClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            if (throwExceptionIfNotFound) {
                throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations(className, exc);
            }
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", exc.getClass().getName(), exc.getLocalizedMessage(), className);
            return false;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", exception.getClass().getName(), exception.getLocalizedMessage(), className);
            return false;
        }
        return PersistenceUnitProcessor.isEntity(candidateClass);
    }

    public static boolean isEntity(Class candidateClass) {
        return candidateClass.isAnnotationPresent(Entity.class);
    }

    public static void processORMetadata(MetadataProcessor processor, ClassLoader privateClassLoader, AbstractSession session, boolean throwExceptionOnFail) {
        processor.readMappingFiles(throwExceptionOnFail);
        processor.buildEntityList();
        processor.processPersistenceUnitMetadata();
        processor.processMappingFiles();
        processor.processAnnotations();
    }

    public static Collection<Class> buildEntityList(MetadataProcessor processor, ClassLoader loader) {
        ArrayList<Class> entityList = new ArrayList<Class>();
        for (String className : processor.getProject().getEntityNames()) {
            try {
                Class<?> entityClass = loader.loadClass(className);
                entityList.add(entityClass);
            }
            catch (ClassNotFoundException exc) {
                AbstractSessionLog.getLog().log(4, "exception_loading_entity_class", className, exc);
            }
        }
        return entityList;
    }
}

