/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.EntityManagerImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.base.QueryHintsHandler;
import oracle.toplink.essentials.internal.helper.BasicTypeHelperImpl;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.parsing.EJBQLParseTree;
import oracle.toplink.essentials.internal.parsing.ejbql.EJBQLCallQueryMechanism;
import oracle.toplink.essentials.internal.parsing.ejbql.EJBQLParser;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.DataModifyQuery;
import oracle.toplink.essentials.queryframework.DataReadQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;
import oracle.toplink.essentials.queryframework.ResultSetMappingQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.Session;

public abstract class EJBQueryImpl {
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Map parameters = new HashMap();
    protected int firstResultIndex = -1;
    protected int maxResults = -1;
    protected int maxRows = -1;

    protected abstract void throwNoResultException(String var1);

    protected abstract void throwNonUniqueResultException(String var1);

    protected EJBQueryImpl(EntityManagerImpl entityManager) {
        this.entityManager = entityManager;
    }

    public EJBQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        this(entityManager);
        this.databaseQuery = query;
    }

    public EJBQueryImpl(String ejbql, EntityManagerImpl entityManager) {
        this(ejbql, entityManager, false);
    }

    public EJBQueryImpl(String queryDescription, EntityManagerImpl entityManager, boolean isNamedQuery) {
        this(entityManager);
        if (isNamedQuery) {
            this.queryName = queryDescription;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(queryDescription, this.getActiveSession());
        }
    }

    protected void setAsSQLModifyQuery() {
        if (this.getDatabaseQuery().isDataReadQuery()) {
            DataModifyQuery query = new DataModifyQuery();
            query.setSQLString(this.databaseQuery.getSQLString());
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.setFlushOnExecute(this.databaseQuery.getFlushOnExecute());
            this.databaseQuery = query;
        }
    }

    protected void setAsSQLReadQuery() {
        if (this.getDatabaseQuery().isDataModifyQuery()) {
            DataReadQuery query = new DataReadQuery();
            query.setUseAbstractRecord(false);
            query.setSQLString(this.databaseQuery.getSQLString());
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.setFlushOnExecute(this.databaseQuery.getFlushOnExecute());
            this.databaseQuery = query;
        }
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(ejbql, null, session);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Session session, HashMap hints) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, null, session, hints, null);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Session session, HashMap hints, ClassLoader classLoader) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, null, session, hints, classLoader);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Boolean flushOnExecute, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, flushOnExecute, session, null, null);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String ejbql, Boolean flushOnExecute, Session session, ClassLoader classLoader) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, ejbql, flushOnExecute, session, null, classLoader);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String queryName, String ejbql, Boolean flushOnExecute, Session session, HashMap hints, ClassLoader classLoader) {
        DatabaseQuery databaseQuery = null;
        EJBQLParseTree parseTree = EJBQLParser.buildParseTree(queryName, ejbql);
        parseTree.setClassLoader(classLoader);
        databaseQuery = parseTree.createDatabaseQuery();
        databaseQuery.setEJBQLString(ejbql);
        parseTree.populateQuery(databaseQuery, (AbstractSession)session);
        parseTree.addParametersToQuery(databaseQuery);
        ((EJBQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getEJBQLCall().setIsParsed(true);
        databaseQuery.setFlushOnExecute(flushOnExecute);
        EJBQueryImpl.applyHints(hints, databaseQuery);
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString) {
        return EJBQueryImpl.buildSQLDatabaseQuery(resultClass, sqlString, null);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString, HashMap hints) {
        ReadAllQuery query = new ReadAllQuery(resultClass);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        EJBQueryImpl.applyHints(hints, query);
        return query;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlResultSetMappingName, sqlString, null);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, HashMap hints) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        EJBQueryImpl.applyHints(hints, query);
        return query;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, Boolean flushOnExecute) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlString, new HashMap());
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, HashMap hints) {
        DataReadQuery query = new DataReadQuery();
        query.setUseAbstractRecord(false);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        EJBQueryImpl.applyHints(hints, query);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeReadQuery() {
        Vector parameterValues = this.processParameters();
        boolean shouldResetConformResultsInUnitOfWork = false;
        if (this.isFlushModeAUTO()) {
            this.performPreQueryFlush();
            if (this.getDatabaseQuery().isObjectLevelReadQuery() && ((ObjectLevelReadQuery)this.getDatabaseQuery()).shouldConformResultsInUnitOfWork()) {
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).setCacheUsage(-1);
                shouldResetConformResultsInUnitOfWork = true;
            }
        }
        try {
            if (this.getDatabaseQuery().isUserDefined() && this.entityManager.checkForTransaction(false) != null && !((UnitOfWorkImpl)this.getActiveSession()).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)this.getActiveSession()).beginEarlyTransaction();
            }
            Object object = this.getActiveSession().executeQuery(this.getDatabaseQuery(), parameterValues);
            return object;
        }
        finally {
            if (shouldResetConformResultsInUnitOfWork) {
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).conformResultsInUnitOfWork();
            }
        }
    }

    public int executeUpdate() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLModifyQuery();
            if (!(this.getDatabaseQuery() instanceof ModifyQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_execute_update"));
            }
            this.entityManager.checkForTransaction(true);
            Vector parameterValues = this.processParameters();
            if (this.isFlushModeAUTO()) {
                this.performPreQueryFlush();
            }
            Integer changedRows = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, parameterValues);
            return changedRows;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public DatabaseQuery getDatabaseQuery() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.getActiveSession().getQuery(this.queryName);
            if (this.databaseQuery != null) {
                if (!this.databaseQuery.isPrepared()) {
                    this.databaseQuery.prepareCall(this.getActiveSession(), new DatabaseRecord());
                }
                this.databaseQuery = (DatabaseQuery)this.databaseQuery.clone();
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unable_to_find_named_query", new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    public Collection getResultCollection() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface(containerClass, ClassConstants.Collection_Class)) {
                throw QueryException.invalidContainerClass(containerClass, ClassConstants.Collection_Class);
            }
        } else {
            if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
            }
        }
        Object result = this.executeReadQuery();
        return (Collection)result;
    }

    public List getResultList() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQuery() instanceof ReadAllQuery) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.List_Class);
                }
            } else {
                if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                    throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
                }
                if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_list"));
                }
            }
            Object result = this.executeReadQuery();
            return (List)result;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getSingleResult() {
        boolean rollbackOnException = true;
        try {
            Object result;
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQuery() instanceof ReadAllQuery) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.List_Class);
                }
            } else if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_single_result"));
            }
            if ((result = this.executeReadQuery()) instanceof List) {
                List results = (List)result;
                if (results.isEmpty()) {
                    rollbackOnException = false;
                    this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
                } else if (results.size() > 1) {
                    rollbackOnException = false;
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                }
                return results.get(0);
            }
            if (result == null) {
                rollbackOnException = false;
                this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
            }
            return result;
        }
        catch (RuntimeException e) {
            if (rollbackOnException) {
                this.setRollbackOnly();
            }
            throw e;
        }
    }

    protected Vector processParameters() {
        Vector arguments;
        if (this.databaseQuery == null) {
            this.getDatabaseQuery();
        }
        if ((arguments = this.databaseQuery.getArguments()).isEmpty()) {
            Iterator params = this.parameters.keySet().iterator();
            while (params.hasNext()) {
                this.databaseQuery.addArgument((String)params.next());
            }
            arguments = this.databaseQuery.getArguments();
        }
        Vector parameterValues = new Vector(arguments.size());
        for (String name : arguments) {
            if (this.parameters.containsKey(name)) {
                parameterValues.add(this.parameters.get(name));
                continue;
            }
            throw new IllegalStateException(ExceptionLocalization.buildMessage("missing_parameter_value", new Object[]{name}));
        }
        return parameterValues;
    }

    public void setDatabaseQuery(DatabaseQuery query) {
        this.databaseQuery = query;
    }

    protected void setFirstResultInternal(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_start_position", null));
        }
        this.firstResultIndex = startPosition;
    }

    protected static void applyHints(HashMap hints, DatabaseQuery query) {
        QueryHintsHandler.apply(hints, query);
    }

    protected boolean isFlushModeAUTO() {
        if (this.getDatabaseQuery().getFlushOnExecute() != null) {
            return this.getDatabaseQuery().getFlushOnExecute();
        }
        return this.entityManager.isFlushModeAUTO();
    }

    protected void setHintInternal(String hintName, Object value) {
        QueryHintsHandler.apply(hintName, value, this.getDatabaseQuery());
    }

    public void setMaxResultsInternal(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_max_result", null));
        }
        this.maxResults = maxResult;
    }

    protected void propagateResultProperties() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            if (this.maxResults >= 0) {
                this.maxRows = this.maxResults + (this.firstResultIndex >= 0 ? this.firstResultIndex : 0);
                readQuery.setMaxRows(this.maxRows);
                this.maxResults = -1;
            }
            if (this.firstResultIndex > -1) {
                readQuery.setFirstResult(this.firstResultIndex);
                this.firstResultIndex = -1;
            }
        }
    }

    protected void setParameterInternal(String name, Object value) {
        int index = this.getDatabaseQuery().getArguments().indexOf(name);
        if (this.getDatabaseQuery().getEJBQLString() != null) {
            if (index == -1) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-name", new Object[]{name, this.getDatabaseQuery().getEJBQLString()}));
            }
            if (!this.isValidActualParameter(value, this.getDatabaseQuery().getArgumentTypes().get(index))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{name, value.getClass(), this.getDatabaseQuery().getArgumentTypes().get(index), this.getDatabaseQuery().getEJBQLString()}));
            }
        }
        this.parameters.put(name, value);
    }

    protected void setParameterInternal(int position, Object value) {
        String pos = new Integer(position).toString();
        int index = this.getDatabaseQuery().getArguments().indexOf(pos);
        if (this.getDatabaseQuery().getEJBQLString() != null) {
            if (index == -1) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{position, this.getDatabaseQuery().getEJBQLString()}));
            }
            if (!this.isValidActualParameter(value, this.getDatabaseQuery().getArgumentTypes().get(index))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{position, value.getClass(), this.getDatabaseQuery().getArgumentTypes().get(index), this.getDatabaseQuery().getEJBQLString()}));
            }
        }
        this.parameters.put(pos, value);
    }

    protected boolean isValidActualParameter(Object value, Object parameterType) {
        if (value == null) {
            return true;
        }
        return BasicTypeHelperImpl.getInstance().isAssignableFrom(parameterType, value.getClass());
    }

    protected Session getActiveSession() {
        return this.entityManager.getActiveSession();
    }

    protected void performPreQueryFlush() {
        if (this.entityManager.shouldFlushBeforeQuery()) {
            this.entityManager.flush();
        }
    }

    protected void setRollbackOnly() {
        this.entityManager.setRollbackOnly();
    }
}

