/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.CMPPolicy;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.DescriptorEventManager;
import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.descriptors.FetchGroupManager;
import oracle.toplink.essentials.descriptors.InheritancePolicy;
import oracle.toplink.essentials.descriptors.TimestampLockingPolicy;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.descriptors.WrapperPolicy;
import oracle.toplink.essentials.descriptors.changetracking.DeferredChangeDetectionPolicy;
import oracle.toplink.essentials.descriptors.changetracking.ObjectChangePolicy;
import oracle.toplink.essentials.descriptors.copying.CloneCopyPolicy;
import oracle.toplink.essentials.descriptors.copying.CopyPolicy;
import oracle.toplink.essentials.descriptors.copying.InstantiationCopyPolicy;
import oracle.toplink.essentials.descriptors.invalidation.CacheInvalidationPolicy;
import oracle.toplink.essentials.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.databaseaccess.Platform;
import oracle.toplink.essentials.internal.descriptors.InstantiationPolicy;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.expressions.SQLStatement;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.MappingCompare;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.helper.TOPSort;
import oracle.toplink.essentials.internal.identitymaps.IdentityMap;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.security.PrivilegedMethodInvoker;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateMapping;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.Association;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.queryframework.FetchGroup;
import oracle.toplink.essentials.querykeys.DirectQueryKey;
import oracle.toplink.essentials.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
implements Cloneable,
Serializable {
    protected Class javaClass;
    protected String javaClassName;
    protected Vector<DatabaseTable> tables = NonSynchronizedVector.newInstance(3);
    protected transient DatabaseTable defaultTable;
    protected List<DatabaseField> primaryKeyFields;
    protected transient Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields;
    protected transient Vector<DatabaseTable> multipleTableInsertOrder;
    protected transient Map<DatabaseTable, DatabaseTable> multipleTableForeignKeys;
    protected transient Vector<DatabaseField> fields;
    protected transient Vector<DatabaseField> allFields;
    protected Vector<DatabaseMapping> mappings = NonSynchronizedVector.newInstance();
    protected List<DatabaseMapping> lockableMappings;
    protected Map<String, QueryKey> queryKeys;
    protected Class identityMapClass;
    protected int identityMapSize = 100;
    protected String sequenceNumberName;
    protected DatabaseField sequenceNumberField;
    protected transient String sessionName;
    protected boolean shouldAlwaysRefreshCache = false;
    protected boolean shouldOnlyRefreshCacheIfNewerVersion = false;
    protected boolean shouldDisableCacheHits = false;
    protected transient Vector constraintDependencies;
    protected transient String amendmentMethodName;
    protected transient Class amendmentClass;
    protected transient String amendmentClassName;
    protected String alias;
    protected boolean shouldBeReadOnly = false;
    protected boolean shouldAlwaysConformResultsInUnitOfWork = false;
    protected boolean isIsolated = false;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected DescriptorEventManager eventManager;
    protected DescriptorQueryManager queryManager;
    protected ObjectBuilder objectBuilder;
    protected CopyPolicy copyPolicy;
    protected InstantiationPolicy instantiationPolicy;
    protected InheritancePolicy inheritancePolicy;
    protected OptimisticLockingPolicy optimisticLockingPolicy;
    protected Vector cascadeLockingPolicies;
    protected WrapperPolicy wrapperPolicy;
    protected ObjectChangePolicy changePolicy;
    protected CMPPolicy cmpPolicy;
    protected FetchGroupManager fetchGroupManager;
    protected Map properties;
    protected static final int UNINITIALIZED = 0;
    protected static final int PREINITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int POST_INITIALIZED = 3;
    protected static final int ERROR = -1;
    protected static final int NORMAL = 0;
    protected static final int AGGREGATE = 2;
    protected static final int AGGREGATE_COLLECTION = 3;
    protected transient int initializationStage = 0;
    protected int descriptorType = 0;
    protected boolean shouldOrderMappings = true;
    protected CacheInvalidationPolicy cacheInvalidationPolicy = null;
    protected boolean shouldAcquireCascadedLocks = false;
    protected boolean hasSimplePrimaryKey = false;

    public ClassDescriptor() {
        this.primaryKeyFields = new ArrayList<DatabaseField>(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap<DatabaseTable, DatabaseTable>(5);
        this.queryKeys = new HashMap<String, QueryKey>(5);
        this.identityMapClass = IdentityMap.getDefaultIdentityMapClass();
        this.objectBuilder = new ObjectBuilder(this);
        this.setCopyPolicy(new InstantiationCopyPolicy());
        this.setInstantiationPolicy(new InstantiationPolicy());
        this.setEventManager(new DescriptorEventManager());
        this.setQueryManager(new DescriptorQueryManager());
        this.changePolicy = new DeferredChangeDetectionPolicy();
        this.cascadeLockingPolicies = NonSynchronizedVector.newInstance();
    }

    public void addAbstractQueryKey(String queryKeyName) {
        QueryKey queryKey = new QueryKey();
        queryKey.setName(queryKeyName);
        this.addQueryKey(queryKey);
    }

    public void addConstraintDependencies(Class dependencies) {
        this.getConstraintDependencies().addElement(dependencies);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setAttributeName(attributeName);
        mapping.setFieldName(fieldName);
        return this.addMapping(mapping);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        mapping.setFieldName(fieldName);
        return this.addMapping(mapping);
    }

    public void addDirectQueryKey(String queryKeyName, String fieldName) {
        DirectQueryKey queryKey = new DirectQueryKey();
        DatabaseField field = new DatabaseField(fieldName);
        queryKey.setName(queryKeyName);
        queryKey.setField(field);
        this.getQueryKeys().put(queryKeyName, queryKey);
    }

    public DatabaseMapping addMapping(DatabaseMapping mapping) {
        if (mapping.getDescriptor() == null) {
            mapping.setDescriptor(this);
        }
        this.getMappings().addElement(mapping);
        return mapping;
    }

    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isRelationalMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void addMultipleTableForeignKeyField(DatabaseField sourceField, DatabaseField targetField) throws DescriptorException {
        this.addMultipleTableForeignKeys(sourceField, targetField, true);
    }

    public void addMultipleTableForeignKeyFieldName(String sourceFieldName, String targetFieldName) throws DescriptorException {
        this.addMultipleTableForeignKeyField(new DatabaseField(sourceFieldName), new DatabaseField(targetFieldName));
    }

    protected void addMultipleTableForeignKeys(DatabaseField sourceField, DatabaseField targetField, boolean isForeignKey) throws DescriptorException {
        if (!sourceField.hasTableName() || !targetField.hasTableName()) {
            throw DescriptorException.multipleTablePrimaryKeyMustBeFullyQualified(this);
        }
        DatabaseTable sourceTable = sourceField.getTable();
        DatabaseTable targetTable = targetField.getTable();
        this.setAdditionalTablePrimaryKeyFields(targetTable, sourceField, targetField);
        if (isForeignKey) {
            this.getMultipleTableForeignKeys().put(sourceTable, targetTable);
        }
    }

    protected void addMultipleTableForeignKeys(String fieldNameInSourceTable, String fieldNameInTargetTable, boolean isForeignKey) throws DescriptorException {
        this.addMultipleTableForeignKeys(new DatabaseField(fieldNameInSourceTable), new DatabaseField(fieldNameInTargetTable), isForeignKey);
    }

    public void addMultipleTablePrimaryKeyField(DatabaseField sourceField, DatabaseField targetField) throws DescriptorException {
        this.addMultipleTableForeignKeys(sourceField, targetField, false);
    }

    public void addMultipleTablePrimaryKeyFieldName(String sourceFieldName, String targetFieldName) throws DescriptorException {
        this.addMultipleTablePrimaryKeyField(new DatabaseField(sourceFieldName), new DatabaseField(targetFieldName));
    }

    public void addPrimaryKeyFieldName(String fieldName) {
        this.getPrimaryKeyFields().add(new DatabaseField(fieldName));
    }

    public void addPrimaryKeyField(DatabaseField field) {
        this.getPrimaryKeyFields().add(field);
    }

    public void addQueryKey(QueryKey queryKey) {
        this.getQueryKeys().put(queryKey.getName(), queryKey);
    }

    public void addTable(DatabaseTable table) {
        this.getTables().addElement(table);
    }

    public void addTableName(String tableName) {
        this.addTable(new DatabaseTable(tableName));
    }

    public void adjustMultipleTableInsertOrder() {
        if (this.getMultipleTableInsertOrder() == null || this.getMultipleTableInsertOrder().isEmpty()) {
            this.setMultipleTableInsertOrder((Vector)this.getTables().clone());
            this.checkMultipleTableForeignKeys(false);
        } else {
            if (this.getMultipleTableInsertOrder().size() != this.getTables().size()) {
                throw DescriptorException.multipleTableInsertOrderMismatch(this);
            }
            this.checkMultipleTableForeignKeys(true);
        }
    }

    public void alwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(true);
    }

    public void alwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(true);
    }

    public void applyAmendmentMethod() {
        this.applyAmendmentMethod(null);
    }

    public void applyAmendmentMethod(DescriptorEvent event) {
        block11: {
            if (this.getAmendmentClass() == null || this.getAmendmentMethodName() == null) {
                return;
            }
            Method method = null;
            Class[] argTypes = new Class[]{ClassDescriptor.class};
            try {
                method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
            }
            catch (Exception ignore) {
                argTypes[0] = ClassDescriptor.class;
                try {
                    method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
                }
                catch (Exception exception) {
                    throw DescriptorException.invalidAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
                }
            }
            Object[] args = new Object[]{this};
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(method, null, args));
                        break block11;
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw (IllegalAccessException)throwableException;
                        }
                        throw (InvocationTargetException)throwableException;
                    }
                }
                PrivilegedAccessHelper.invokeMethod(method, null, args);
            }
            catch (Exception exception) {
                throw DescriptorException.errorOccuredInAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
            }
        }
    }

    public boolean arePrimaryKeyFields(Vector fields) {
        if (fields.size() != this.getPrimaryKeyFields().size()) {
            return false;
        }
        Enumeration enumFields = fields.elements();
        while (enumFields.hasMoreElements()) {
            DatabaseField field = (DatabaseField)enumFields.nextElement();
            if (this.getPrimaryKeyFields().contains(field)) continue;
            return false;
        }
        return true;
    }

    public DatabaseCall buildCallFromStatement(SQLStatement statement, AbstractSession session) {
        return statement.buildCall(session);
    }

    public Vector buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseField buildField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        DatabaseTable table = field.hasTableName() ? this.getTable(field.getTableName()) : (this.getDefaultTable() != null ? this.getDefaultTable() : this.getTable(this.getTableName()));
        field.setTable(table);
        return field;
    }

    public void buildField(DatabaseField field) {
        DatabaseTable table = field.hasTableName() ? this.getTable(field.getTableName()) : this.getDefaultTable();
        field.setTable(table);
    }

    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromForeignKeys(Vector foreignKeys, String referenceDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    protected void checkDatabase(AbstractSession session) {
        if (session.getIntegrityChecker().shouldCheckDatabase()) {
            Enumeration<DatabaseTable> enumTable = this.getTables().elements();
            while (enumTable.hasMoreElements()) {
                DatabaseTable table = enumTable.nextElement();
                if (session.getIntegrityChecker().checkTable(table, session)) {
                    Vector<Object> databaseFields = new Vector<Object>();
                    Vector result = session.getAccessor().getColumnInfo(null, null, table.getName(), null, session);
                    Enumeration resultEnum = result.elements();
                    while (resultEnum.hasMoreElements()) {
                        AbstractRecord row = (AbstractRecord)resultEnum.nextElement();
                        databaseFields.addElement(row.get("COLUMN_NAME"));
                    }
                    Enumeration<DatabaseField> row = this.getFields().elements();
                    while (row.hasMoreElements()) {
                        DatabaseField field = row.nextElement();
                        if (!field.getTable().equals(table) || databaseFields.contains(field.getName())) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.fieldIsNotPresentInDatabase(this, table.getName(), field.getName()));
                    }
                    continue;
                }
                session.getIntegrityChecker().handleError(DescriptorException.tableIsNotPresentInDatabase(this));
            }
        }
    }

    public void checkInheritanceTreeAggregateSettings(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.hasInheritance()) {
            return;
        }
        if (this.isChildDescriptor()) {
            Class parentClass = this.getInheritancePolicy().getParentClass();
            if (parentClass == this.getJavaClass()) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            session.getDescriptor(parentClass).checkInheritanceTreeAggregateSettings(session, mapping);
        } else {
            this.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    private void checkInheritanceTreeAggregateSettingsForChildren(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getJavaClass().getName(), mapping));
        }
        Enumeration stream = this.getInheritancePolicy().getChildDescriptors().elements();
        while (stream.hasMoreElements()) {
            ClassDescriptor childDescriptor = (ClassDescriptor)stream.nextElement();
            childDescriptor.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    protected void checkMultipleTableForeignKeys(boolean userSpecifiedOrder) {
        Map<DatabaseTable, DatabaseTable> foreignKeyTableRelationships = this.getMultipleTableForeignKeys();
        for (int i = 0; i < foreignKeyTableRelationships.size(); ++i) {
            for (Map.Entry<DatabaseTable, DatabaseTable> entry : foreignKeyTableRelationships.entrySet()) {
                DatabaseTable sourceTable = entry.getKey();
                DatabaseTable targetTable = entry.getValue();
                if (this.getMultipleTableInsertOrder().indexOf(sourceTable) == -1) {
                    throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, sourceTable);
                }
                if (this.getMultipleTableInsertOrder().indexOf(targetTable) == -1) {
                    throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
                }
                int sourceTableIndex = this.getTables().indexOf(sourceTable);
                int targetTableIndex = this.getTables().indexOf(targetTable);
                if (targetTableIndex >= sourceTableIndex) continue;
                if (userSpecifiedOrder) {
                    this.toggleAdditionalTablePrimaryKeyFields(targetTable, sourceTable);
                    continue;
                }
                int sti = this.getMultipleTableInsertOrder().indexOf(sourceTable);
                int tti = this.getMultipleTableInsertOrder().indexOf(targetTable);
                if (tti >= sti) continue;
                this.toggleAdditionalTablePrimaryKeyFields(targetTable, sourceTable);
                this.getMultipleTableInsertOrder().removeElementAt(tti);
                this.getMultipleTableInsertOrder().insertElementAt(targetTable, sti);
            }
        }
    }

    public Object clone() {
        ClassDescriptor clonedDescriptor = null;
        try {
            clonedDescriptor = (ClassDescriptor)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NonSynchronizedVector mappingsVector = NonSynchronizedVector.newInstance();
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappingsEnum.nextElement().clone();
            mapping.setDescriptor(clonedDescriptor);
            ((Vector)mappingsVector).addElement(mapping);
        }
        clonedDescriptor.setMappings(mappingsVector);
        HashMap<String, QueryKey> queryKeyVector = new HashMap<String, QueryKey>(this.getQueryKeys().size() + 2);
        Iterator<QueryKey> queryKeysEnum = this.getQueryKeys().values().iterator();
        while (queryKeysEnum.hasNext()) {
            QueryKey queryKey = (QueryKey)queryKeysEnum.next().clone();
            queryKey.setDescriptor(clonedDescriptor);
            queryKeyVector.put(queryKey.getName(), queryKey);
        }
        clonedDescriptor.setQueryKeys(queryKeyVector);
        ArrayList<DatabaseField> primaryKeyVector = new ArrayList<DatabaseField>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKey = (DatabaseField)primaryKeyFields.get(index).clone();
            primaryKeyVector.add(primaryKey);
        }
        clonedDescriptor.setPrimaryKeyFields(primaryKeyVector);
        clonedDescriptor.setFields(NonSynchronizedVector.newInstance());
        if (clonedDescriptor.hasInheritance()) {
            clonedDescriptor.setInheritancePolicy((InheritancePolicy)this.getInheritancePolicy().clone());
            clonedDescriptor.getInheritancePolicy().setDescriptor(clonedDescriptor);
        }
        clonedDescriptor.setObjectBuilder((ObjectBuilder)this.getObjectBuilder().clone());
        clonedDescriptor.getObjectBuilder().setDescriptor(clonedDescriptor);
        clonedDescriptor.setEventManager((DescriptorEventManager)this.getEventManager().clone());
        clonedDescriptor.getEventManager().setDescriptor(clonedDescriptor);
        clonedDescriptor.setQueryManager((DescriptorQueryManager)this.getQueryManager().clone());
        clonedDescriptor.getQueryManager().setDescriptor(clonedDescriptor);
        if (this.hasFetchGroupManager()) {
            clonedDescriptor.setFetchGroupManager((FetchGroupManager)this.getFetchGroupManager().clone());
        }
        clonedDescriptor.setIsIsolated(this.isIsolated());
        clonedDescriptor.setInstantiationPolicy((InstantiationPolicy)this.instantiationPolicy.clone());
        clonedDescriptor.setCopyPolicy((CopyPolicy)this.copyPolicy.clone());
        if (this.getOptimisticLockingPolicy() != null) {
            clonedDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getOptimisticLockingPolicy().clone());
        }
        return clonedDescriptor;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class amendmentClass;
        Class descriptorClass;
        block14: {
            descriptorClass = null;
            amendmentClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        descriptorClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getJavaClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exception.getException());
                    }
                } else {
                    descriptorClass = PrivilegedAccessHelper.getClassForName(this.getJavaClassName(), true, classLoader);
                }
                if (this.getAmendmentClassName() == null) break block14;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        amendmentClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getAmendmentClassName(), true, classLoader));
                        break block14;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exception.getException());
                    }
                }
                amendmentClass = PrivilegedAccessHelper.getClassForName(this.getAmendmentClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), exc);
            }
        }
        this.setJavaClass(descriptorClass);
        if (amendmentClass != null) {
            this.setAmendmentClass(amendmentClass);
        }
        Iterator<DatabaseMapping> mappings = this.getMappings().iterator();
        while (mappings.hasNext()) {
            mappings.next().convertClassNamesToClasses(classLoader);
        }
        if (this.inheritancePolicy != null) {
            this.inheritancePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.instantiationPolicy != null) {
            this.instantiationPolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.hasCMPPolicy()) {
            this.getCMPPolicy().convertClassNamesToClasses(classLoader);
        }
        this.queryManager.convertClassNamesToClasses(classLoader);
    }

    public void createCopyPolicy(String policyType) {
        if (policyType.equals("clone")) {
            this.useCloneCopyPolicy();
            return;
        }
        if (policyType.equals("constructor")) {
            this.useInstantiationCopyPolicy();
            return;
        }
    }

    public void createInstantiationPolicy(String policyType) {
        if (policyType.equals("static method")) {
            return;
        }
        if (policyType.equals("constructor")) {
            this.useDefaultConstructorInstantiationPolicy();
            return;
        }
        if (policyType.equals("factory")) {
            return;
        }
    }

    public void descriptorIsAggregate() {
        this.setDescriptorType(2);
    }

    public void descriptorIsAggregateCollection() {
        this.setDescriptorType(3);
    }

    public void descriptorIsNormal() {
        this.setDescriptorType(0);
    }

    public void disableCacheHits() {
        this.setShouldDisableCacheHits(true);
    }

    public void dontAlwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(false);
    }

    public void dontAlwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(false);
    }

    public void dontDisableCacheHits() {
        this.setShouldDisableCacheHits(false);
    }

    public void dontOnlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(false);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.getTables().isEmpty()) {
            if (this.isChildDescriptor()) {
                return this.getInheritancePolicy().getParentDescriptor().extractDefaultTable();
            }
            return null;
        }
        return this.getTables().firstElement();
    }

    public Map<DatabaseTable, Map<DatabaseField, DatabaseField>> getAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            this.additionalTablePrimaryKeyFields = new HashMap<DatabaseTable, Map<DatabaseField, DatabaseField>>(5);
        }
        return this.additionalTablePrimaryKeyFields;
    }

    public String getAlias() {
        if (this.alias == null && this.getJavaClassName() != null) {
            this.alias = Helper.getShortClassName(this.getJavaClassName());
        }
        return this.alias;
    }

    public Vector<DatabaseField> getAllFields() {
        return this.allFields;
    }

    public Class getAmendmentClass() {
        return this.amendmentClass;
    }

    public String getAmendmentClassName() {
        if (this.amendmentClassName == null && this.amendmentClass != null) {
            this.amendmentClassName = this.amendmentClass.getName();
        }
        return this.amendmentClassName;
    }

    public String getAmendmentMethodName() {
        return this.amendmentMethodName;
    }

    public ObjectChangePolicy getObjectChangePolicy() {
        if (this.changePolicy == null) {
            this.changePolicy = new DeferredChangeDetectionPolicy();
        }
        return this.changePolicy;
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        if (this.cacheInvalidationPolicy == null) {
            this.cacheInvalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        }
        return this.cacheInvalidationPolicy;
    }

    public Vector getCascadeLockingPolicies() {
        return this.cascadeLockingPolicies;
    }

    public Vector getConstraintDependencies() {
        return this.constraintDependencies;
    }

    public CopyPolicy getCopyPolicy() {
        return this.copyPolicy;
    }

    public DatabaseTable getDefaultTable() {
        return this.defaultTable;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public String getDescriptorTypeValue() {
        if (this.isAggregateCollectionDescriptor()) {
            return "Aggregate collection";
        }
        if (this.isAggregateDescriptor()) {
            return "Aggregate";
        }
        return "Normal";
    }

    public DescriptorEventManager getDescriptorEventManager() {
        return this.getEventManager();
    }

    public DescriptorEventManager getEventManager() {
        return this.eventManager;
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public Class getIdentityMapClass() {
        return this.identityMapClass;
    }

    public int getIdentityMapSize() {
        return this.identityMapSize;
    }

    public InheritancePolicy getDescriptorInheritancePolicy() {
        return this.getInheritancePolicy();
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new InheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public InheritancePolicy getInheritancePolicyOrNull() {
        return this.inheritancePolicy;
    }

    public InstantiationPolicy getInstantiationPolicy() {
        return this.instantiationPolicy;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public List<DatabaseMapping> getLockableMappings() {
        if (this.lockableMappings == null) {
            this.lockableMappings = new ArrayList<DatabaseMapping>();
        }
        return this.lockableMappings;
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        Enumeration<DatabaseMapping> mappingsNum = this.mappings.elements();
        while (mappingsNum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsNum.nextElement();
            if (mapping.getAttributeName() == null || !mapping.getAttributeName().equals(attributeName)) continue;
            return mapping;
        }
        return null;
    }

    public DatabaseMapping removeMappingForAttributeName(String attributeName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(attributeName);
        this.getMappings().remove(mapping);
        return mapping;
    }

    public Vector<DatabaseMapping> getMappings() {
        return this.mappings;
    }

    public Vector getMultipleTableForeignKeyAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (!this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.addElement(association);
            }
        }
        return associations;
    }

    public Map<DatabaseTable, DatabaseTable> getMultipleTableForeignKeys() {
        return this.multipleTableForeignKeys;
    }

    public Vector<DatabaseTable> getMultipleTableInsertOrder() throws DescriptorException {
        return this.multipleTableInsertOrder;
    }

    public Vector getMultipleTablePrimaryKeyAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.addElement(association);
            }
        }
        return associations;
    }

    public ObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    public OptimisticLockingPolicy getOptimisticLockingPolicy() {
        return this.optimisticLockingPolicy;
    }

    public Vector<String> getPrimaryKeyFieldNames() {
        Vector<String> result = new Vector<String>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            result.addElement(primaryKeyFields.get(index).getQualifiedName());
        }
        return result;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public QueryKey getQueryKeyNamed(String queryKeyName) {
        return this.getQueryKeys().get(queryKeyName);
    }

    public Map<String, QueryKey> getQueryKeys() {
        return this.queryKeys;
    }

    public DescriptorQueryManager getDescriptorQueryManager() {
        return this.queryManager;
    }

    public DescriptorQueryManager getQueryManager() {
        return this.queryManager;
    }

    public DatabaseField getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public String getSequenceNumberFieldName() {
        if (this.getSequenceNumberField() == null) {
            return null;
        }
        return this.getSequenceNumberField().getQualifiedName();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DatabaseTable getTable(String tableName) throws DescriptorException {
        if (this.getTables().isEmpty()) {
            return null;
        }
        Enumeration<DatabaseTable> tables = this.getTables().elements();
        while (tables.hasMoreElements()) {
            DatabaseTable table = tables.nextElement();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        if (this.isAggregateDescriptor()) {
            return this.getDefaultTable();
        }
        throw DescriptorException.tableNotPresent(tableName, this);
    }

    public String getTableName() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().firstElement().getName();
    }

    public Vector getTableNames() {
        Vector<String> tableNames = new Vector<String>(this.getTables().size());
        Enumeration<DatabaseTable> fieldsEnum = this.getTables().elements();
        while (fieldsEnum.hasMoreElements()) {
            tableNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return tableNames;
    }

    public Vector<DatabaseTable> getTables() {
        return this.tables;
    }

    public DatabaseField getTypedField(DatabaseField field) {
        boolean mayBeMoreThanOne = this.hasMultipleTables() && !field.hasTableName();
        DatabaseField foundField = null;
        for (int j = 0; j < this.getFields().size(); ++j) {
            DatabaseField descField = this.getFields().elementAt(j);
            if (!field.equals(descField) || descField.getType() == null) continue;
            foundField = descField;
            if (!mayBeMoreThanOne || descField.getTable().equals(this.getDefaultTable())) break;
        }
        if (foundField != null) {
            foundField = (DatabaseField)foundField.clone();
            if (!field.hasTableName()) {
                foundField.setTableName("");
            }
        }
        return foundField;
    }

    public WrapperPolicy getWrapperPolicy() {
        return this.wrapperPolicy;
    }

    public boolean hasDependencyOnParts() {
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.hasDependency()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInheritance() {
        return this.inheritancePolicy != null;
    }

    public boolean hasMultipleTables() {
        return this.getTables().size() > 1;
    }

    public boolean hasPrivatelyOwnedParts() {
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isPrivateOwned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryKeyOrMapping(String attributeName) {
        return this.getQueryKeys().containsKey(attributeName) || this.getObjectBuilder().getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasWrapperPolicy() {
        return this.getWrapperPolicy() != null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        DatabaseMapping mapping2;
        int index;
        Object[] mappingsArray;
        Vector mappings;
        if (this.shouldBeReadOnly() && !session.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            session.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.isIsolated()) {
            session.getProject().setHasIsolatedClasses(true);
        }
        if (!this.hasCMPPolicy() || this.getCMPPolicy().isCMP3Policy()) {
            session.getProject().setIsPureCMP2Project(false);
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            this.getInheritancePolicy().getParentDescriptor().initialize(session);
            if (this.getInheritancePolicy().getParentDescriptor().isIsolated()) {
                this.setIsIsolated(true);
            }
        }
        if (this.shouldOrderMappings()) {
            mappings = this.getMappings();
            mappingsArray = new Object[mappings.size()];
            for (index = 0; index < mappings.size(); ++index) {
                mappingsArray[index] = mappings.elementAt(index);
            }
            TOPSort.quicksort(mappingsArray, new MappingCompare());
            mappings = NonSynchronizedVector.newInstance(mappingsArray.length);
            for (index = 0; index < mappingsArray.length; ++index) {
                mappings.addElement(mappingsArray[index]);
            }
            this.setMappings(mappings);
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            mapping2 = mappingsEnum.nextElement();
            this.validateMappingType(mapping2);
            mapping2.initialize(session);
            if (mapping2.isAggregateObjectMapping() || mapping2.isForeignReferenceMapping() && !mapping2.isDirectCollectionMapping() && !((ForeignReferenceMapping)mapping2).usesIndirection()) {
                this.getLockableMappings().add(mapping2);
            }
            Helper.addAllUniqueToVector(this.getFields(), mapping2.getFields());
        }
        if (!this.isAggregateDescriptor() && !this.isChildDescriptor() && this.usesOptimisticLocking()) {
            this.getOptimisticLockingPolicy().initializeProperties();
        }
        for (QueryKey queryKey : this.getQueryKeys().values()) {
            queryKey.initialize(this);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
            if (this.getInheritancePolicy().isChildDescriptor()) {
                for (DatabaseMapping mapping2 : this.getInheritancePolicy().getParentDescriptor().getMappings()) {
                    if (!mapping2.isAggregateObjectMapping() && (!mapping2.isForeignReferenceMapping() || mapping2.isDirectCollectionMapping() || ((ForeignReferenceMapping)mapping2).usesIndirection())) continue;
                    this.getLockableMappings().add(mapping2);
                }
            }
        }
        if (this.hasInheritance() && this.shouldOrderMappings()) {
            mappings = this.getMappings();
            mappingsArray = new Object[mappings.size()];
            for (index = 0; index < mappings.size(); ++index) {
                mappingsArray[index] = mappings.elementAt(index);
            }
            TOPSort.quicksort(mappingsArray, new MappingCompare());
            mappings = NonSynchronizedVector.newInstance(mappingsArray.length);
            for (index = 0; index < mappingsArray.length; ++index) {
                mappings.addElement(mappingsArray[index]);
            }
            this.setMappings(mappings);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(session);
        if (this.shouldOrderMappings()) {
            for (int index2 = this.getObjectBuilder().getPrimaryKeyMappings().size() - 1; index2 >= 0; --index2) {
                mapping2 = this.getObjectBuilder().getPrimaryKeyMappings().get(index2);
                if (mapping2 == null || !mapping2.isDirectToFieldMapping()) continue;
                this.getMappings().remove(mapping2);
                this.getMappings().add(0, mapping2);
                DatabaseField field = ((AbstractDirectMapping)mapping2).getField();
                this.getFields().remove(field);
                this.getFields().add(0, field);
                this.getAllFields().remove(field);
                this.getAllFields().add(0, field);
            }
        }
        if (this.usesOptimisticLocking() && !this.isChildDescriptor()) {
            this.getOptimisticLockingPolicy().initialize(session);
        }
        if (this.hasWrapperPolicy()) {
            this.getWrapperPolicy().initialize(session);
        }
        this.getQueryManager().initialize(session);
        this.getEventManager().initialize(session);
        this.getCopyPolicy().initialize(session);
        this.getInstantiationPolicy().initialize(session);
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().initialize(this, session);
        }
        if (this.hasFetchGroupManager() && !Helper.classImplementsInterface(this.javaClass, ClassConstants.FetchGroupTracker_class)) {
            session.getIntegrityChecker().handleError(DescriptorException.needToImplementFetchGroupTracker(this.javaClass, this));
        }
    }

    public void initializeAggregateInheritancePolicy(AbstractSession session) {
        ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
        parentDescriptor.getInheritancePolicy().addChildDescriptor(this);
    }

    public void initializeMultipleTablePrimaryKeyFields() {
        boolean isChild;
        int additionalTablesSize = this.getTables().size() - 1;
        boolean bl = isChild = this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
        if (isChild) {
            additionalTablesSize = this.getTables().size() - this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        if (additionalTablesSize < 1) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression joinExpression = this.getQueryManager().getMultipleTableJoinExpression();
        for (int index = this.getTables().size() - additionalTablesSize; index < this.getTables().size(); ++index) {
            Expression keyJoinExpression;
            DatabaseTable table = this.getTables().elementAt(index);
            Map<DatabaseField, DatabaseField> oldKeyMapping = this.getAdditionalTablePrimaryKeyFields().get(table);
            if (oldKeyMapping != null) {
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                for (DatabaseField sourceTableField : oldKeyMapping.keySet()) {
                    DatabaseField targetTableField = oldKeyMapping.get(sourceTableField);
                    DatabaseTable sourceTable = sourceTableField.getTable();
                    DatabaseTable targetTable = targetTableField.getTable();
                    if (!this.getFields().contains(sourceTableField)) {
                        this.getFields().addElement(sourceTableField);
                    }
                    if (!this.getFields().contains(targetTableField)) {
                        this.getFields().addElement(targetTableField);
                    }
                    keyJoinExpression = builder.getField(targetTableField).equal(builder.getField(sourceTableField));
                    joinExpression = keyJoinExpression.and(joinExpression);
                    this.getQueryManager().getTablesJoinExpressions().put(targetTable, keyJoinExpression);
                    if (!isChild) continue;
                    this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(targetTable, keyJoinExpression);
                }
                continue;
            }
            HashMap<DatabaseField, DatabaseField> newKeyMapping = new HashMap<DatabaseField, DatabaseField>(this.getPrimaryKeyFields().size() + 1);
            this.getAdditionalTablePrimaryKeyFields().put(table, newKeyMapping);
            List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
            for (int pkIndex = 0; pkIndex < primaryKeyFields.size(); ++pkIndex) {
                DatabaseField primaryKeyField = primaryKeyFields.get(pkIndex);
                DatabaseField secondaryKeyField = (DatabaseField)primaryKeyField.clone();
                secondaryKeyField.setTable(table);
                newKeyMapping.put(primaryKeyField, secondaryKeyField);
                this.getFields().addElement(secondaryKeyField);
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                keyJoinExpression = builder.getField(secondaryKeyField).equal(builder.getField(primaryKeyField));
                joinExpression = keyJoinExpression.and(joinExpression);
                this.getQueryManager().getTablesJoinExpressions().put(table, keyJoinExpression);
                if (!isChild) continue;
                this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(table, keyJoinExpression);
            }
        }
        if (joinExpression != null) {
            this.getQueryManager().setInternalMultipleTableJoinExpression(joinExpression);
        }
        if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) {
            Map tablesJoinExpressions = SQLSelectStatement.mapTableToExpression(joinExpression, this.getTables());
            this.getQueryManager().getTablesJoinExpressions().putAll(tablesJoinExpressions);
            if (isChild) {
                for (int index = this.getTables().size() - additionalTablesSize; index < this.getTables().size(); ++index) {
                    DatabaseTable table = this.getTables().elementAt(index);
                    this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(table, (Expression)tablesJoinExpressions.get(table));
                }
            }
        }
    }

    protected void initializeProperties(AbstractSession session) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor()) {
                List primaryKeyFields = (List)((ArrayList)this.getPrimaryKeyFields()).clone();
                for (int index = 0; index < primaryKeyFields.size(); ++index) {
                    DatabaseField primaryKey = (DatabaseField)primaryKeyFields.get(index);
                    this.initializePrimaryKey(primaryKey);
                }
            }
            if (this.getSequenceNumberField() != null) {
                this.buildField(this.getSequenceNumberField());
            }
        }
        this.setSessionName(session.getName());
    }

    protected void initializePrimaryKey(DatabaseField primaryKey) {
        this.buildField(primaryKey);
        if (!primaryKey.getTable().equals(this.getDefaultTable())) {
            this.getPrimaryKeyFields().remove(primaryKey);
        }
    }

    public boolean isAggregateCollectionDescriptor() {
        return this.getDescriptorType() == 3;
    }

    public boolean isAggregateDescriptor() {
        return this.getDescriptorType() == 2;
    }

    public boolean isChildDescriptor() {
        return this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
    }

    public boolean isFullyInitialized() {
        return this.initializationStage == 3;
    }

    protected boolean isInitialized(int initializationStage) {
        return this.initializationStage >= initializationStage;
    }

    public boolean isInvalid() {
        return this.initializationStage == -1;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public boolean isMultipleTableDescriptor() {
        return this.getTables().size() > 1;
    }

    public boolean isPrimaryKeySetAfterInsert(AbstractSession session) {
        return this.usesSequenceNumbers() && session.getSequencing().shouldAcquireValueAfterInsert(this.getJavaClass());
    }

    public void onlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        int index;
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            Enumeration childEnum = this.getInheritancePolicy().getChildDescriptors().elements();
            while (childEnum.hasMoreElements()) {
                ((ClassDescriptor)childEnum.nextElement()).postInitialize(session);
            }
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            mapping.postInitialize(session);
            if (this.shouldAcquireCascadedLocks()) continue;
            if (mapping instanceof ForeignReferenceMapping && !((ForeignReferenceMapping)mapping).usesIndirection()) {
                this.setShouldAcquireCascadedLocks(true);
            }
            if (!(mapping instanceof AggregateObjectMapping) || !((AggregateObjectMapping)mapping).getDescriptor().shouldAcquireCascadedLocks()) continue;
            this.setShouldAcquireCascadedLocks(true);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        for (index = this.getPrimaryKeyFields().size() - 1; index >= 0; --index) {
            DatabaseField primaryKeyField = this.getPrimaryKeyFields().get(index);
            int fieldIndex = this.getFields().indexOf(primaryKeyField);
            if (fieldIndex == -1) continue;
            primaryKeyField = this.getFields().get(fieldIndex);
            this.getPrimaryKeyFields().set(index, primaryKeyField);
        }
        for (index = 0; index < this.getFields().size(); ++index) {
            DatabaseMapping mapping;
            DatabaseField field = this.getFields().elementAt(index);
            if (field.getType() == null && (mapping = this.getObjectBuilder().getMappingForField(field)) != null) {
                field.setType(mapping.getFieldClassification(field));
            }
            field.setIndex(index);
        }
        this.validateAfterInitialization(session);
        this.checkDatabase(session);
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getObjectChangePolicy().initialize(session, this);
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            try {
                DatabaseMapping mapping = mappingsEnum.nextElement();
                mapping.preInitialize(session);
            }
            catch (DescriptorException exception) {
                session.getIntegrityChecker().handleError(exception);
            }
        }
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(session);
        } else {
            this.setDefaultTable();
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (!this.isAggregateDescriptor()) {
            this.adjustMultipleTableInsertOrder();
            this.initializeMultipleTablePrimaryKeyFields();
        }
        this.getQueryManager().preInitialize(session);
    }

    protected void prepareCascadeLockingPolicy(DatabaseMapping mapping) {
        if (mapping.isPrivateOwned() && mapping.isForeignReferenceMapping()) {
            if (mapping.isCascadedLockingSupported()) {
                if (((ForeignReferenceMapping)mapping).hasCustomSelectionQuery()) {
                    throw ValidationException.unsupportedCascadeLockingMappingWithCustomQuery(mapping);
                }
                if (this.isAggregateDescriptor() || this.isAggregateCollectionDescriptor()) {
                    throw ValidationException.unsupportedCascadeLockingDescriptor(this);
                }
                mapping.prepareCascadeLockingPolicy();
            } else {
                throw ValidationException.unsupportedCascadeLockingMapping(mapping);
            }
        }
    }

    protected void preInitializeInheritancePolicy(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor() && this.requiresInitialization()) {
            if (this.getInheritancePolicy().getParentClass().equals(this.getJavaClass())) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            parentDescriptor.getInheritancePolicy().addChildDescriptor(this);
            this.getInheritancePolicy().setParentDescriptor(parentDescriptor);
            parentDescriptor.preInitialize(session);
        }
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.getObjectBuilder().rehashFieldDependancies(session);
        Enumeration<DatabaseMapping> enumtr = this.getMappings().elements();
        while (enumtr.hasMoreElements()) {
            enumtr.nextElement().rehashFieldDependancies(session);
        }
    }

    public void reInitializeJoinedAttributes() {
        if (!this.isInitialized(3)) {
            return;
        }
        this.getObjectBuilder().initializeJoinedAttributes();
        if (this.hasInheritance()) {
            Vector children = this.getInheritancePolicy().getChildDescriptors();
            for (int i = 0; i < children.size(); ++i) {
                InheritancePolicy child = (InheritancePolicy)children.elementAt(0);
                child.getDescriptor().reInitializeJoinedAttributes();
            }
        }
    }

    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    public boolean requiresInitialization() {
        return !this.isAggregateDescriptor();
    }

    protected void selfValidationAfterInitialization(AbstractSession session) throws DescriptorException {
        if ((!this.hasInheritance() || !this.getInheritancePolicy().shouldReadSubclasses() && !Modifier.isAbstract(this.getJavaClass().getModifiers())) && session.getIntegrityChecker().shouldCheckInstantiationPolicy()) {
            this.getInstantiationPolicy().buildNewInstance();
        }
        this.getObjectBuilder().validate(session);
    }

    protected void selfValidationBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            if (parentDescriptor == null) {
                session.getIntegrityChecker().handleError(DescriptorException.parentDescriptorNotSpecified(this.getInheritancePolicy().getParentClass().getName(), this));
            }
        } else if (this.getTables().isEmpty() && !this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.tableNotSpecified(this));
        }
        if (!this.isChildDescriptor() && !this.isAggregateDescriptor() && this.getPrimaryKeyFieldNames().isEmpty()) {
            session.getIntegrityChecker().handleError(DescriptorException.primaryKeyFieldsNotSepcified(this));
        }
        if (this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class && this.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            session.getIntegrityChecker().handleError(DescriptorException.identityMapNotSpecified(this));
        }
        if (this.getSequenceNumberName() != null && this.getSequenceNumberField() == null || this.getSequenceNumberName() == null && this.getSequenceNumberField() != null) {
            session.getIntegrityChecker().handleError(DescriptorException.sequenceNumberPropertyNotSpecified(this));
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(DatabaseTable table, DatabaseField field1, DatabaseField field2) {
        Map<DatabaseField, DatabaseField> tableAdditionalPKFields = this.getAdditionalTablePrimaryKeyFields().get(table);
        if (tableAdditionalPKFields == null) {
            tableAdditionalPKFields = new HashMap<DatabaseField, DatabaseField>(2);
            this.getAdditionalTablePrimaryKeyFields().put(table, tableAdditionalPKFields);
        }
        tableAdditionalPKFields.put(field1, field2);
    }

    protected void toggleAdditionalTablePrimaryKeyFields(DatabaseTable targetTable, DatabaseTable sourceTable) {
        Map<DatabaseField, DatabaseField> targetTableAdditionalPKFields = this.getAdditionalTablePrimaryKeyFields().get(targetTable);
        if (targetTableAdditionalPKFields != null) {
            for (DatabaseField sourceField : targetTableAdditionalPKFields.keySet()) {
                DatabaseField targetField = targetTableAdditionalPKFields.get(sourceField);
                this.setAdditionalTablePrimaryKeyFields(sourceTable, targetField, sourceField);
            }
            targetTableAdditionalPKFields.clear();
        }
    }

    public void setAdditionalTablePrimaryKeyFields(Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields) {
        this.additionalTablePrimaryKeyFields = additionalTablePrimaryKeyFields;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    protected void setAllFields(Vector<DatabaseField> allFields) {
        this.allFields = allFields;
    }

    public void setAmendmentClass(Class amendmentClass) {
        this.amendmentClass = amendmentClass;
    }

    public void setAmendmentClassName(String amendmentClassName) {
        this.amendmentClassName = amendmentClassName;
    }

    public void setAmendmentMethodName(String amendmentMethodName) {
        this.amendmentMethodName = amendmentMethodName;
    }

    public void setObjectChangePolicy(ObjectChangePolicy policy) {
        this.changePolicy = policy;
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy policy) {
        this.cacheInvalidationPolicy = policy;
    }

    public void setConstraintDependencies(Vector constraintDependencies) {
        this.constraintDependencies = constraintDependencies;
    }

    public void setCopyPolicy(CopyPolicy policy) {
        this.copyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setDefaultTable() {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(this.extractDefaultTable());
        }
    }

    public void setDefaultTable(DatabaseTable defaultTable) {
        this.defaultTable = defaultTable;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.setDefaultTable(new DatabaseTable(defaultTableName));
    }

    public void setDescriptorType(int descriptorType) {
        this.descriptorType = descriptorType;
    }

    public void setDescriptorTypeValue(String value) {
        if (value.equals("Aggregate collection")) {
            this.descriptorIsAggregateCollection();
        } else if (value.equals("Aggregate")) {
            this.descriptorIsAggregate();
        } else {
            this.descriptorIsNormal();
        }
    }

    public void setEventManager(DescriptorEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            eventManager.setDescriptor(this);
        }
    }

    public void setExistenceChecking(String token) throws DescriptorException {
        this.getQueryManager().setExistenceCheck(token);
    }

    public void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setIdentityMapClass(Class theIdentityMapClass) {
        this.identityMapClass = theIdentityMapClass;
    }

    public void setIdentityMapSize(int identityMapSize) {
        this.identityMapSize = identityMapSize;
    }

    public void setInheritancePolicy(InheritancePolicy inheritancePolicy) {
        this.inheritancePolicy = inheritancePolicy;
        if (inheritancePolicy != null) {
            inheritancePolicy.setDescriptor(this);
        }
    }

    protected void setInitializationStage(int initializationStage) {
        this.initializationStage = initializationStage;
    }

    public void setInstantiationPolicy(InstantiationPolicy instantiationPolicy) {
        this.instantiationPolicy = instantiationPolicy;
        if (instantiationPolicy != null) {
            instantiationPolicy.setDescriptor(this);
        }
    }

    public void setIsIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    public void setJavaClass(Class theJavaClass) {
        this.javaClass = theJavaClass;
    }

    public void setJavaClassName(String theJavaClassName) {
        this.javaClassName = theJavaClassName;
    }

    public void setLockableMappings(List<DatabaseMapping> lockableMappings) {
        this.lockableMappings = lockableMappings;
    }

    public void setMappings(Vector<DatabaseMapping> mappings) {
        Enumeration<DatabaseMapping> mappingsEnum = mappings.elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            if (mapping.getDescriptor() != null) continue;
            mapping.setDescriptor(this);
        }
        this.mappings = mappings;
    }

    public void setMultipleTableForeignKeyFieldNames(Vector associations) throws DescriptorException {
        Enumeration foreignKeys = associations.elements();
        while (foreignKeys.hasMoreElements()) {
            Association association = (Association)foreignKeys.nextElement();
            this.addMultipleTableForeignKeys((String)association.getKey(), (String)association.getValue(), true);
        }
    }

    protected void setMultipleTableForeignKeys(Map<DatabaseTable, DatabaseTable> newValue) {
        this.multipleTableForeignKeys = newValue;
    }

    public void setMultipleTableInsertOrder(Vector<DatabaseTable> newValue) {
        this.multipleTableInsertOrder = newValue;
    }

    public void setMultipleTablePrimaryKeyFieldNames(Vector associations) throws DescriptorException {
        Enumeration foreignKeys = associations.elements();
        while (foreignKeys.hasMoreElements()) {
            Association association = (Association)foreignKeys.nextElement();
            this.addMultipleTableForeignKeys((String)association.getKey(), (String)association.getValue(), true);
        }
    }

    protected void setObjectBuilder(ObjectBuilder builder) {
        this.objectBuilder = builder;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        if (optimisticLockingPolicy != null) {
            optimisticLockingPolicy.setDescriptor(this);
        }
    }

    public void setPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyFieldName(fieldName);
    }

    public void setPrimaryKeyFieldNames(Vector primaryKeyFieldsName) {
        this.setPrimaryKeyFields(new ArrayList<DatabaseField>(primaryKeyFieldsName.size()));
        Enumeration keyEnum = primaryKeyFieldsName.elements();
        while (keyEnum.hasMoreElements()) {
            this.addPrimaryKeyFieldName((String)keyEnum.nextElement());
        }
    }

    public void setPrimaryKeyFields(List<DatabaseField> thePrimaryKeyFields) {
        this.primaryKeyFields = thePrimaryKeyFields;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public void setQueryKeys(Map<String, QueryKey> queryKeys) {
        this.queryKeys = queryKeys;
    }

    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    public void setSequenceNumberField(DatabaseField sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public void setSequenceNumberFieldName(String fieldName) {
        if (fieldName == null) {
            this.setSequenceNumberField(null);
        } else {
            this.setSequenceNumberField(new DatabaseField(fieldName));
        }
    }

    public void setSequenceNumberName(String name) {
        this.sequenceNumberName = name;
    }

    protected void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setShouldAlwaysConformResultsInUnitOfWork(boolean shouldAlwaysConformResultsInUnitOfWork) {
        this.shouldAlwaysConformResultsInUnitOfWork = shouldAlwaysConformResultsInUnitOfWork;
    }

    public void setShouldAlwaysRefreshCache(boolean shouldAlwaysRefreshCache) {
        this.shouldAlwaysRefreshCache = shouldAlwaysRefreshCache;
    }

    public void setShouldBeReadOnly(boolean shouldBeReadOnly) {
        this.shouldBeReadOnly = shouldBeReadOnly;
    }

    public void setReadOnly() {
        this.setShouldBeReadOnly(true);
    }

    public void setShouldDisableCacheHits(boolean shouldDisableCacheHits) {
        this.shouldDisableCacheHits = shouldDisableCacheHits;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean shouldOnlyRefreshCacheIfNewerVersion) {
        this.shouldOnlyRefreshCacheIfNewerVersion = shouldOnlyRefreshCacheIfNewerVersion;
    }

    public void setShouldOrderMappings(boolean shouldOrderMappings) {
        this.shouldOrderMappings = shouldOrderMappings;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public void setTableName(String tableName) throws DescriptorException {
        if (!this.getTables().isEmpty()) {
            throw DescriptorException.onlyOneTableCanBeAddedWithThisMethod(this);
        }
        this.addTableName(tableName);
    }

    public void setTableNames(Vector tableNames) {
        this.setTables(NonSynchronizedVector.newInstance(tableNames.size()));
        Enumeration tableEnum = tableNames.elements();
        while (tableEnum.hasMoreElements()) {
            this.addTableName((String)tableEnum.nextElement());
        }
    }

    public void setTableQualifier(String tableQualifier) {
        Enumeration<DatabaseTable> enumtr = this.getTables().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseTable table = enumtr.nextElement();
            table.setTableQualifier(tableQualifier);
        }
    }

    public void setTables(Vector<DatabaseTable> theTables) {
        this.tables = theTables;
    }

    public void setWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.wrapperPolicy = wrapperPolicy;
        if (wrapperPolicy != null) {
            wrapperPolicy.setDescriptor(this);
        }
    }

    public boolean shouldAlwaysConformResultsInUnitOfWork() {
        return this.shouldAlwaysConformResultsInUnitOfWork;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.shouldAlwaysRefreshCache;
    }

    public boolean shouldBeReadOnly() {
        return this.shouldBeReadOnly;
    }

    public boolean shouldDisableCacheHits() {
        return this.shouldDisableCacheHits;
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.shouldOnlyRefreshCacheIfNewerVersion;
    }

    public boolean shouldOrderMappings() {
        return this.shouldOrderMappings;
    }

    public boolean hasSimplePrimaryKey() {
        return this.hasSimplePrimaryKey;
    }

    public void setHasSimplePrimaryKey(boolean hasSimplePrimaryKey) {
        this.hasSimplePrimaryKey = hasSimplePrimaryKey;
    }

    public boolean shouldAcquireCascadedLocks() {
        return this.shouldAcquireCascadedLocks;
    }

    public void setShouldAcquireCascadedLocks(boolean shouldAcquireCascadedLocks) {
        this.shouldAcquireCascadedLocks = shouldAcquireCascadedLocks;
    }

    public boolean shouldUseCacheIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseFullIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseHardCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseNoIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseSoftCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getJavaClassName() + " --> " + this.getTables() + ")";
    }

    public void useCacheIdentityMap() {
        this.setIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useCloneCopyPolicy() {
        this.useCloneCopyPolicy("clone");
    }

    public void useCloneCopyPolicy(String cloneMethodName) {
        CloneCopyPolicy policy = new CloneCopyPolicy();
        policy.setMethodName(cloneMethodName);
        this.setCopyPolicy(policy);
    }

    public void useInstantiationCopyPolicy() {
        this.setCopyPolicy(new InstantiationCopyPolicy());
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.getInstantiationPolicy().useDefaultConstructorInstantiationPolicy();
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName);
    }

    public void useFactoryInstantiationPolicy(Class factoryClass, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(Object factory, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factory, methodName);
    }

    public void useFullIdentityMap() {
        this.setIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useHardCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useMethodInstantiationPolicy(String staticMethodName) {
        this.getInstantiationPolicy().useMethodInstantiationPolicy(staticMethodName);
    }

    public void useNoIdentityMap() {
        this.setIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useSoftCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public boolean usesOptimisticLocking() {
        return this.optimisticLockingPolicy != null;
    }

    public boolean usesVersionLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof VersionLockingPolicy;
    }

    public boolean usesSequenceNumbers() {
        return this.getSequenceNumberField() != null && this.getSequenceNumberName() != null;
    }

    public void useTimestampLocking(String writeLockFieldName) {
        this.useTimestampLocking(writeLockFieldName, true);
    }

    public void useTimestampLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        TimestampLockingPolicy policy = new TimestampLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useVersionLocking(String writeLockFieldName) {
        this.useVersionLocking(writeLockFieldName, true);
    }

    public void useVersionLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        VersionLockingPolicy policy = new VersionLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    protected void validateAfterInitialization(AbstractSession session) {
        this.selfValidationAfterInitialization(session);
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            mappings.nextElement().validateAfterInitialization(session);
        }
    }

    protected void validateBeforeInitialization(AbstractSession session) {
        this.selfValidationBeforeInitialization(session);
        Enumeration<DatabaseMapping> mappings = this.getMappings().elements();
        while (mappings.hasMoreElements()) {
            mappings.nextElement().validateBeforeInitialization(session);
        }
    }

    protected void verifyTableQualifiers(Platform platform) {
        String tableQualifier = platform.getTableQualifier();
        if (tableQualifier.length() == 0) {
            return;
        }
        Enumeration<DatabaseTable> tableEnumeration = this.getTables().elements();
        while (tableEnumeration.hasMoreElements()) {
            DatabaseTable table = tableEnumeration.nextElement();
            if (table.getTableQualifier().length() != 0) continue;
            table.setTableQualifier(tableQualifier);
        }
    }

    public CMPPolicy getCMPPolicy() {
        return this.cmpPolicy;
    }

    public void setCMPPolicy(CMPPolicy newCMPPolicy) {
        this.cmpPolicy = newCMPPolicy;
        if (this.cmpPolicy != null) {
            this.cmpPolicy.setDescriptor(this);
        }
    }

    public FetchGroupManager getFetchGroupManager() {
        return this.fetchGroupManager;
    }

    public void setFetchGroupManager(FetchGroupManager fetchGroupManager) {
        this.fetchGroupManager = fetchGroupManager;
        if (fetchGroupManager != null) {
            fetchGroupManager.setDescriptor(this);
        }
    }

    public boolean isDescriptorForCMP() {
        return this.getCMPPolicy() != null;
    }

    public boolean hasFetchGroupManager() {
        return this.fetchGroupManager != null;
    }

    public boolean hasCascadeLockingPolicies() {
        return !this.cascadeLockingPolicies.isEmpty();
    }

    public boolean hasCMPPolicy() {
        return this.cmpPolicy != null;
    }

    public FetchGroup getDefaultFetchGroup() {
        if (!this.hasFetchGroupManager()) {
            return null;
        }
        return this.getFetchGroupManager().getDefaultFetchGroup();
    }
}

