/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ExpressionIterator;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.FieldExpression;
import oracle.toplink.essentials.internal.expressions.TableAliasLookup;
import oracle.toplink.essentials.internal.expressions.TableExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.querykeys.QueryKey;

public abstract class DataExpression
extends Expression {
    protected Vector derivedTables;
    protected Vector derivedFields;
    protected Expression baseExpression;
    protected boolean hasBeenNormalized = false;
    protected TableAliasLookup tableAliases;

    public void addDerivedField(Expression addThis) {
        if (this.derivedFields == null) {
            this.derivedFields = NonSynchronizedVector.newInstance(4);
        }
        this.derivedFields.addElement(addThis);
    }

    public void addDerivedTable(Expression addThis) {
        if (this.derivedTables == null) {
            this.derivedTables = NonSynchronizedVector.newInstance(4);
        }
        this.derivedTables.addElement(addThis);
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.tableAliases == null) {
            if (this.getBaseExpression() == null) {
                return null;
            }
            return this.getBaseExpression().aliasForTable(table);
        }
        return this.tableAliases.keyAtValue(table);
    }

    protected void assignAlias(String name, DatabaseTable table) {
        this.assignAlias(new DatabaseTable(name), table);
    }

    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        if (this.tableAliases == null) {
            this.tableAliases = new TableAliasLookup();
        }
        this.tableAliases.put(alias, table);
    }

    public void clearAliases() {
        this.tableAliases = null;
    }

    public Vector copyCollection(Vector in, Dictionary alreadyDone) {
        if (in == null) {
            return null;
        }
        NonSynchronizedVector result = NonSynchronizedVector.newInstance(in.size());
        Enumeration e = in.elements();
        while (e.hasMoreElements()) {
            Expression exp = (Expression)e.nextElement();
            ((Vector)result).addElement(exp.copiedVersionFrom(alreadyDone));
        }
        return result;
    }

    public Expression existingDerivedField(DatabaseField field) {
        if (this.derivedFields == null) {
            return null;
        }
        Enumeration e = this.derivedFields.elements();
        while (e.hasMoreElements()) {
            FieldExpression exp = (FieldExpression)e.nextElement();
            if (!exp.getField().equals(field)) continue;
            return exp;
        }
        return null;
    }

    public Expression existingDerivedTable(DatabaseTable table) {
        if (this.derivedTables == null) {
            return null;
        }
        Enumeration e = this.derivedTables.elements();
        while (e.hasMoreElements()) {
            TableExpression exp = (TableExpression)e.nextElement();
            if (!exp.getTable().equals(table)) continue;
            return exp;
        }
        return null;
    }

    public DatabaseField getAliasedField() {
        return null;
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        if (this.getBaseExpression() == null) {
            return null;
        }
        return this.getBaseExpression().getBuilder();
    }

    public ClassDescriptor getDescriptor() {
        return null;
    }

    public DatabaseField getField() {
        return null;
    }

    public Expression getField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        return this.getField(field);
    }

    public Expression getField(DatabaseField field) {
        Expression existing = this.existingDerivedField(field);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedField(field);
    }

    public DatabaseMapping getMapping() {
        if (this.getBaseExpression() == null) {
            return null;
        }
        ClassDescriptor aDescriptor = ((DataExpression)this.getBaseExpression()).getDescriptor();
        if (aDescriptor == null) {
            return null;
        }
        return aDescriptor.getObjectBuilder().getMappingForAttributeName(this.getName());
    }

    public Vector getOwnedTables() {
        if (this.getDescriptor() == null) {
            return null;
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            return null;
        }
        return this.getDescriptor().getTables();
    }

    public QueryKey getQueryKeyOrNull() {
        return null;
    }

    public Expression getTable(String tableName) {
        DatabaseTable table = new DatabaseTable(tableName);
        return this.getTable(table);
    }

    public Expression getTable(DatabaseTable table) {
        Expression existing = this.existingDerivedTable(table);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedTable(table);
    }

    public TableAliasLookup getTableAliases() {
        return this.tableAliases;
    }

    public boolean hasBeenNormalized() {
        return this.hasBeenNormalized;
    }

    public boolean hasBeenAliased() {
        return this.tableAliases != null && this.tableAliases.size() != 0;
    }

    protected boolean hasDerivedFields() {
        return this.derivedFields != null;
    }

    protected boolean hasDerivedTables() {
        return this.derivedTables != null;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isDataExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator);
        }
    }

    public Expression mappingCriteria() {
        return null;
    }

    public Expression newDerivedField(DatabaseField field) {
        FieldExpression result = new FieldExpression(field, this);
        this.addDerivedField(result);
        return result;
    }

    public Expression newDerivedTable(DatabaseTable table) {
        TableExpression result = new TableExpression(table);
        result.setBaseExpression(this);
        this.addDerivedTable(result);
        return result;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.getBaseExpression() != null) {
            this.setBaseExpression(this.getBaseExpression().normalize(normalizer));
        }
        return super.normalize(normalizer);
    }

    protected void postCopyIn(Dictionary alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.clearAliases();
        if (this.baseExpression != null) {
            this.baseExpression = this.baseExpression.copiedVersionFrom(alreadyDone);
        }
        this.derivedFields = this.copyCollection(this.derivedFields, alreadyDone);
        this.derivedTables = this.copyCollection(this.derivedTables, alreadyDone);
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printField(this.getAliasedField());
    }

    protected void setBaseExpression(Expression e) {
        this.baseExpression = e;
    }

    public void setHasBeenNormalized(boolean value) {
        this.hasBeenNormalized = value;
    }

    public void setTableAliases(TableAliasLookup tableAliases) {
        if (this.tableAliases == null) {
            this.tableAliases = tableAliases;
        }
    }

    public String tableAliasesDescription() {
        if (this.tableAliases == null) {
            return "";
        }
        return this.tableAliases.toString();
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(writer, indent);
        }
    }
}

