/*
 * Decompiled with CFR 0.152.
 */
package uk.co.lucasweb.aws.v4.signer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import uk.co.lucasweb.aws.v4.signer.CanonicalHeaders;
import uk.co.lucasweb.aws.v4.signer.HttpRequest;
import uk.co.lucasweb.aws.v4.signer.encoding.URLEncoding;

class CanonicalRequest {
    private static final String S3_SERVICE = "s3";
    private static final char QUERY_PARAMETER_SEPARATOR = '&';
    private static final char QUERY_PARAMETER_VALUE_SEPARATOR = '=';
    private final String service;
    private final HttpRequest httpRequest;
    private final CanonicalHeaders headers;
    private final String contentSha256;

    CanonicalRequest(String service, HttpRequest httpRequest, CanonicalHeaders headers, String contentSha256) {
        this.service = service;
        this.httpRequest = httpRequest;
        this.headers = headers;
        this.contentSha256 = contentSha256;
    }

    String get() {
        return this.httpRequest.getMethod() + "\n" + this.normalizePath(this.httpRequest.getPath()) + "\n" + CanonicalRequest.normalizeQuery(this.httpRequest.getQuery()) + "\n" + this.headers.get() + "\n" + this.headers.getNames() + "\n" + this.contentSha256;
    }

    CanonicalHeaders getHeaders() {
        return this.headers;
    }

    public String toString() {
        return this.get();
    }

    private String normalizePath(String path) {
        if (path == null || path.isEmpty()) {
            return "/";
        }
        String encoded = URLEncoding.encodePath(path);
        if (S3_SERVICE.equals(this.service)) {
            return encoded;
        }
        try {
            return new URI("http://" + encoded).normalize().getRawPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The encoded path '" + path + "' was deemed syntactically incorrect; there is probably an internal issue with the encoding algorithm");
        }
    }

    private static String normalizeQuery(String rawQuery) {
        if (rawQuery == null || rawQuery.isEmpty()) {
            return "";
        }
        List<Parameter> parameters = CanonicalRequest.extractQueryParameters(rawQuery);
        parameters.sort((l, r) -> ((Parameter)l).name.compareTo(((Parameter)r).name));
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Parameter parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.append('&');
            }
            String name = parameter.name;
            String value = parameter.value;
            if (value == null) {
                value = "";
            }
            builder.append(URLEncoding.encodeQueryComponent(name)).append('=').append(URLEncoding.encodeQueryComponent(value));
        }
        return builder.toString();
    }

    private static List<Parameter> extractQueryParameters(String rawQuery) {
        ArrayList<Parameter> results = new ArrayList<Parameter>();
        int endIndex = rawQuery.length() - 1;
        int index = 0;
        while (0 <= index && index <= endIndex) {
            String value;
            String name;
            int nameValueSeparatorIndex = rawQuery.indexOf(61, index);
            if (nameValueSeparatorIndex < 0) {
                name = rawQuery.substring(index);
                value = null;
                index = endIndex + 1;
            } else {
                int parameterSeparatorIndex = rawQuery.indexOf(38, nameValueSeparatorIndex);
                if (parameterSeparatorIndex < 0) {
                    parameterSeparatorIndex = endIndex + 1;
                }
                name = rawQuery.substring(index, nameValueSeparatorIndex);
                value = rawQuery.substring(nameValueSeparatorIndex + 1, parameterSeparatorIndex);
                index = parameterSeparatorIndex + 1;
            }
            results.add(new Parameter(name, value));
        }
        return results;
    }

    private static final class Parameter {
        private final String name;
        private final String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

