/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import uk.co.it.modular.hamcrest.date.DayMonthYear;
import uk.co.it.modular.hamcrest.date.IsAfter;
import uk.co.it.modular.hamcrest.date.IsBefore;
import uk.co.it.modular.hamcrest.date.IsDay;
import uk.co.it.modular.hamcrest.date.IsDayOfMonth;
import uk.co.it.modular.hamcrest.date.IsLeapYear;
import uk.co.it.modular.hamcrest.date.IsSameDay;
import uk.co.it.modular.hamcrest.date.IsSameDayOfWeek;
import uk.co.it.modular.hamcrest.date.IsSameHour;
import uk.co.it.modular.hamcrest.date.IsSameInstant;
import uk.co.it.modular.hamcrest.date.IsSameMillisecond;
import uk.co.it.modular.hamcrest.date.IsSameMinute;
import uk.co.it.modular.hamcrest.date.IsSameMonth;
import uk.co.it.modular.hamcrest.date.IsSameOrAfter;
import uk.co.it.modular.hamcrest.date.IsSameOrBefore;
import uk.co.it.modular.hamcrest.date.IsSameSecond;
import uk.co.it.modular.hamcrest.date.IsSameYear;
import uk.co.it.modular.hamcrest.date.IsWithin;
import uk.co.it.modular.hamcrest.date.Months;
import uk.co.it.modular.hamcrest.date.Weekdays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateMatchers {
    public static Matcher<Date> after(Date date) {
        return IsAfter.after(date);
    }

    public static Matcher<Date> after(DayMonthYear date) {
        return IsAfter.after(date);
    }

    public static Matcher<Date> after(int year, Months month, int day) {
        return IsAfter.after(year, month, day);
    }

    public static Matcher<Date> after(int year, Months month, int date, int hour, int minute, int second) {
        return IsAfter.after(year, month, date, hour, minute, second);
    }

    public static Matcher<Date> before(Date date) {
        return IsBefore.before(date);
    }

    public static Matcher<Date> before(DayMonthYear date) {
        return IsBefore.before(date);
    }

    public static Matcher<Date> before(int year, Months month, int day) {
        return IsBefore.before(year, month, day);
    }

    public static Matcher<Date> before(int year, Months month, int date, int hour, int minute, int second) {
        return IsBefore.before(year, month, date, hour, minute, second);
    }

    @Deprecated
    public static Matcher<Date> sameWeekday(Date date) {
        return IsSameDayOfWeek.sameDayOfWeek(date);
    }

    @Deprecated
    public static Matcher<Date> sameWeekday(Weekdays weekday) {
        return IsSameDayOfWeek.sameDayOfWeek(weekday);
    }

    public static Matcher<Date> sameDayOfWeek(Date date) {
        return IsSameDayOfWeek.sameDayOfWeek(date);
    }

    public static Matcher<Date> sameDayOfWeek(Weekdays weekday) {
        return IsSameDayOfWeek.sameDayOfWeek(weekday);
    }

    public static Matcher<Date> sameDay(Date date) {
        return IsSameDay.sameDay(date);
    }

    public static Matcher<Date> sameDay(DayMonthYear date) {
        return IsSameDay.sameDay(date);
    }

    public static Matcher<Date> sameDay(int year, Months month, int day) {
        return IsSameDay.sameDay(year, month, day);
    }

    public static Matcher<Date> sameHour(Date date) {
        return IsSameHour.sameHour(date);
    }

    public static Matcher<Date> sameHour(int hour) {
        return IsSameHour.sameHour(hour);
    }

    public static Matcher<Date> sameInstant(Date date) {
        return IsSameInstant.sameInstant(date);
    }

    public static Matcher<Date> sameInstant(long timestamp) {
        return IsSameInstant.sameInstant(timestamp);
    }

    public static Matcher<Date> sameInstant(int year, Months month, int date, int hour, int minute, int second, int milliseconds) {
        return IsSameInstant.sameInstant(year, month, date, hour, minute, second, milliseconds);
    }

    public static Matcher<Date> sameOrBefore(Date date) {
        return IsSameOrBefore.sameOrBefore(date);
    }

    public static Matcher<Date> sameOrBefore(DayMonthYear date) {
        return IsSameOrBefore.sameOrBefore(date);
    }

    @Factory
    public static Matcher<Date> sameOrBefore(int year, Months month, int day) {
        return IsSameOrBefore.sameOrBefore(year, month, day);
    }

    @Factory
    public static Matcher<Date> sameOrBefore(int year, Months month, int date, int hour, int minute, int second) {
        return IsSameOrBefore.sameOrBefore(year, month, date, hour, minute, second);
    }

    public static Matcher<Date> sameOrAfter(Date date) {
        return IsSameOrAfter.sameOrAfter(date);
    }

    public static Matcher<Date> sameOrAfter(DayMonthYear date) {
        return IsSameOrAfter.sameOrAfter(date);
    }

    public static Matcher<Date> sameOrAfter(int year, Months month, int day) {
        return IsSameOrAfter.sameOrAfter(year, month, day);
    }

    @Factory
    public static Matcher<Date> sameOrAfter(int year, Months month, int date, int hour, int minute, int second) {
        return IsSameOrAfter.sameOrAfter(year, month, date, hour, minute, second);
    }

    public static Matcher<Date> sameMinute(Date date) {
        return IsSameMinute.sameMinute(date);
    }

    public static Matcher<Date> sameMinute(int minute) {
        return IsSameMinute.sameMinute(minute);
    }

    public static Matcher<Date> sameMonth(Date date) {
        return IsSameMonth.sameMonth(date);
    }

    public static Matcher<Date> sameMonth(Months month) {
        return IsSameMonth.sameMonth(month);
    }

    public static Matcher<Date> sameSecond(Date date) {
        return IsSameSecond.sameSecond(date);
    }

    public static Matcher<Date> sameSecond(int second) {
        return IsSameSecond.sameSecond(second);
    }

    public static Matcher<Date> sameMillisecond(Date date) {
        return IsSameMillisecond.sameMillisecond(date);
    }

    public static Matcher<Date> sameMillisecond(int millisecond) {
        return IsSameMillisecond.sameMillisecond(millisecond);
    }

    public static Matcher<Date> sameYear(Date date) {
        return IsSameYear.sameYear(date);
    }

    public static Matcher<Date> sameYear(int year) {
        return IsSameYear.sameYear(year);
    }

    public static Matcher<Date> within(long period, TimeUnit unit, Date date) {
        return IsWithin.within(period, unit, date);
    }

    public static Matcher<Date> within(long period, TimeUnit unit, DayMonthYear date) {
        return IsWithin.within(period, unit, date);
    }

    public static Matcher<Date> within(long period, TimeUnit unit, int year, Months month, int day) {
        return IsWithin.within(period, unit, year, month, day);
    }

    public static Matcher<Date> within(long period, TimeUnit unit, int year, Months month, int date, int hour, int minute, int second, int milliseconds) {
        return IsWithin.within(period, unit, year, month, date, hour, minute, second, milliseconds);
    }

    public static Matcher<Date> isYesterday() {
        return IsDay.isYesterday();
    }

    public static Matcher<Date> isToday() {
        return IsDay.isToday();
    }

    public static Matcher<Date> isTomorrow() {
        return IsDay.isTomorrow();
    }

    public static Matcher<Date> isMonday() {
        return IsSameDayOfWeek.isMonday();
    }

    public static Matcher<Date> isTuesday() {
        return IsSameDayOfWeek.isTuesday();
    }

    public static Matcher<Date> isWednesday() {
        return IsSameDayOfWeek.isWednesday();
    }

    public static Matcher<Date> isThursday() {
        return IsSameDayOfWeek.isThursday();
    }

    public static Matcher<Date> isFriday() {
        return IsSameDayOfWeek.isFriday();
    }

    public static Matcher<Date> isSaturday() {
        return IsSameDayOfWeek.isSaturday();
    }

    public static Matcher<Date> isSunday() {
        return IsSameDayOfWeek.isSunday();
    }

    public static Matcher<Date> isWeekday() {
        return IsSameDayOfWeek.isWeekday();
    }

    public static Matcher<Date> isWeekend() {
        return IsSameDayOfWeek.isWeekend();
    }

    public static Matcher<Date> isFirstDayOfMonth() {
        return IsDayOfMonth.isFirstDayOfMonth();
    }

    public static Matcher<Date> isLastDayOfMonth() {
        return IsDayOfMonth.isLastDayOfMonth();
    }

    public static Matcher<Date> isJanuary() {
        return IsSameMonth.isJanuary();
    }

    public static Matcher<Date> isFebruary() {
        return IsSameMonth.isFebruary();
    }

    public static Matcher<Date> isMarch() {
        return IsSameMonth.isMarch();
    }

    public static Matcher<Date> isApril() {
        return IsSameMonth.isApril();
    }

    public static Matcher<Date> isMay() {
        return IsSameMonth.isMay();
    }

    public static Matcher<Date> isJune() {
        return IsSameMonth.isJune();
    }

    public static Matcher<Date> isJuly() {
        return IsSameMonth.isJuly();
    }

    public static Matcher<Date> isAugust() {
        return IsSameMonth.isAugust();
    }

    public static Matcher<Date> isSeptember() {
        return IsSameMonth.isSeptember();
    }

    public static Matcher<Date> isOctober() {
        return IsSameMonth.isOctober();
    }

    public static Matcher<Date> isNovember() {
        return IsSameMonth.isNovember();
    }

    public static Matcher<Date> isDecember() {
        return IsSameMonth.isDecember();
    }

    public static Matcher<Date> isLeapYear() {
        return IsLeapYear.isLeapYear();
    }
}

