/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import uk.co.it.modular.hamcrest.date.DateFormatter;
import uk.co.it.modular.hamcrest.date.DayMonthYear;
import uk.co.it.modular.hamcrest.date.Months;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsAfter
extends TypeSafeDiagnosingMatcher<Date> {
    private final Date expected;

    public IsAfter(Date expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        if (this.expected.compareTo(actual) >= 0) {
            mismatchDesc.appendText("date is ").appendValue((Object)DateFormatter.formatDateWithMillis(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is after ").appendValue((Object)DateFormatter.formatDateWithMillis(this.expected));
    }

    @Factory
    public static Matcher<Date> after(Date date) {
        return new IsAfter(date);
    }

    @Factory
    public static Matcher<Date> after(DayMonthYear date) {
        return IsAfter.after(date.getYear(), date.getMonth(), date.getDay());
    }

    @Factory
    public static Matcher<Date> after(int year, Months month, int day) {
        return IsAfter.after(year, month, day, 23, 59, 59);
    }

    @Factory
    public static Matcher<Date> after(int year, Months month, int date, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month.calendarConstant(), date, hour, minute, second);
        calendar.set(14, 999);
        return new IsAfter(calendar.getTime());
    }
}

