/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsLeapYear
extends TypeSafeDiagnosingMatcher<Date> {
    @Factory
    public static Matcher<Date> isLeapYear() {
        return new IsLeapYear();
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        if (this.isLeapYear(actual)) {
            return true;
        }
        mismatchDesc.appendText("a leap year");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a leap year");
    }

    private boolean isLeapYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar instanceof GregorianCalendar) {
            return ((GregorianCalendar)calendar).isLeapYear(calendar.get(1));
        }
        return false;
    }
}

