/*
 * Decompiled with CFR 0.152.
 */
package uk.co.it.modular.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsMinimumDatePart
extends TypeSafeDiagnosingMatcher<Date> {
    private final int datePart;
    private final String datePartName;

    @Factory
    public static Matcher<Date> minimumDatePart(int datePart, String descriptionOfDatepart) {
        return new IsMinimumDatePart(datePart, descriptionOfDatepart);
    }

    public IsMinimumDatePart(int datePart, String datePartName) {
        this.datePart = datePart;
        this.datePartName = datePartName;
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        int actualDatePart = IsMinimumDatePart.extractDatePart(actual, this.datePart);
        int expected = IsMinimumDatePart.extractMinimumValue(actual, this.datePart);
        if (expected != actualDatePart) {
            mismatchDesc.appendText(String.valueOf(this.datePartName)).appendText(" is ").appendValue((Object)actualDatePart);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the first " + this.datePartName + " value");
    }

    private static int extractDatePart(Date date, int part) {
        return IsMinimumDatePart.convertDateToCalendar(date).get(part);
    }

    private static int extractMinimumValue(Date date, int part) {
        return IsMinimumDatePart.convertDateToCalendar(date).getActualMinimum(part);
    }

    private static Calendar convertDateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

